/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VmAllocationPolicyAbstract
implements VmAllocationPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VmAllocationPolicyAbstract.class.getSimpleName());
    private BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction;
    private Datacenter datacenter;
    private Map<Host, Long> hostFreePesMap;
    private Map<Vm, Long> usedPes;

    public VmAllocationPolicyAbstract() {
        this(null);
    }

    public VmAllocationPolicyAbstract(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        this.setDatacenter(Datacenter.NULL);
        this.setFindHostForVmFunction(findHostForVmFunction);
    }

    @Override
    public final <T extends Host> List<T> getHostList() {
        return this.datacenter.getHostList();
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public final void setDatacenter(Datacenter datacenter) {
        this.addPesFromHostsToFreePesList(Objects.requireNonNull(datacenter));
        this.datacenter = datacenter;
    }

    private void addPesFromHostsToFreePesList(Datacenter datacenter) {
        Objects.requireNonNull(datacenter);
        if (datacenter == Datacenter.NULL || datacenter != this.datacenter) {
            this.setHostFreePesMap(new HashMap<Host, Long>(datacenter.getHostList().size()));
            this.setUsedPes(new HashMap<Vm, Long>());
        }
        datacenter.getHostList().forEach(this::addPesFromHost);
    }

    public void addPesFromHost(Host host) {
        long workingPes = host.getWorkingPesNumber();
        this.hostFreePesMap.compute(host, (mapHost, freePes) -> freePes == null ? workingPes : Math.min(freePes, workingPes));
    }

    protected final Map<Host, Long> getHostFreePesMap() {
        return this.hostFreePesMap;
    }

    protected final VmAllocationPolicy setHostFreePesMap(Map<Host, Long> hostFreePesMap) {
        this.hostFreePesMap = hostFreePesMap;
        return this;
    }

    protected void addUsedPes(Vm vm) {
        this.usedPes.put(vm, vm.getNumberOfPes());
    }

    protected long removeUsedPes(Vm vm) {
        Long pes = this.usedPes.remove(vm);
        return pes == null ? 0L : pes;
    }

    protected final void setUsedPes(Map<Vm, Long> usedPes) {
        this.usedPes = Objects.requireNonNull(usedPes);
    }

    @Override
    public boolean scaleVmVertically(VerticalVmScaling scaling) {
        if (scaling.isVmUnderloaded()) {
            return this.downScaleVmVertically(scaling);
        }
        if (scaling.isVmOverloaded()) {
            return this.upScaleVmVertically(scaling);
        }
        return false;
    }

    private boolean upScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.upScaleVmNonCpuResource(scaling);
    }

    private boolean downScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.downScaleVmNonCpuResource(scaling);
    }

    private boolean scaleVmPesUpOrDown(VerticalVmScaling scaling) {
        double numberOfPesForScaling = scaling.getResourceAmountToScale();
        if (numberOfPesForScaling == 0.0) {
            return false;
        }
        if (scaling.isVmOverloaded() && this.isNotHostPesSuitableToUpScaleVm(scaling)) {
            this.showResourceIsUnavailable(scaling);
            return false;
        }
        Vm vm = scaling.getVm();
        vm.getHost().getVmScheduler().deallocatePesFromVm(vm);
        int signal = scaling.isVmUnderloaded() ? -1 : 1;
        vm.getProcessor().sumCapacity((long)numberOfPesForScaling * (long)signal);
        vm.getHost().getVmScheduler().allocatePesForVm(vm);
        return true;
    }

    private boolean isNotHostPesSuitableToUpScaleVm(VerticalVmScaling scaling) {
        Vm vm = scaling.getVm();
        double numberOfPesForScaling = scaling.getResourceAmountToScale();
        List<Double> additionalVmMips = LongStream.range(0L, (long)numberOfPesForScaling).mapToObj(i -> vm.getMips()).collect(Collectors.toList());
        return !vm.getHost().getVmScheduler().isSuitableForVm(vm, additionalVmMips);
    }

    private boolean isRequestingCpuScaling(VerticalVmScaling scaling) {
        return Processor.class.equals(scaling.getResourceClass());
    }

    private boolean upScaleVmNonCpuResource(VerticalVmScaling scaling) {
        double extraAmountToAllocate;
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable hostResource = scaling.getVm().getHost().getResource(resourceClass);
        if (!hostResource.isAmountAvailable(extraAmountToAllocate = scaling.getResourceAmountToScale())) {
            return false;
        }
        ResourceProvisioner provisioner = scaling.getVm().getHost().getProvisioner(resourceClass);
        ResourceManageable vmResource = scaling.getVm().getResource(resourceClass);
        double newTotalVmResource = (double)vmResource.getCapacity() + extraAmountToAllocate;
        if (!provisioner.allocateResourceForVm(scaling.getVm(), newTotalVmResource)) {
            this.showResourceIsUnavailable(scaling);
            return false;
        }
        LOGGER.info("{}: {}: {} more {} allocated to {}: new capacity is {}. Current resource usage is {}%", new Object[]{scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), (long)extraAmountToAllocate, resourceClass.getSimpleName(), scaling.getVm(), vmResource.getCapacity(), vmResource.getPercentUtilization() * 100.0});
        return true;
    }

    private void showResourceIsUnavailable(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable hostResource = scaling.getVm().getHost().getResource(resourceClass);
        double extraAmountToAllocate = scaling.getResourceAmountToScale();
        LOGGER.warn("{}: {}: {} requested more {} of {} capacity but the {} has just {} of available {}", new Object[]{scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), scaling.getVm(), (long)extraAmountToAllocate, resourceClass.getSimpleName(), scaling.getVm().getHost(), hostResource.getAvailableResource(), resourceClass.getSimpleName()});
    }

    private boolean downScaleVmNonCpuResource(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable vmResource = scaling.getVm().getResource(resourceClass);
        double amountToDeallocate = scaling.getResourceAmountToScale();
        ResourceProvisioner provisioner = scaling.getVm().getHost().getProvisioner(resourceClass);
        double newTotalVmResource = (double)vmResource.getCapacity() - amountToDeallocate;
        if (!provisioner.allocateResourceForVm(scaling.getVm(), newTotalVmResource)) {
            LOGGER.error("{}: {}: {} requested to reduce {} capacity by {} but an unexpected error occurred and the resource was not resized", new Object[]{scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), scaling.getVm(), resourceClass.getSimpleName(), (long)amountToDeallocate});
            return false;
        }
        LOGGER.info("{}: {}: {} {} deallocated from {}: new capacity is {}. Current resource usage is {}%", new Object[]{scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), (long)amountToDeallocate, resourceClass.getSimpleName(), scaling.getVm(), vmResource.getCapacity(), vmResource.getPercentUtilization() * 100.0});
        return true;
    }

    @Override
    public boolean allocateHostForVm(Vm vm) {
        if (this.getHostList().isEmpty()) {
            LOGGER.error("{}: {}: {} could not be allocated because there isn't any Host for Datacenter {}", new Object[]{vm.getSimulation().clock(), vm, this.getDatacenter().getId()});
            return false;
        }
        if (vm.isCreated()) {
            return false;
        }
        Optional<Host> optional = this.findHostForVm(vm);
        if (optional.isPresent()) {
            return this.allocateHostForVm(vm, optional.get());
        }
        LOGGER.warn("{}: {}: No suitable host found for {} in {}", new Object[]{vm.getSimulation().clock(), this.getClass().getSimpleName(), vm, this.datacenter});
        return false;
    }

    @Override
    public boolean allocateHostForVm(Vm vm, Host host) {
        if (host.createVm(vm)) {
            this.addUsedPes(vm);
            this.getHostFreePesMap().compute(host, (h, previousFreePes) -> previousFreePes - vm.getNumberOfPes());
            LOGGER.info("{}: {}: {} has been allocated to {}", new Object[]{vm.getSimulation().clock(), this.getClass().getSimpleName(), vm, host});
            return true;
        }
        LOGGER.error("{}: Creation of {} on {} failed", new Object[]{vm.getSimulation().clock(), vm, host});
        return false;
    }

    @Override
    public void deallocateHostForVm(Vm vm) {
        Host previousHost = vm.getHost();
        vm.getHost().destroyVm(vm);
        long pes = this.removeUsedPes(vm);
        if (previousHost != Host.NULL) {
            this.getHostFreePesMap().compute(previousHost, (host, freePes) -> freePes == null ? pes : freePes + pes);
        }
    }

    @Override
    public final void setFindHostForVmFunction(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        this.findHostForVmFunction = findHostForVmFunction;
    }

    @Override
    public final Optional<Host> findHostForVm(Vm vm) {
        Optional<Host> optional = this.findHostForVmFunction == null ? this.defaultFindHostForVm(vm) : this.findHostForVmFunction.apply(this, vm);
        return optional.map(host -> host.setActive(true));
    }

    protected abstract Optional<Host> defaultFindHostForVm(Vm var1);

    @Override
    public Map<Vm, Host> getOptimizedAllocationMap(List<? extends Vm> vmList) {
        return Collections.emptyMap();
    }
}

