/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.migration;

import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.Map;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigration;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.resources.ResourceCapacity;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.vms.Vm;

public class VmAllocationPolicyMigrationLocalRegression
extends VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit {
    private double schedulingInterval;

    public VmAllocationPolicyMigrationLocalRegression(VmSelectionPolicy vmSelectionPolicy) {
        super(vmSelectionPolicy);
    }

    public VmAllocationPolicyMigrationLocalRegression(VmSelectionPolicy vmSelectionPolicy, double safetyParameter, VmAllocationPolicyMigration fallbackVmAllocationPolicy) {
        super(vmSelectionPolicy, safetyParameter, fallbackVmAllocationPolicy);
    }

    @Override
    public boolean isHostOverloaded(Host host) {
        double predictedUsageThreshold = this.getOverUtilizationThreshold(host);
        if (predictedUsageThreshold == Double.MAX_VALUE) {
            return this.getFallbackVmAllocationPolicy().isHostOverloaded(host);
        }
        return predictedUsageThreshold >= 1.0;
    }

    @Override
    public double getOverUtilizationThreshold(Host host) {
        try {
            double predictedUtilization = this.computeHostUtilizationMeasure(host);
            return predictedUtilization * this.getSafetyParameter();
        }
        catch (IllegalStateException e) {
            return Double.MAX_VALUE;
        }
    }

    @Override
    public double computeHostUtilizationMeasure(Host host) throws IllegalStateException {
        int length = 10;
        Comparator<Map.Entry> keyComparator = Comparator.comparingDouble(Map.Entry::getKey);
        double[] utilizationHistoryReversed = host.getUtilizationHistory().entrySet().stream().sorted(keyComparator.reversed()).limit(10L).mapToDouble(entry -> ((DoubleSummaryStatistics)entry.getValue()).getSum()).toArray();
        if (utilizationHistoryReversed.length < 10) {
            throw new IllegalStateException("There is not enough Host history to estimate its utilization using Local Regression");
        }
        double[] estimates = this.getParameterEstimates(utilizationHistoryReversed);
        double migrationIntervals = Math.ceil(this.getMaximumVmMigrationTime(host) / this.getSchedulingInterval());
        return estimates[0] + estimates[1] * (10.0 + migrationIntervals);
    }

    protected double[] getParameterEstimates(double ... utilizationHistoryReversed) {
        return MathUtil.getLoessParameterEstimates(utilizationHistoryReversed);
    }

    protected double getMaximumVmMigrationTime(Host host) {
        double maxRam = host.getVmList().stream().map(Vm::getRam).mapToDouble(ResourceCapacity::getCapacity).max().orElse(0.0);
        return maxRam / (double)(host.getBw().getCapacity() / 16L);
    }

    public final VmAllocationPolicyMigrationLocalRegression setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = schedulingInterval;
        return this;
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }
}

