/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.CustomerEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.listeners.DatacenterBrokerEventInfo;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public abstract class DatacenterBrokerAbstract
extends CloudSimEntity
implements DatacenterBroker {
    private static final Function<Vm, Double> DEF_VM_DESTRUCTION_DELAY_FUNCTION = vm -> -1.0;
    private final List<EventListener<DatacenterBrokerEventInfo>> onVmsCreatedListeners;
    private Vm lastSelectedVm;
    private Datacenter lastSelectedDc;
    private final Map<Vm, Datacenter> vmCreationRequestsMap;
    private final List<Vm> vmWaitingList;
    private final List<Vm> vmExecList;
    private final List<Vm> vmCreatedList;
    private final List<Cloudlet> cloudletWaitingList;
    private final List<Cloudlet> cloudletSubmittedList;
    private final List<Cloudlet> cloudletsFinishedList;
    private final List<Cloudlet> cloudletsCreatedList;
    private boolean wereThereWaitingCloudlets;
    private final Map<Cloudlet, Datacenter> cloudletCreationRequestsMap;
    private Supplier<Datacenter> datacenterSupplier;
    private Supplier<Datacenter> fallbackDatacenterSupplier;
    private Function<Cloudlet, Vm> vmMapper;
    private Comparator<Vm> vmComparator;
    private Comparator<Cloudlet> cloudletComparator;
    private int vmCreationRequests;
    private int vmCreationAcks;
    private List<Datacenter> datacenterList;
    private final Set<Datacenter> datacenterRequestedList;
    private Cloudlet lastSubmittedCloudlet;
    private Vm lastSubmittedVm;
    private Function<Vm, Double> vmDestructionDelayFunction;

    public DatacenterBrokerAbstract(CloudSim simulation) {
        this(simulation, "");
    }

    public DatacenterBrokerAbstract(CloudSim simulation, String name) {
        super(simulation);
        if (!name.isEmpty()) {
            this.setName(name);
        }
        this.onVmsCreatedListeners = new ArrayList<EventListener<DatacenterBrokerEventInfo>>();
        this.lastSubmittedCloudlet = Cloudlet.NULL;
        this.lastSubmittedVm = Vm.NULL;
        this.lastSelectedVm = Vm.NULL;
        this.lastSelectedDc = Datacenter.NULL;
        this.vmCreationRequests = 0;
        this.vmCreationAcks = 0;
        this.vmWaitingList = new ArrayList<Vm>();
        this.vmExecList = new ArrayList<Vm>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.cloudletWaitingList = new ArrayList<Cloudlet>();
        this.cloudletsFinishedList = new ArrayList<Cloudlet>();
        this.cloudletsCreatedList = new ArrayList<Cloudlet>();
        this.cloudletSubmittedList = new ArrayList<Cloudlet>();
        this.setDatacenterList(new TreeSet<Datacenter>());
        this.datacenterRequestedList = new TreeSet<Datacenter>();
        this.vmCreationRequestsMap = new HashMap<Vm, Datacenter>();
        this.cloudletCreationRequestsMap = new HashMap<Cloudlet, Datacenter>();
        this.setDefaultPolicies();
        this.vmDestructionDelayFunction = DEF_VM_DESTRUCTION_DELAY_FUNCTION;
    }

    private void setDefaultPolicies() {
        this.datacenterSupplier = () -> Datacenter.NULL;
        this.fallbackDatacenterSupplier = this.datacenterSupplier;
        this.vmMapper = cloudlet -> Vm.NULL;
    }

    @Override
    public void submitVmList(List<? extends Vm> list, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        this.submitVmList(list);
    }

    @Override
    public void submitVmList(List<? extends Vm> list) {
        this.sortVmsIfComparatorIsSet(list);
        this.setBrokerForEntities(list);
        this.lastSubmittedVm = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedVm);
        this.vmWaitingList.addAll(list);
        if (this.isStarted() && !list.isEmpty()) {
            LOGGER.info("{}: {}: List of {} VMs submitted to the broker during simulation execution. VMs creation request sent to Datacenter.", new Object[]{this.getSimulation().clock(), this.getName(), list.size()});
            this.requestDatacenterToCreateWaitingVms();
        }
    }

    private void setBrokerForEntities(List<? extends CustomerEntity> customerEntities) {
        customerEntities.forEach(e -> e.setBroker(this));
    }

    private <T extends CustomerEntity> T setIdForEntitiesWithoutOne(List<? extends T> list, T lastSubmittedEntity) {
        return (T)(Simulation.setIdForEntitiesWithoutOne(list, lastSubmittedEntity) ? (CustomerEntity)list.get(list.size() - 1) : lastSubmittedEntity);
    }

    private void sortVmsIfComparatorIsSet(List<? extends Vm> list) {
        if (this.vmComparator != null) {
            list.sort(this.vmComparator);
        }
    }

    @Override
    public void submitVm(Vm vm) {
        Objects.requireNonNull(vm);
        if (vm == Vm.NULL) {
            return;
        }
        ArrayList<Vm> newList = new ArrayList<Vm>(1);
        newList.add(vm);
        this.submitVmList(newList);
    }

    @Override
    public void submitCloudlet(Cloudlet cloudlet) {
        Objects.requireNonNull(cloudlet);
        if (cloudlet == Cloudlet.NULL) {
            return;
        }
        ArrayList<Cloudlet> newList = new ArrayList<Cloudlet>(1);
        newList.add(cloudlet);
        this.submitCloudletList(newList);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list, double submissionDelay) {
        this.submitCloudletList(list, Vm.NULL, submissionDelay);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list, Vm vm) {
        this.submitCloudletList(list, vm, -1.0);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list, Vm vm, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        this.bindCloudletsToVm(list, vm);
        this.submitCloudletList(list);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list) {
        if (list.isEmpty()) {
            return;
        }
        this.sortCloudletsIfComparatorIsSet(list);
        this.setBrokerForEntities(list);
        this.lastSubmittedCloudlet = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedCloudlet);
        this.cloudletSubmittedList.addAll(list);
        this.setSimulationForCloudletUtilizationModels(list);
        this.cloudletWaitingList.addAll(list);
        this.wereThereWaitingCloudlets = true;
        if (!this.isStarted()) {
            return;
        }
        LOGGER.info("{}: {}: List of {} Cloudlets submitted to the broker during simulation execution.", new Object[]{this.getSimulation().clock(), this.getName(), list.size()});
        if (this.allNonDelayedVmsCreated()) {
            LOGGER.info("Cloudlets creation request sent to Datacenter.");
            this.requestDatacentersToCreateWaitingCloudlets();
            this.notifyOnVmsCreatedListeners();
        } else {
            LOGGER.info("Waiting creation of {} VMs to send Cloudlets creation request to Datacenter.", (Object)this.vmWaitingList.size());
        }
    }

    private boolean allNonDelayedVmsCreated() {
        return this.vmWaitingList.stream().noneMatch(vm -> vm.getSubmissionDelay() == 0.0);
    }

    private void bindCloudletsToVm(List<? extends Cloudlet> cloudlets, Vm vm) {
        if (Vm.NULL.equals(vm)) {
            return;
        }
        cloudlets.forEach(c -> c.setVm(vm));
    }

    private void sortCloudletsIfComparatorIsSet(List<? extends Cloudlet> cloudlets) {
        if (this.cloudletComparator != null) {
            cloudlets.sort(this.cloudletComparator);
        }
    }

    private void setSimulationForCloudletUtilizationModels(List<? extends Cloudlet> cloudlets) {
        for (Cloudlet cloudlet : cloudlets) {
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelCpu());
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelBw());
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelRam());
        }
    }

    private void setSimulationForUtilizationModel(UtilizationModel cloudletUtilizationModel) {
        if (cloudletUtilizationModel.getSimulation() == null || cloudletUtilizationModel.getSimulation() == Simulation.NULL) {
            cloudletUtilizationModel.setSimulation(this.getSimulation());
        }
    }

    private void setDelayForEntitiesWithNoDelay(List<? extends CustomerEntity> entities, double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        entities.stream().filter(entity -> entity.getSubmissionDelay() <= 0.0).forEach(entity -> entity.setSubmissionDelay(submissionDelay));
    }

    @Override
    public boolean bindCloudletToVm(Cloudlet cloudlet, Vm vm) {
        if (!this.cloudletWaitingList.contains(cloudlet)) {
            return false;
        }
        cloudlet.setVm(vm);
        return true;
    }

    @Override
    public void processEvent(SimEvent evt) {
        if (this.processCloudletEvents(evt) || this.processVmEvents(evt) || this.processGeneralEvents(evt)) {
            return;
        }
        LOGGER.trace("{}: {}: Unknown event {} received.", new Object[]{this.getSimulation().clock(), this, evt.getTag()});
    }

    private boolean processCloudletEvents(SimEvent evt) {
        switch (evt.getTag()) {
            case 15: {
                this.processCloudletReturn(evt);
                return true;
            }
            case 23: {
                this.processCloudletReady(evt);
                return true;
            }
            case 27: {
                ((Runnable)evt.getData()).run();
                return true;
            }
            case 19: {
                this.processCloudletPause(evt);
                return true;
            }
            case 18: {
                this.processCloudletCancel(evt);
                return true;
            }
            case -25: {
                this.processCloudletFinish(evt);
                return true;
            }
            case 24: {
                this.processCloudletFail(evt);
                return true;
            }
        }
        return false;
    }

    private boolean processVmEvents(SimEvent evt) {
        switch (evt.getTag()) {
            case 32: {
                this.processVmCreateResponseFromDatacenter(evt);
                return true;
            }
            case 33: {
                this.requestIdleVmDestruction((Vm)evt.getData());
                return true;
            }
            case 42: {
                this.requestVmVerticalScaling(evt);
                return true;
            }
        }
        return false;
    }

    private boolean processGeneralEvents(SimEvent evt) {
        if (evt.getTag() == 4) {
            this.processDatacenterListRequest(evt);
            return true;
        }
        if (evt.getTag() == -1) {
            this.shutdownEntity();
            return true;
        }
        return false;
    }

    private void processCloudletReady(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        if (cloudlet.getStatus() == Cloudlet.Status.PAUSED) {
            this.logCloudletStatusChange(cloudlet, "resume execution of");
        } else {
            this.logCloudletStatusChange(cloudlet, "start executing");
        }
        cloudlet.getVm().getCloudletScheduler().cloudletReady(cloudlet);
    }

    private void processCloudletPause(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "deschedule (pause)");
        cloudlet.getVm().getCloudletScheduler().cloudletPause(cloudlet);
    }

    private void processCloudletCancel(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "cancel execution of");
        cloudlet.getVm().getCloudletScheduler().cloudletCancel(cloudlet);
    }

    private void processCloudletFinish(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "finish running");
        if (cloudlet.getFinishedLengthSoFar() == 0L) {
            this.updateHostProcessing(cloudlet);
        }
        if (cloudlet.getFinishedLengthSoFar() == 0L) {
            cloudlet.getVm().getCloudletScheduler().cloudletFail(cloudlet);
            return;
        }
        long prevLength = cloudlet.getLength();
        cloudlet.setLength(cloudlet.getFinishedLengthSoFar());
        this.updateHostProcessing(cloudlet);
        if (prevLength < 0L) {
            double delay = cloudlet.getSimulation().getMinTimeBetweenEvents();
            Datacenter dc = cloudlet.getVm().getHost().getDatacenter();
            dc.schedule(delay, 41, null);
        }
    }

    private void updateHostProcessing(Cloudlet cloudlet) {
        cloudlet.getVm().getHost().updateProcessing(this.getSimulation().clock());
    }

    private void logCloudletStatusChange(Cloudlet cloudlet, String status) {
        String msg = cloudlet.getJobId() > 0L ? String.format("(job %d) ", cloudlet.getJobId()) : "";
        LOGGER.info("{}: {}: Request to {} {} {}received.", new Object[]{this.getSimulation().clock(), this, status, cloudlet, msg});
    }

    private void processCloudletFail(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        cloudlet.getVm().getCloudletScheduler().cloudletFail(cloudlet);
    }

    private void requestVmVerticalScaling(SimEvent evt) {
        if (!(evt.getData() instanceof VerticalVmScaling)) {
            return;
        }
        VerticalVmScaling scaling = (VerticalVmScaling)evt.getData();
        this.getSimulation().sendNow(evt.getSource(), scaling.getVm().getHost().getDatacenter(), 42, scaling);
    }

    private void processDatacenterListRequest(SimEvent evt) {
        this.setDatacenterList((Set)evt.getData());
        LOGGER.info("{}: {}: List of {} datacenters(s) received.", new Object[]{this.getSimulation().clock(), this.getName(), this.datacenterList.size()});
        this.requestDatacenterToCreateWaitingVms();
    }

    private boolean processVmCreateResponseFromDatacenter(SimEvent evt) {
        Vm vm = (Vm)evt.getData();
        boolean vmCreated = false;
        ++this.vmCreationAcks;
        if (vm.isCreated()) {
            this.processSuccessVmCreationInDatacenter(vm, vm.getHost().getDatacenter());
            vmCreated = true;
        } else {
            this.processFailedVmCreationInDatacenter(vm, this.lastSelectedDc);
        }
        if (this.allNonDelayedVmsCreated()) {
            this.requestDatacentersToCreateWaitingCloudlets();
            this.notifyOnVmsCreatedListeners();
        } else if (this.getVmCreationRequests() == this.getVmCreationAcks()) {
            this.requestCreationOfWaitingVmsToFallbackDatacenter();
        }
        return vmCreated;
    }

    private void notifyOnVmsCreatedListeners() {
        for (int i = 0; i < this.onVmsCreatedListeners.size(); ++i) {
            EventListener<DatacenterBrokerEventInfo> listener = this.onVmsCreatedListeners.get(i);
            listener.update(DatacenterBrokerEventInfo.of(listener, this));
        }
    }

    private void requestCreationOfWaitingVmsToFallbackDatacenter() {
        Datacenter nextDatacenter;
        this.lastSelectedDc = nextDatacenter = this.fallbackDatacenterSupplier.get();
        if (nextDatacenter != Datacenter.NULL) {
            this.clearVmCreationRequestsMapToTryNextDatacenter();
            this.requestDatacenterToCreateWaitingVms(nextDatacenter, true);
            return;
        }
        if (this.vmExecList.isEmpty()) {
            LOGGER.error("{}: {}: None of the requested {} VMs could be created because suitable Hosts weren't found in any available Datacenter. Shutting broker down...", new Object[]{this.getSimulation().clock(), this.getName(), this.vmWaitingList.size()});
            this.shutdownEntity();
            return;
        }
        LOGGER.error("{}: {}: {} of the requested {} VMs couldn't be created because suitable Hosts weren't found in any available Datacenter.", new Object[]{this.getSimulation().clock(), this.getName(), this.vmWaitingList.size(), this.getVmsNumber()});
        this.requestDatacentersToCreateWaitingCloudlets();
    }

    private int getVmsNumber() {
        return this.vmCreatedList.size() + this.vmWaitingList.size();
    }

    private void clearVmCreationRequestsMapToTryNextDatacenter() {
        for (Vm vm : this.vmWaitingList) {
            this.vmCreationRequestsMap.remove(vm);
        }
    }

    private void processSuccessVmCreationInDatacenter(Vm vm, Datacenter datacenter) {
        this.vmWaitingList.remove(vm);
        this.vmExecList.add(vm);
        this.vmCreatedList.add(vm);
    }

    private void processFailedVmCreationInDatacenter(Vm vm, Datacenter datacenter) {
        vm.notifyOnCreationFailureListeners(datacenter);
    }

    private void processCloudletReturn(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.cloudletsFinishedList.add(cloudlet);
        LOGGER.info("{}: {}: {} finished and returned to broker.", new Object[]{this.getSimulation().clock(), this.getName(), cloudlet});
        if (cloudlet.getVm().getCloudletScheduler().isEmpty()) {
            this.requestIdleVmDestruction(cloudlet.getVm());
            return;
        }
        this.requestVmDestructionAfterAllCloudletsFinished();
    }

    private void requestVmDestructionAfterAllCloudletsFinished() {
        for (int i = this.vmExecList.size() - 1; i >= 0; --i) {
            this.requestIdleVmDestruction(this.vmExecList.get(i));
        }
        if (this.cloudletWaitingList.isEmpty()) {
            return;
        }
        this.requestDatacenterToCreateWaitingVms();
    }

    private void requestIdleVmDestruction(Vm vm) {
        double delay = this.vmDestructionDelayFunction.apply(vm);
        boolean vmAlive = this.vmExecList.contains(vm);
        if (vmAlive && (delay > -1.0 && vm.isIdleEnough(delay) || this.isFinished())) {
            LOGGER.info("{}: {}: Requesting Vm {} destruction.", new Object[]{this.getSimulation().clock(), this.getName(), vm.getId()});
            this.sendNow(this.getDatacenter(vm), 33, vm);
            this.vmExecList.remove(vm);
            vmAlive = false;
        }
        if (this.isTimeToShutdownBroker() && this.isBrokerIdle()) {
            this.shutdownEntity();
            return;
        }
        if (vmAlive && delay > -1.0) {
            this.send(this, this.getDelayToCheckVmIdleness(vm), 33, vm);
        }
    }

    private double getDelayToCheckVmIdleness(Vm vm) {
        double schedulingInterval = vm.getHost().getDatacenter().getSchedulingInterval();
        double delay = this.vmDestructionDelayFunction.apply(vm);
        if (delay <= 0.0 && schedulingInterval <= 0.0) {
            return this.getSimulation().getMinTimeBetweenEvents();
        }
        if (delay <= 0.0) {
            return schedulingInterval;
        }
        return Math.min(Math.abs(delay), Math.abs(schedulingInterval));
    }

    private boolean isBrokerIdle() {
        return this.cloudletWaitingList.isEmpty() && this.vmWaitingList.isEmpty() && this.vmExecList.isEmpty();
    }

    private boolean isTimeToShutdownBroker() {
        return this.isAlive() && (!this.getSimulation().isTerminationTimeSet() || this.getSimulation().isTimeToTerminateSimulationUnderRequest());
    }

    protected void requestDatacenterToCreateWaitingVms() {
        this.lastSelectedDc = Datacenter.NULL.equals(this.lastSelectedDc) ? this.datacenterSupplier.get() : this.lastSelectedDc;
        this.requestDatacenterToCreateWaitingVms(this.lastSelectedDc);
    }

    protected void requestDatacenterToCreateWaitingVms(Datacenter datacenter) {
        this.requestDatacenterToCreateWaitingVms(datacenter, false);
    }

    protected void requestDatacenterToCreateWaitingVms(Datacenter datacenter, boolean isFallbackDatacenter) {
        int requestedVms = 0;
        for (Vm vm : this.vmWaitingList) {
            if (this.vmCreationRequestsMap.containsKey(vm)) continue;
            this.logVmCreationRequest(datacenter, isFallbackDatacenter, vm);
            this.send(datacenter, vm.getSubmissionDelay(), 32, vm);
            this.vmCreationRequestsMap.put(vm, datacenter);
            ++requestedVms;
        }
        this.datacenterRequestedList.add(datacenter);
        this.vmCreationRequests += requestedVms;
    }

    private void logVmCreationRequest(Datacenter datacenter, boolean isFallbackDatacenter, Vm vm) {
        String fallbackMsg;
        String string = fallbackMsg = isFallbackDatacenter ? " (due to lack of a suitable Host in previous one)" : "";
        if (vm.getSubmissionDelay() == 0.0) {
            LOGGER.info("{}: {}: Trying to create Vm {} in {}{}", new Object[]{this.getSimulation().clock(), this.getName(), vm.getId(), datacenter.getName(), fallbackMsg});
        } else {
            LOGGER.info("{}: {}: Creation of Vm {} in {}{} will be requested in {} seconds", new Object[]{this.getSimulation().clock(), this.getName(), vm.getId(), datacenter.getName(), fallbackMsg, vm.getSubmissionDelay()});
        }
    }

    protected void requestDatacentersToCreateWaitingCloudlets() {
        ArrayList<Cloudlet> successfullySubmitted = new ArrayList<Cloudlet>();
        for (Cloudlet cloudlet : this.cloudletWaitingList) {
            if (this.cloudletCreationRequestsMap.containsKey(cloudlet)) continue;
            this.lastSelectedVm = this.vmMapper.apply(cloudlet);
            if (this.lastSelectedVm == Vm.NULL) {
                this.logPostponingCloudletExecution(cloudlet);
                continue;
            }
            this.logCloudletCreationRequest(cloudlet);
            cloudlet.setVm(this.lastSelectedVm);
            this.send(this.getDatacenter(this.lastSelectedVm), cloudlet.getSubmissionDelay(), 16, cloudlet);
            this.cloudletCreationRequestsMap.put(cloudlet, this.getDatacenter(this.lastSelectedVm));
            this.cloudletsCreatedList.add(cloudlet);
            successfullySubmitted.add(cloudlet);
        }
        this.cloudletWaitingList.removeAll(successfullySubmitted);
        this.allWaitingCloudletsSubmittedToVm();
    }

    private void logPostponingCloudletExecution(Cloudlet cloudlet) {
        String msg = String.format("%.2f: %s: Postponing execution of Cloudlet %d. Bind Vm %d {}.", this.getSimulation().clock(), this.getName(), cloudlet.getId(), cloudlet.getVm().getId());
        if (cloudlet.getVm().getSubmissionDelay() > 0.0) {
            LOGGER.info(msg, (Object)"was requested to be created with some delay");
        } else {
            LOGGER.warn(msg, (Object)"is not available");
        }
    }

    private void logCloudletCreationRequest(Cloudlet cloudlet) {
        String delayMsg = cloudlet.getSubmissionDelay() > 0.0 ? String.format(" with a requested delay of %.0f seconds", cloudlet.getSubmissionDelay()) : "";
        LOGGER.info("{}: {}: Sending Cloudlet {} to Vm {} in {}{}.", new Object[]{this.getSimulation().clock(), this.getName(), cloudlet.getId(), this.lastSelectedVm.getId(), this.lastSelectedVm.getHost(), delayMsg});
    }

    private boolean allWaitingCloudletsSubmittedToVm() {
        if (!this.cloudletWaitingList.isEmpty()) {
            return false;
        }
        if (this.wereThereWaitingCloudlets) {
            LOGGER.info("{}: {}: All waiting Cloudlets submitted to some VM.", (Object)this.getSimulation().clock(), (Object)this.getName());
            this.wereThereWaitingCloudlets = false;
        }
        return true;
    }

    @Override
    public void shutdownEntity() {
        super.shutdownEntity();
        LOGGER.info("{}: {} is shutting down...", (Object)this.getSimulation().clock(), (Object)this.getName());
        this.requestVmDestructionAfterAllCloudletsFinished();
    }

    @Override
    public void startEntity() {
        LOGGER.info("{} is starting...", (Object)this.getName());
        this.schedule(this.getSimulation().getCloudInfoService(), 0.0, 4);
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return this.vmCreatedList;
    }

    @Override
    public <T extends Vm> List<T> getVmExecList() {
        return this.vmExecList;
    }

    @Override
    public <T extends Vm> List<T> getVmWaitingList() {
        return this.vmWaitingList;
    }

    @Override
    public Vm getWaitingVm(int index) {
        if (index >= 0 && index < this.vmWaitingList.size()) {
            return this.vmWaitingList.get(index);
        }
        return Vm.NULL;
    }

    @Override
    public List<Cloudlet> getCloudletCreatedList() {
        return this.cloudletsCreatedList;
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletWaitingList() {
        return this.cloudletWaitingList;
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletFinishedList() {
        return new ArrayList<Cloudlet>(this.cloudletsFinishedList);
    }

    protected Vm getVmFromCreatedList(int vmIndex) {
        return vmIndex >= 0 && vmIndex < this.vmExecList.size() ? this.vmExecList.get(vmIndex) : Vm.NULL;
    }

    protected int getVmCreationRequests() {
        return this.vmCreationRequests;
    }

    protected int getVmCreationAcks() {
        return this.vmCreationAcks;
    }

    protected List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    protected final void setDatacenterList(Set<Datacenter> datacenterList) {
        this.datacenterList = new ArrayList<Datacenter>(datacenterList);
    }

    protected Datacenter getDatacenter(Vm vm) {
        return vm.getHost().getDatacenter();
    }

    protected Set<Datacenter> getDatacenterRequestedList() {
        return this.datacenterRequestedList;
    }

    protected Vm getLastSelectedVm() {
        return this.lastSelectedVm;
    }

    @Override
    public final void setDatacenterSupplier(Supplier<Datacenter> datacenterSupplier) {
        this.datacenterSupplier = Objects.requireNonNull(datacenterSupplier);
    }

    @Override
    public final void setFallbackDatacenterSupplier(Supplier<Datacenter> fallbackDatacenterSupplier) {
        this.fallbackDatacenterSupplier = Objects.requireNonNull(fallbackDatacenterSupplier);
    }

    @Override
    public Function<Cloudlet, Vm> getVmMapper() {
        return this.vmMapper;
    }

    @Override
    public final void setVmMapper(Function<Cloudlet, Vm> vmMapper) {
        this.vmMapper = Objects.requireNonNull(vmMapper);
    }

    @Override
    public void setVmComparator(Comparator<Vm> comparator) {
        this.vmComparator = comparator;
    }

    @Override
    public void setCloudletComparator(Comparator<Cloudlet> comparator) {
        this.cloudletComparator = comparator;
    }

    @Override
    public DatacenterBroker addOnVmsCreatedListener(EventListener<DatacenterBrokerEventInfo> listener) {
        this.onVmsCreatedListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public DatacenterBroker removeOnVmsCreatedListener(EventListener<? extends EventInfo> listener) {
        this.onVmsCreatedListeners.remove(Objects.requireNonNull(listener));
        return this;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Function<Vm, Double> getVmDestructionDelayFunction() {
        return this.vmDestructionDelayFunction;
    }

    @Override
    public DatacenterBroker setVmDestructionDelay(double delay) {
        this.setVmDestructionDelayFunction(vm -> delay);
        return this;
    }

    @Override
    public DatacenterBroker setVmDestructionDelayFunction(Function<Vm, Double> function) {
        this.vmDestructionDelayFunction = function == null ? DEF_VM_DESTRUCTION_DELAY_FUNCTION : function;
        return this;
    }

    protected boolean isThereWaitingCloudlets() {
        return !this.cloudletWaitingList.isEmpty();
    }

    @Override
    public List<Cloudlet> getCloudletSubmittedList() {
        return this.cloudletSubmittedList;
    }

    protected abstract Vm defaultVmMapper(Cloudlet var1);
}

