/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import org.cloudbus.cloudsim.brokers.DatacenterBrokerAbstract;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.vms.Vm;

public class DatacenterBrokerSimple
extends DatacenterBrokerAbstract {
    public DatacenterBrokerSimple(CloudSim simulation) {
        this(simulation, "");
    }

    public DatacenterBrokerSimple(CloudSim simulation, String name) {
        super(simulation, name);
        this.setDatacenterSupplier(this::selectDatacenterForWaitingVms);
        this.setFallbackDatacenterSupplier(this::selectFallbackDatacenterForWaitingVms);
        this.setVmMapper(this::defaultVmMapper);
    }

    protected Datacenter selectDatacenterForWaitingVms() {
        return this.getDatacenterList().isEmpty() ? Datacenter.NULL : this.getDatacenterList().get(0);
    }

    protected Datacenter selectFallbackDatacenterForWaitingVms() {
        return this.getDatacenterList().stream().filter(dc -> !this.getDatacenterRequestedList().contains(dc)).findFirst().orElse(Datacenter.NULL);
    }

    @Override
    public Vm defaultVmMapper(Cloudlet cloudlet) {
        if (cloudlet.isBindToVm()) {
            if (this.getVmExecList().contains(cloudlet.getVm())) {
                return cloudlet.getVm();
            }
            return Vm.NULL;
        }
        return this.getVmFromCreatedList(this.getNextVmIndex());
    }

    private int getNextVmIndex() {
        if (this.getVmExecList().isEmpty()) {
            return -1;
        }
        int vmIndex = this.getVmExecList().indexOf(this.getLastSelectedVm());
        return (vmIndex + 1) % this.getVmExecList().size();
    }
}

