/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudInformationService
extends CloudSimEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudInformationService.class.getSimpleName());
    private final Set<Datacenter> datacenterList = new TreeSet<Datacenter>();
    private final Set<CloudInformationService> cisList = new TreeSet<CloudInformationService>();

    CloudInformationService(CloudSim simulation) {
        super(simulation);
    }

    @Override
    protected void startEntity() {
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case 13: {
                this.cisList.add((CloudInformationService)evt.getData());
                break;
            }
            case 14: {
                super.send(evt.getSource(), 0.0, evt.getTag(), this.cisList);
                break;
            }
            case 2: {
                this.datacenterList.add((Datacenter)evt.getData());
                break;
            }
            case 4: {
                super.send(evt.getSource(), 0.0, evt.getTag(), this.datacenterList);
            }
        }
    }

    @Override
    public void shutdownEntity() {
        super.shutdownEntity();
        LOGGER.info("{}: Notify all CloudSim Plus entities to shutdown.{}", (Object)super.getName(), (Object)System.lineSeparator());
        this.signalShutdown(this.datacenterList);
        this.signalShutdown(this.cisList);
        this.datacenterList.clear();
        this.cisList.clear();
    }

    public Set<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    private void signalShutdown(Collection<? extends SimEntity> list) {
        if (list == null) {
            return;
        }
        list.forEach(entity -> super.send((SimEntity)entity, 0.0, -1));
    }
}

