/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core.events;

import java.util.Objects;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public final class CloudSimEvent
implements SimEvent {
    private Simulation simulation;
    private final SimEvent.Type type;
    private final double time;
    private double endWaitingTime;
    private SimEntity src;
    private SimEntity dest;
    private final int tag;
    private final Object data;
    private long serial = -1L;

    public CloudSimEvent(double delay, SimEntity src, SimEntity dest, int tag, Object data) {
        this(SimEvent.Type.SEND, delay, src, dest, tag, data);
    }

    public CloudSimEvent(double delay, SimEntity dest, int tag) {
        this(delay, dest, tag, null);
    }

    public CloudSimEvent(double delay, SimEntity dest, int tag, Object data) {
        this(SimEvent.Type.SEND, delay, dest, dest, tag, data);
    }

    public CloudSimEvent(SimEntity dest, int tag) {
        this(SimEvent.Type.SEND, 0.0, dest, dest, tag, null);
    }

    public CloudSimEvent(SimEvent.Type type, double delay, SimEntity src) {
        this(type, delay, src, SimEntity.NULL, -1, null);
    }

    public CloudSimEvent(SimEvent src) {
        this(src.getType(), src.getTime(), src.getSource(), src.getDestination(), src.getTag(), src.getData());
    }

    public CloudSimEvent(SimEvent.Type type, double delay, SimEntity src, SimEntity dest, int tag, Object data) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Delay can't be negative.");
        }
        this.type = type;
        this.setSource(src);
        this.setDestination(dest);
        this.setSimulation(src.getSimulation());
        this.time = this.simulation.clock() + delay;
        this.tag = tag;
        this.data = data;
    }

    @Override
    public void setSerial(long serial) {
        this.serial = serial;
    }

    @Override
    public double getEndWaitingTime() {
        return this.endWaitingTime;
    }

    @Override
    public SimEvent setSimulation(Simulation simulation) {
        this.simulation = Objects.requireNonNull(simulation);
        return this;
    }

    @Override
    public SimEvent.Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(SimEvent evt) {
        if (evt == null) {
            return 1;
        }
        if (this.time < evt.getTime()) {
            return -1;
        }
        if (this.time > evt.getTime()) {
            return 1;
        }
        if (this.serial < evt.getSerial()) {
            return -1;
        }
        if (this == evt) {
            return 0;
        }
        return 1;
    }

    @Override
    public SimEntity getDestination() {
        return this.dest;
    }

    @Override
    public SimEntity getSource() {
        return this.src;
    }

    @Override
    public SimEntity scheduledBy() {
        return this.src;
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public SimEvent setSource(SimEntity source) {
        this.src = Objects.requireNonNull(source);
        return this;
    }

    @Override
    public SimEvent setDestination(SimEntity destination) {
        this.dest = Objects.requireNonNull(destination);
        return this;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public EventListener<? extends EventInfo> getListener() {
        return EventListener.NULL;
    }

    @Override
    public long getSerial() {
        return this.serial;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    public String toString() {
        return "Event tag = " + this.tag + " source = " + this.src.getName() + " target = " + this.dest.getName() + " time = " + this.time;
    }
}

