/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.core.Identifiable;
import org.cloudbus.cloudsim.core.Machine;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostStateHistoryEntry;
import org.cloudbus.cloudsim.power.models.PowerModel;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.provisioners.ResourceProvisionerSimple;
import org.cloudbus.cloudsim.resources.Bandwidth;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.resources.Storage;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerSpaceShared;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.vms.UtilizationHistory;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmStateHistoryEntry;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSimple
implements Host {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HostSimple.class.getSimpleName());
    private static long defaultRamCapacity = (long)Conversion.gigaToMega(10.0);
    private static long defaultBwCapacity = 1000L;
    private static long defaultStorageCapacity = (long)Conversion.gigaToMega(500.0);
    private final List<HostStateHistoryEntry> stateHistory;
    private PowerModel powerModel;
    private long id;
    private boolean failed;
    private boolean active;
    private boolean stateHistoryEnabled;
    private double startTime = -1.0;
    private double shutdownTime;
    private double totalUpTime;
    private double lastBusyTime;
    private double idleShutdownDeadline;
    private final Ram ram;
    private final Bandwidth bw;
    private Storage storage;
    private ResourceProvisioner ramProvisioner;
    private ResourceProvisioner bwProvisioner;
    private VmScheduler vmScheduler;
    private final List<Vm> vmList = new ArrayList<Vm>();
    private List<Pe> peList;
    private final Set<Vm> vmsMigratingIn;
    private final Set<Vm> vmsMigratingOut;
    private Datacenter datacenter;
    private final Set<EventListener<HostUpdatesVmsProcessingEventInfo>> onUpdateProcessingListeners;
    private Simulation simulation;
    private List<ResourceManageable> resources;
    private List<ResourceProvisioner> provisioners;
    private final List<Vm> vmCreatedList;
    private double previousUtilizationMips;

    public HostSimple(List<Pe> peList) {
        this(peList, true);
    }

    public HostSimple(List<Pe> peList, boolean activate) {
        this(defaultRamCapacity, defaultBwCapacity, defaultStorageCapacity, peList, activate);
    }

    public HostSimple(ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setPeList(peList);
    }

    public HostSimple(long ram, long bw, long storage, List<Pe> peList) {
        this(ram, bw, storage, peList, true);
    }

    public HostSimple(long ram, long bw, long storage, List<Pe> peList, boolean activate) {
        this.setId(-1L);
        this.setSimulation(Simulation.NULL);
        this.setActive(activate);
        this.idleShutdownDeadline = -1.0;
        this.ram = new Ram(ram);
        this.bw = new Bandwidth(bw);
        this.setStorage(storage);
        this.setRamProvisioner(new ResourceProvisionerSimple());
        this.setBwProvisioner(new ResourceProvisionerSimple());
        this.setVmScheduler(new VmSchedulerSpaceShared());
        this.setPeList(peList);
        this.setFailed(false);
        this.shutdownTime = -1.0;
        this.setDatacenter(Datacenter.NULL);
        this.onUpdateProcessingListeners = new HashSet<EventListener<HostUpdatesVmsProcessingEventInfo>>();
        this.resources = new ArrayList<ResourceManageable>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.provisioners = new ArrayList<ResourceProvisioner>();
        this.vmsMigratingIn = new HashSet<Vm>();
        this.vmsMigratingOut = new HashSet<Vm>();
        this.powerModel = PowerModel.NULL;
        this.stateHistory = new LinkedList<HostStateHistoryEntry>();
    }

    public static long getDefaultRamCapacity() {
        return defaultRamCapacity;
    }

    public static void setDefaultRamCapacity(long defaultCapacity) {
        Machine.validateCapacity(defaultCapacity);
        defaultRamCapacity = defaultCapacity;
    }

    public static long getDefaultBwCapacity() {
        return defaultBwCapacity;
    }

    public static void setDefaultBwCapacity(long defaultCapacity) {
        Machine.validateCapacity(defaultCapacity);
        defaultBwCapacity = defaultCapacity;
    }

    public static long getDefaultStorageCapacity() {
        return defaultStorageCapacity;
    }

    public static void setDefaultStorageCapacity(long defaultCapacity) {
        Machine.validateCapacity(defaultCapacity);
        defaultStorageCapacity = defaultCapacity;
    }

    @Override
    public double getTotalMipsCapacity() {
        return this.peList.stream().filter(Pe::isWorking).mapToDouble(Pe::getCapacity).sum();
    }

    @Override
    public double updateProcessing(double currentTime) {
        this.setPreviousUtilizationMips(this.getUtilizationOfCpuMips());
        if (!this.vmList.isEmpty()) {
            this.lastBusyTime = this.simulation.clock();
        } else if (this.isIdleEnough(this.idleShutdownDeadline)) {
            this.setActive(false);
        }
        double nextSimulationTime = Double.MAX_VALUE;
        for (int i = 0; i < this.vmList.size(); ++i) {
            Vm vm = this.vmList.get(i);
            double nextTime = vm.updateProcessing(currentTime, this.vmScheduler.getAllocatedMips(vm));
            nextSimulationTime = Math.min(nextTime, nextSimulationTime);
        }
        this.notifyOnUpdateProcessingListeners(nextSimulationTime);
        this.addStateHistory(currentTime);
        return nextSimulationTime;
    }

    private void notifyOnUpdateProcessingListeners(double nextSimulationTime) {
        this.onUpdateProcessingListeners.forEach(l -> l.update(HostUpdatesVmsProcessingEventInfo.of(l, this, nextSimulationTime)));
    }

    @Override
    public boolean createVm(Vm vm) {
        boolean result = this.createVmInternal(vm);
        if (result) {
            this.addVmToCreatedList(vm);
            vm.setHost(this);
            vm.notifyOnHostAllocationListeners();
            if (vm.getStartTime() < 0.0) {
                vm.setStartTime(this.getSimulation().clock());
            }
        }
        return result;
    }

    @Override
    public boolean createTemporaryVm(Vm vm) {
        return this.createVmInternal(vm);
    }

    private boolean createVmInternal(Vm vm) {
        if (!this.allocateResourcesForVm(vm, false)) {
            return false;
        }
        this.vmList.add(vm);
        return true;
    }

    private boolean allocateResourcesForVm(Vm vm, boolean inMigration) {
        if (!this.storage.isAmountAvailable(vm.getStorage())) {
            this.logAllocationError(vm, inMigration, "MB", this.getStorage(), vm.getStorage());
            return false;
        }
        if (!this.ramProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedRam())) {
            this.logAllocationError(vm, inMigration, "MB", this.getRam(), vm.getRam());
            return false;
        }
        if (!this.bwProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedBw())) {
            this.logAllocationError(vm, inMigration, "Mbps", this.getBw(), vm.getBw());
            return false;
        }
        if (!this.vmScheduler.isSuitableForVm(vm)) {
            return false;
        }
        vm.setInMigration(inMigration);
        this.allocateResourcesForVm(vm);
        return true;
    }

    private void allocateResourcesForVm(Vm vm) {
        this.ramProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedRam());
        this.bwProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedBw());
        this.vmScheduler.allocatePesForVm(vm, vm.getCurrentRequestedMips());
        this.storage.allocateResource(vm.getStorage());
    }

    private void logAllocationError(Vm vm, boolean inMigration, String resourceUnit, Resource pmResource, Resource vmRequestedResource) {
        String migration = inMigration ? "VM Migration" : "VM Creation";
        String msg = pmResource.getAvailableResource() > 0L ? "just " + pmResource.getAvailableResource() + " " + resourceUnit : "no amount";
        LOGGER.error("{}: {}: [{}] Allocation of {} to {} failed due to lack of {}. Required {} but there is {} available.", new Object[]{this.simulation.clock(), this.getClass().getSimpleName(), migration, vm, this, pmResource.getClass().getSimpleName(), vmRequestedResource.getCapacity(), msg});
    }

    @Override
    public void reallocateMigratingInVms() {
        for (Vm vm : this.getVmsMigratingIn()) {
            if (!this.vmList.contains(vm)) {
                this.vmList.add(vm);
            }
            this.allocateResourcesForVm(vm);
        }
    }

    @Override
    public boolean isSuitableForVm(Vm vm) {
        return !this.isFailed() && this.hasEnoughResources(vm);
    }

    private boolean hasEnoughResources(Vm vm) {
        return this.vmScheduler.isSuitableForVm(vm, vm.getCurrentRequestedMips()) && this.ramProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedRam()) && this.bwProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedBw()) && this.storage.isAmountAvailable(vm.getStorage());
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean hasEverStarted() {
        return this.startTime > -1.0;
    }

    @Override
    public final Host setActive(boolean activate) {
        if (this.isFailed() && activate) {
            throw new IllegalStateException("The Host is failed and cannot be activated.");
        }
        this.showActivationLogBeforeModification(activate);
        if (activate && !this.active) {
            this.setStartTime(this.getSimulation().clock());
        } else if (!activate && this.active) {
            this.setShutdownTime(this.getSimulation().clock());
        }
        this.active = activate;
        return this;
    }

    private void showActivationLogBeforeModification(boolean activate) {
        if (this.simulation == null || !this.simulation.isRunning()) {
            return;
        }
        if (activate && !this.active) {
            LOGGER.info("{}: {} is being powered on.", (Object)this.getSimulation().clock(), (Object)this);
        } else if (!activate && this.active) {
            String reason = this.isIdleEnough(this.idleShutdownDeadline) ? " after becoming idle" : "";
            LOGGER.info("{}: {} is being powered off{}.", new Object[]{this.getSimulation().clock(), this, reason});
        }
    }

    @Override
    public void destroyVm(Vm vm) {
        this.destroyVmInternal(vm);
        vm.notifyOnHostDeallocationListeners(this);
        vm.setStopTime(this.getSimulation().clock());
    }

    @Override
    public void destroyTemporaryVm(Vm vm) {
        this.destroyVmInternal(vm);
    }

    private void destroyVmInternal(Vm vm) {
        this.deallocateResourcesOfVm(Objects.requireNonNull(vm));
        this.vmList.remove(vm);
    }

    protected void deallocateResourcesOfVm(Vm vm) {
        vm.setCreated(false);
        this.ramProvisioner.deallocateResourceForVm(vm);
        this.bwProvisioner.deallocateResourceForVm(vm);
        this.vmScheduler.deallocatePesFromVm(vm);
        this.storage.deallocateResource(vm.getStorage());
    }

    @Override
    public void destroyAllVms() {
        this.deallocateResourcesOfAllVms();
        for (Vm vm : this.vmList) {
            vm.setCreated(false);
            this.storage.deallocateResource(vm.getStorage());
        }
        this.vmList.clear();
    }

    protected void deallocateResourcesOfAllVms() {
        this.ramProvisioner.deallocateResourceForAllVms();
        this.bwProvisioner.deallocateResourceForAllVms();
        this.vmScheduler.deallocatePesForAllVms();
    }

    @Override
    public long getNumberOfPes() {
        return this.peList.size();
    }

    @Override
    public int getFreePesNumber() {
        return (int)this.peList.stream().filter(Pe::isFree).count();
    }

    protected List<Double> getAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getAllocatedMips(vm);
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getTotalAllocatedMipsForVm(vm);
    }

    protected double getMaxAvailableMips() {
        return this.vmScheduler.getMaxAvailableMips();
    }

    @Override
    public double getMips() {
        return this.peList.stream().mapToDouble(Pe::getCapacity).findFirst().orElse(0.0);
    }

    @Override
    public double getAvailableMips() {
        return this.vmScheduler.getAvailableMips();
    }

    @Override
    public Resource getBw() {
        return this.bwProvisioner.getResource();
    }

    @Override
    public Resource getRam() {
        return this.ramProvisioner.getResource();
    }

    @Override
    public Resource getStorage() {
        return this.storage;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public final void setId(long id) {
        this.id = id;
    }

    @Override
    public ResourceProvisioner getRamProvisioner() {
        return this.ramProvisioner;
    }

    @Override
    public final Host setRamProvisioner(ResourceProvisioner ramProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("RAM");
        this.ramProvisioner = Objects.requireNonNull(ramProvisioner);
        this.ramProvisioner.setResource(this.ram);
        return this;
    }

    private void checkSimulationIsRunningAndAttemptedToChangeHost(String resourceName) {
        if (this.simulation.isRunning()) {
            throw new IllegalStateException("It is not allowed to change a Host's " + resourceName + " after the simulation started.");
        }
    }

    @Override
    public ResourceProvisioner getBwProvisioner() {
        return this.bwProvisioner;
    }

    @Override
    public final Host setBwProvisioner(ResourceProvisioner bwProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("BW");
        this.bwProvisioner = Objects.requireNonNull(bwProvisioner);
        this.bwProvisioner.setResource(this.bw);
        return this;
    }

    @Override
    public VmScheduler getVmScheduler() {
        return this.vmScheduler;
    }

    @Override
    public final Host setVmScheduler(VmScheduler vmScheduler) {
        this.vmScheduler = Objects.requireNonNull(vmScheduler);
        vmScheduler.setHost(this);
        return this;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(double startTime) {
        if (startTime < 0.0) {
            throw new IllegalArgumentException("Host start time cannot be negative");
        }
        this.startTime = Math.floor(startTime);
        this.shutdownTime = -1.0;
    }

    @Override
    public double getShutdownTime() {
        return this.shutdownTime;
    }

    @Override
    public void setShutdownTime(double shutdownTime) {
        if (shutdownTime < 0.0) {
            throw new IllegalArgumentException("Host shutdown time cannot be negative");
        }
        this.shutdownTime = Math.floor(shutdownTime);
        this.totalUpTime += this.getUpTime();
    }

    @Override
    public double getUpTime() {
        return this.active ? this.simulation.clock() - this.startTime : this.shutdownTime - this.startTime;
    }

    @Override
    public double getTotalUpTime() {
        return this.totalUpTime + (this.active ? this.getUpTime() : 0.0);
    }

    @Override
    public double getIdleShutdownDeadline() {
        return this.idleShutdownDeadline;
    }

    @Override
    public Host setIdleShutdownDeadline(double deadline) {
        this.idleShutdownDeadline = deadline;
        return this;
    }

    @Override
    public List<Pe> getPeList() {
        return this.peList;
    }

    protected final Host setPeList(List<Pe> peList) {
        Objects.requireNonNull(peList);
        this.checkSimulationIsRunningAndAttemptedToChangeHost("List of PE");
        this.peList = peList;
        long peId = this.peList.stream().filter(pe -> pe.getId() > 0L).mapToLong(Identifiable::getId).max().orElse(-1L);
        List pesWithoutIds = this.peList.stream().filter(pe -> pe.getId() < 0L).collect(Collectors.toList());
        for (Pe pe2 : pesWithoutIds) {
            pe2.setId(++peId);
        }
        return this;
    }

    @Override
    public <T extends Vm> List<T> getVmList() {
        return Collections.unmodifiableList(this.vmList);
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return Collections.unmodifiableList(this.vmCreatedList);
    }

    protected void addVmToList(Vm vm) {
        this.vmList.add(Objects.requireNonNull(vm));
    }

    protected void addVmToCreatedList(Vm vm) {
        this.vmCreatedList.add(Objects.requireNonNull(vm));
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public final boolean setFailed(boolean failed) {
        this.failed = failed;
        Pe.Status status = failed ? Pe.Status.FAILED : Pe.Status.FREE;
        this.peList.forEach(pe -> pe.setStatus(status));
        if (failed && this.active) {
            this.active = false;
        }
        return true;
    }

    @Override
    public <T extends Vm> Set<T> getVmsMigratingIn() {
        return this.vmsMigratingIn;
    }

    @Override
    public boolean addMigratingInVm(Vm vm) {
        if (this.vmsMigratingIn.contains(vm)) {
            return false;
        }
        this.vmsMigratingIn.add(vm);
        if (!this.allocateResourcesForVm(vm, true)) {
            this.vmsMigratingIn.remove(vm);
            return false;
        }
        this.updateProcessing(this.simulation.clock());
        vm.getHost().updateProcessing(this.simulation.clock());
        return true;
    }

    @Override
    public void removeMigratingInVm(Vm vm) {
        this.deallocateResourcesOfVm(vm);
        this.vmsMigratingIn.remove(vm);
        this.vmList.remove(vm);
        vm.setInMigration(false);
    }

    @Override
    public Set<Vm> getVmsMigratingOut() {
        return Collections.unmodifiableSet(this.vmsMigratingOut);
    }

    @Override
    public boolean addVmMigratingOut(Vm vm) {
        return this.vmsMigratingOut.add(vm);
    }

    @Override
    public boolean removeVmMigratingOut(Vm vm) {
        return this.vmsMigratingOut.remove(vm);
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public final void setDatacenter(Datacenter datacenter) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("Datacenter");
        this.datacenter = datacenter;
    }

    public String toString() {
        String dc = Datacenter.NULL.equals(this.datacenter) ? "" : String.format("/DC %d", this.datacenter.getId());
        return String.format("Host %d%s", this.getId(), dc);
    }

    @Override
    public boolean removeOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public Host addOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onUpdateProcessingListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public long getAvailableStorage() {
        return this.storage.getAvailableResource();
    }

    @Override
    public long getWorkingPesNumber() {
        return (long)this.peList.size() - this.getFailedPesNumber();
    }

    @Override
    public long getFailedPesNumber() {
        return this.peList.stream().filter(Pe::isFailed).count();
    }

    private Host setStorage(long size) {
        this.storage = new Storage(size);
        return this;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public double getLastBusyTime() {
        return this.lastBusyTime;
    }

    @Override
    public final Host setSimulation(Simulation simulation) {
        this.simulation = simulation;
        return this;
    }

    @Override
    public int compareTo(Host o) {
        return Double.compare(this.getTotalMipsCapacity(), o.getTotalMipsCapacity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostSimple that = (HostSimple)o;
        if (this.id != that.id) {
            return false;
        }
        return this.simulation.equals(that.simulation);
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = 31 * result + this.simulation.hashCode();
        return result;
    }

    @Override
    public List<ResourceManageable> getResources() {
        if (this.simulation.isRunning() && this.resources.isEmpty()) {
            this.resources = Arrays.asList(this.ramProvisioner.getResource(), this.bwProvisioner.getResource());
        }
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public ResourceProvisioner getProvisioner(Class<? extends ResourceManageable> resourceClass) {
        if (this.simulation.isRunning() && this.provisioners.isEmpty()) {
            this.provisioners = Arrays.asList(this.ramProvisioner, this.bwProvisioner);
        }
        return this.provisioners.stream().filter(provisioner -> provisioner.getResource().isSubClassOf(resourceClass)).findFirst().orElse(ResourceProvisioner.NULL);
    }

    @Override
    public List<Pe> getWorkingPeList() {
        return this.getFilteredPeList(Pe::isWorking);
    }

    @Override
    public List<Pe> getBusyPeList() {
        return this.getFilteredPeList(Pe::isBusy);
    }

    @Override
    public List<Pe> getFreePeList() {
        return this.getFilteredPeList(Pe::isFree);
    }

    private List<Pe> getFilteredPeList(Predicate<Pe> status) {
        return this.peList.stream().filter(status).collect(Collectors.toList());
    }

    @Override
    public double getUtilizationOfCpu() {
        return this.computeCpuUtilizationPercent(this.getUtilizationOfCpuMips());
    }

    private double computeCpuUtilizationPercent(double mipsUsage) {
        double totalMips = this.getTotalMipsCapacity();
        if (totalMips == 0.0) {
            return 0.0;
        }
        double utilization = mipsUsage / totalMips;
        return utilization > 1.0 && utilization < 1.01 ? 1.0 : utilization;
    }

    @Override
    public double getUtilizationOfCpuMips() {
        return this.vmList.stream().mapToDouble(Vm::getTotalCpuMipsUsage).sum();
    }

    @Override
    public long getUtilizationOfRam() {
        return this.ramProvisioner.getTotalAllocatedResource();
    }

    @Override
    public long getUtilizationOfBw() {
        return this.bwProvisioner.getTotalAllocatedResource();
    }

    @Override
    public SortedMap<Double, DoubleSummaryStatistics> getUtilizationHistory() {
        Stream<TreeMap> utilizationEntriesStream = this.vmCreatedList.stream().map(Vm::getUtilizationHistory).map(this::remapUtilizationHistory).flatMap(vmUtilization -> vmUtilization.entrySet().stream());
        return utilizationEntriesStream.collect(Collectors.groupingBy(Map.Entry::getKey, TreeMap::new, Collectors.summarizingDouble(Map.Entry::getValue)));
    }

    @Override
    public SortedMap<Double, Double> getUtilizationHistorySum() {
        Function<Map.Entry, Double> valueMapper = entry -> ((DoubleSummaryStatistics)entry.getValue()).getSum();
        return this.getUtilizationHistory().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, valueMapper, this::mergeFunction, TreeMap::new));
    }

    private SortedMap<Double, Double> remapUtilizationHistory(UtilizationHistory utilizationHistory) {
        return utilizationHistory.getHistory().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.vmUtilizationMapper(utilizationHistory), this::mergeFunction, TreeMap::new));
    }

    private double mergeFunction(double usage1, double usage2) {
        return Math.max(usage1, usage2);
    }

    private Function<Map.Entry<Double, Double>, Double> vmUtilizationMapper(UtilizationHistory utilizationHistory) {
        return entry -> (Double)entry.getValue() * utilizationHistory.getVm().getRelativeMipsCapacityPercent();
    }

    @Override
    public PowerModel getPowerModel() {
        return this.powerModel;
    }

    @Override
    public Host setPowerModel(PowerModel powerModel) {
        Objects.requireNonNull(powerModel);
        if (powerModel.getHost() != null && powerModel.getHost() != Host.NULL && !powerModel.getHost().equals(this)) {
            throw new IllegalStateException("The given PowerModel is already assigned to another Host. Each Host must have its own PowerModel instance.");
        }
        this.powerModel = powerModel;
        powerModel.setHost(this);
        return this;
    }

    @Override
    public double getPreviousUtilizationOfCpu() {
        return this.computeCpuUtilizationPercent(this.previousUtilizationMips);
    }

    @Override
    public void enableStateHistory() {
        this.stateHistoryEnabled = true;
    }

    @Override
    public void disableStateHistory() {
        this.stateHistoryEnabled = false;
    }

    @Override
    public boolean isStateHistoryEnabled() {
        return this.stateHistoryEnabled;
    }

    private void setPreviousUtilizationMips(double previousUtilizationMips) {
        this.previousUtilizationMips = previousUtilizationMips;
    }

    @Override
    public List<Vm> getFinishedVms() {
        return this.getVmList().stream().filter(vm -> !vm.isInMigration()).filter(vm -> vm.getCurrentRequestedTotalMips() == 0.0).collect(Collectors.toList());
    }

    private double addVmResourceUseToHistoryIfNotMigratingIn(Vm vm, double currentTime) {
        double totalAllocatedMips = this.getVmScheduler().getTotalAllocatedMipsForVm(vm);
        if (this.getVmsMigratingIn().contains(vm)) {
            LOGGER.info("{}: {}: {} is migrating in", new Object[]{this.getSimulation().clock(), this, vm});
            return totalAllocatedMips;
        }
        double totalRequestedMips = vm.getCurrentRequestedTotalMips();
        if (totalAllocatedMips + 0.1 < totalRequestedMips) {
            String reason = this.getVmsMigratingOut().contains(vm) ? "migration overhead" : "capacity unavailability";
            long notAllocatedMipsByPe = (long)((totalRequestedMips - totalAllocatedMips) / (double)vm.getNumberOfPes());
            LOGGER.error("{}: {}: {} MIPS not allocated for each one of the {} PEs from {} due to {}.", new Object[]{this.getSimulation().clock(), this, notAllocatedMipsByPe, vm.getNumberOfPes(), vm, reason});
        }
        VmStateHistoryEntry entry = new VmStateHistoryEntry(currentTime, totalAllocatedMips, totalRequestedMips, vm.isInMigration() && !this.getVmsMigratingIn().contains(vm));
        vm.addStateHistoryEntry(entry);
        if (vm.isInMigration()) {
            LOGGER.info("{}: {}: {} is migrating out ", new Object[]{this.getSimulation().clock(), this, vm});
            totalAllocatedMips /= this.getVmScheduler().getMaxCpuUsagePercentDuringOutMigration();
        }
        return totalAllocatedMips;
    }

    private void addStateHistory(double currentTime) {
        if (!this.stateHistoryEnabled) {
            return;
        }
        double hostTotalRequestedMips = 0.0;
        for (Vm vm : this.getVmList()) {
            double totalRequestedMips = vm.getCurrentRequestedTotalMips();
            this.addVmResourceUseToHistoryIfNotMigratingIn(vm, currentTime);
            hostTotalRequestedMips += totalRequestedMips;
        }
        this.addStateHistoryEntry(currentTime, this.getUtilizationOfCpuMips(), hostTotalRequestedMips, this.active);
    }

    private void addStateHistoryEntry(double time, double allocatedMips, double requestedMips, boolean isActive) {
        HostStateHistoryEntry previousState;
        HostStateHistoryEntry newState = new HostStateHistoryEntry(time, allocatedMips, requestedMips, isActive);
        if (!this.stateHistory.isEmpty() && (previousState = this.stateHistory.get(this.stateHistory.size() - 1)).getTime() == time) {
            this.stateHistory.set(this.stateHistory.size() - 1, newState);
            return;
        }
        this.stateHistory.add(newState);
    }

    @Override
    public List<HostStateHistoryEntry> getStateHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }

    @Override
    public List<Vm> getMigratableVms() {
        return this.vmList.stream().filter(vm -> !vm.isInMigration()).collect(Collectors.toList());
    }
}

