/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts;

public final class HostStateHistoryEntry {
    private final double time;
    private final double allocatedMips;
    private final double requestedMips;
    private final boolean active;

    public HostStateHistoryEntry(double time, double allocatedMips, double requestedMips, boolean active) {
        this.time = time;
        this.allocatedMips = allocatedMips;
        this.requestedMips = requestedMips;
        this.active = active;
    }

    public double getTime() {
        return this.time;
    }

    public double getAllocatedMips() {
        return this.allocatedMips;
    }

    public double getRequestedMips() {
        return this.requestedMips;
    }

    public double getPercentUsage() {
        return this.requestedMips > 0.0 ? this.allocatedMips / this.requestedMips : 0.0;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return String.format("Time: %6.1f | Requested: %10.0f MIPS | Allocated: %10.0f MIPS | Used: %3.0f%% Host Active: %s\n", this.time, this.requestedMips, this.allocatedMips, this.getPercentUsage() * 100.0, this.active);
    }
}

