/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.topologies;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.cloudbus.cloudsim.network.topologies.TopologicalLink;
import org.cloudbus.cloudsim.network.topologies.TopologicalNode;

public class TopologicalGraph {
    private final List<TopologicalLink> linksList = new LinkedList<TopologicalLink>();
    private final List<TopologicalNode> nodeList = new LinkedList<TopologicalNode>();

    public void addLink(TopologicalLink edge) {
        this.linksList.add(edge);
    }

    public void addNode(TopologicalNode node) {
        this.nodeList.add(node);
    }

    public int getNumberOfNodes() {
        return this.nodeList.size();
    }

    public int getNumberOfLinks() {
        return this.linksList.size();
    }

    public List<TopologicalLink> getLinksList() {
        return Collections.unmodifiableList(this.linksList);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(61);
        builder.append("topological-node-information: \n");
        for (TopologicalNode node : this.nodeList) {
            builder.append(String.format("%d | %s\n", node.getNodeId(), node.getWorldCoordinates()));
        }
        builder.append("\n\n node-link-information:\n");
        for (TopologicalLink link : this.linksList) {
            builder.append(String.format("from: %d to: %d delay: %.2f\n", link.getSrcNodeID(), link.getDestNodeID(), link.getLinkDelay()));
        }
        return builder.toString();
    }

    public List<TopologicalNode> getNodeList() {
        return Collections.unmodifiableList(this.nodeList);
    }
}

