/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.utilizationmodels;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelStochastic
extends UtilizationModelAbstract {
    private ContinuousDistribution randomGenerator;
    private Map<Double, Double> history;

    public UtilizationModelStochastic() {
        this.setHistory(new HashMap<Double, Double>());
        this.setRandomGenerator(new UniformDistr());
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit) {
        this();
        this.setUnit(unit);
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit, long seed) {
        this(seed);
        this.setUnit(unit);
    }

    public UtilizationModelStochastic(long seed) {
        this(new UniformDistr(seed));
    }

    public UtilizationModelStochastic(ContinuousDistribution prng) {
        this.setHistory(new HashMap<Double, Double>());
        this.setRandomGenerator(prng);
    }

    @Override
    public double getUtilization(double time) {
        if (this.getHistory().containsKey(time)) {
            return this.getHistory().get(time);
        }
        double utilization = Math.abs(this.randomGenerator.sample());
        this.getHistory().put(time, utilization);
        return utilization;
    }

    protected Map<Double, Double> getHistory() {
        return this.history;
    }

    protected final void setHistory(Map<Double, Double> history) {
        this.history = history;
    }

    public void saveHistory(String filename) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));){
            oos.writeObject(this.getHistory());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void loadHistory(String filename) {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));){
            this.setHistory((Map)ois.readObject());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ContinuousDistribution getRandomGenerator() {
        return this.randomGenerator;
    }

    public final void setRandomGenerator(ContinuousDistribution randomGenerator) {
        this.randomGenerator = Objects.requireNonNull(randomGenerator);
    }
}

