/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.vms;

import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.vms.Vm;

public class VmCost {
    private Vm vm;

    public VmCost(Vm vm) {
        this.vm = vm;
    }

    public Vm getVm() {
        return this.vm;
    }

    private DatacenterCharacteristics getDcCharacteristics() {
        return this.vm.getHost().getDatacenter().getCharacteristics();
    }

    public double getMemoryCost() {
        return this.getDcCharacteristics().getCostPerMem() * (double)this.vm.getRam().getCapacity();
    }

    public double getBwCost() {
        return this.getDcCharacteristics().getCostPerBw() * (double)this.vm.getBw().getCapacity();
    }

    public double getProcessingCost() {
        double hostMips = this.vm.getHost().getPeList().stream().findFirst().map(Pe::getCapacity).orElse(0L).longValue();
        double costPerMI = hostMips > 0.0 ? this.getDcCharacteristics().getCostPerSecond() / hostMips : 0.0;
        return costPerMI * this.getVm().getMips() * (double)this.getVm().getNumberOfPes();
    }

    public double getStorageCost() {
        return this.getDcCharacteristics().getCostPerStorage() * (double)this.vm.getStorage().getCapacity();
    }

    public double getTotalCost() {
        return this.getProcessingCost() + this.getStorageCost() + this.getMemoryCost() + this.getBwCost();
    }
}

