/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.faultinjection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.Identifiable;
import org.cloudbus.cloudsim.core.Machine;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.faultinjection.VmCloner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostFaultInjection
extends CloudSimEntity {
    private static final int MAX_VM_RECOVERY_TIME_SECS = 450;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HostFaultInjection.class.getSimpleName());
    private Host lastFailedHost;
    private int lastNumberOfFailedPes;
    private Datacenter datacenter;
    private final ContinuousDistribution random;
    private final Map<DatacenterBroker, VmCloner> vmClonerMap;
    private final ContinuousDistribution faultArrivalHoursGenerator;
    private int numberOfHostFaults;
    private final Map<Vm, Double> vmRecoveryTimeSecsMap;
    private final Map<Host, List<Double>> hostFaultsTimeSecsMap;
    private final Map<DatacenterBroker, Integer> faultsOfAllVmsByBroker;
    private double maxTimeToFailInHours;

    public HostFaultInjection(Datacenter datacenter) {
        this(datacenter, new UniformDistr());
    }

    public HostFaultInjection(Datacenter datacenter, ContinuousDistribution faultArrivalHoursGenerator) {
        super(datacenter.getSimulation());
        this.setDatacenter(datacenter);
        this.lastFailedHost = Host.NULL;
        this.faultArrivalHoursGenerator = faultArrivalHoursGenerator;
        this.random = new UniformDistr(faultArrivalHoursGenerator.getSeed() + 1L);
        this.vmRecoveryTimeSecsMap = new HashMap<Vm, Double>();
        this.hostFaultsTimeSecsMap = new HashMap<Host, List<Double>>();
        this.faultsOfAllVmsByBroker = new HashMap<DatacenterBroker, Integer>();
        this.vmClonerMap = new HashMap<DatacenterBroker, VmCloner>();
        this.maxTimeToFailInHours = Double.MAX_VALUE;
    }

    @Override
    protected void startEntity() {
        this.scheduleFaultInjection();
    }

    private void scheduleFaultInjection() {
        long numOfOtherEvents = this.getSimulation().getNumberOfFutureEvents(evt -> evt.getTag() != 49);
        if (numOfOtherEvents > 0L || this.getSimulation().clock() < this.getMaxTimeToFailInSecs()) {
            this.schedule(this, this.getTimeDelayForNextFault(), 49);
        }
    }

    private double getTimeDelayForNextFault() {
        return this.faultArrivalHoursGenerator.sample() * 3600.0;
    }

    @Override
    public void processEvent(SimEvent evt) {
        if (evt.getTag() == 49) {
            this.generateHostFaultAndScheduleNext();
        }
    }

    public void generateHostFault(Host host) {
        this.generateHostFault(host, host.getWorkingPesNumber());
    }

    public void generateHostFault(Host host, long numberOfPesToFail) {
        String msg;
        if (Host.NULL == host) {
            return;
        }
        this.lastFailedHost = host;
        ++this.numberOfHostFaults;
        this.registerHostFaultTime();
        long previousNumOfWorkingPes = this.lastFailedHost.getWorkingPesNumber();
        this.lastNumberOfFailedPes = this.generateHostPesFaults(numberOfPesToFail);
        long hostWorkingPes = this.lastFailedHost.getWorkingPesNumber();
        long vmsRequiredPes = this.getPesSumOfWorkingVms();
        String string = msg = this.lastFailedHost.getVmList().isEmpty() ? "" : " | VMs required PEs: " + vmsRequiredPes;
        if (hostWorkingPes > 0L) {
            LOGGER.error("{}: {}: Generated {} PEs failures from {} previously working PEs for {} at minute {}.{}\t  Current Working PEs: {} | Number of VMs: {}{}", new Object[]{this.getSimulation().clock(), this.getClass().getSimpleName(), this.lastNumberOfFailedPes, previousNumOfWorkingPes, this.lastFailedHost, this.getSimulation().clock() / 60.0, System.lineSeparator(), hostWorkingPes, this.lastFailedHost.getVmList().size(), msg});
        }
        if (hostWorkingPes == 0L) {
            this.setAllVmsToFailed();
        } else if (hostWorkingPes >= vmsRequiredPes) {
            this.logNoVmFault();
        } else {
            this.deallocateFailedHostPesFromVms();
        }
    }

    private void generateHostFaultAndScheduleNext() {
        try {
            Host host = this.getRandomHost();
            this.generateHostFault(host, this.randomNumberOfFailedPes(host));
        }
        finally {
            this.scheduleFaultInjection();
        }
    }

    private void registerHostFaultTime() {
        this.hostFaultsTimeSecsMap.computeIfAbsent(this.lastFailedHost, host -> new ArrayList()).add(this.getSimulation().clock());
    }

    private Host getRandomHost() {
        if (this.datacenter.getHostList().isEmpty()) {
            return Host.NULL;
        }
        int idx = (int)(this.random.sample() * (double)this.datacenter.getHostList().size());
        return this.datacenter.getHost(idx);
    }

    private void setAllVmsToFailed() {
        int vms = this.lastFailedHost.getVmList().size();
        String msg = vms > 0 ? String.format("affecting all its %d VMs", vms) : "but there was no running VM";
        LOGGER.error("{}: All the {} PEs of {} failed, {}.", new Object[]{this.getSimulation().clock(), this.lastFailedHost.getNumberOfPes(), this.lastFailedHost, msg});
        this.setVmListToFailed(this.lastFailedHost.getVmList());
    }

    private void logNoVmFault() {
        if (this.lastFailedHost.getVmList().isEmpty()) {
            LOGGER.info("\tThere aren't VMs running on the failed Host.");
            return;
        }
        int vmsRequiredPes = (int)this.getPesSumOfWorkingVms();
        LOGGER.info("\tNumber of failed PEs is less than PEs required by all its {} VMs, thus it doesn't affect any VM.{}Total PEs: {} | Total Failed PEs: {} | Working PEs: {} | Current PEs required by VMs: {}.\n", new Object[]{this.lastFailedHost.getVmList().size(), System.lineSeparator(), this.lastFailedHost.getNumberOfPes(), this.lastFailedHost.getFailedPesNumber(), this.lastFailedHost.getWorkingPesNumber(), vmsRequiredPes});
    }

    private void deallocateFailedHostPesFromVms() {
        LOGGER.error("\t{} PEs just failed. There is a total of {} working PEs.", (Object)this.lastNumberOfFailedPes, (Object)this.lastFailedHost.getWorkingPesNumber());
        this.cyclicallyRemoveFailedHostPesFromVms();
        List<Vm> vmsWithoutPes = this.lastFailedHost.getVmList().stream().filter(vm -> vm.getNumberOfPes() == 0L).collect(Collectors.toList());
        this.setVmListToFailed(vmsWithoutPes);
    }

    private void cyclicallyRemoveFailedHostPesFromVms() {
        int failedPesToRemoveFromVms = this.numberOfFailedPesToRemoveFromVms();
        List<Vm> vmsWithPes = this.getVmsWithPEsFromFailedHost();
        int affectedVms = Math.min(vmsWithPes.size(), failedPesToRemoveFromVms);
        LOGGER.warn("\t{} VMs affected from a total of {}. {} PEs are going to be removed from them.", new Object[]{affectedVms, this.lastFailedHost.getVmList().size(), failedPesToRemoveFromVms});
        int idx = 0;
        while (!vmsWithPes.isEmpty() && failedPesToRemoveFromVms > 0) {
            --failedPesToRemoveFromVms;
            Vm vm = vmsWithPes.get(idx %= vmsWithPes.size());
            this.lastFailedHost.getVmScheduler().deallocatePesFromVm(vm, 1);
            vm.getCloudletScheduler().deallocatePesFromVm(1);
            vm.getProcessor().deallocateAndRemoveResource(1L);
            LOGGER.warn("\tRemoving 1 PE from VM {} due to Host PE failure. New VM PEs Number: {}\n", (Object)vm.getId(), (Object)vm.getNumberOfPes());
            ++idx;
            vmsWithPes = this.getVmsWithPEsFromFailedHost();
        }
        --failedPesToRemoveFromVms;
    }

    private int numberOfFailedPesToRemoveFromVms() {
        int hostWorkingPes = (int)this.lastFailedHost.getWorkingPesNumber();
        int vmsRequiredPes = (int)this.getPesSumOfWorkingVms();
        return vmsRequiredPes - hostWorkingPes;
    }

    private List<Vm> getVmsWithPEsFromFailedHost() {
        return this.lastFailedHost.getVmList().stream().filter(vm -> vm.getNumberOfPes() > 0L).collect(Collectors.toList());
    }

    private void setVmListToFailed(List<Vm> vms) {
        Map<DatacenterBroker, Vm> lastVmFailedByBroker = this.getLastFailedVmByBroker(vms);
        vms.forEach(this::setVmToFailed);
        lastVmFailedByBroker.forEach(this::createVmCloneIfAllVmsDestroyed);
    }

    private Map<DatacenterBroker, Vm> getLastFailedVmByBroker(List<Vm> vmsWithoutPes) {
        Comparator<Vm> comparator = Comparator.comparingLong(Identifiable::getId);
        return vmsWithoutPes.stream().collect(Collectors.toMap(Vm::getBroker, Function.identity(), BinaryOperator.maxBy(comparator)));
    }

    private void createVmCloneIfAllVmsDestroyed(DatacenterBroker broker, Vm lastVmFailedFromBroker) {
        if (this.isSomeVmWorking(broker)) {
            return;
        }
        if (!this.isVmClonerSet(broker) || this.getVmCloner(broker).isMaxClonesNumberReached()) {
            this.vmRecoveryTimeSecsMap.put(lastVmFailedFromBroker, -this.getSimulation().clock());
        }
        if (!this.isVmClonerSet(broker)) {
            LOGGER.warn("\tA Vm Cloner was not set for {}. So that VM failure will not be recovered.", (Object)broker);
            return;
        }
        VmCloner cloner = this.getVmCloner(broker);
        if (cloner.isMaxClonesNumberReached()) {
            LOGGER.warn("\tThe maximum allowed number of {} VMs to create has been reached.", (Object)cloner.getMaxClonesNumber());
            return;
        }
        this.registerFaultOfAllVms(broker);
        double recoveryTimeSecs = this.getRandomRecoveryTimeForVmInSecs();
        LOGGER.info("\tTime to recovery from fault by cloning the failed VM: {} minutes", (Object)(recoveryTimeSecs / 60.0));
        Map.Entry<Vm, List<Cloudlet>> entry = cloner.clone(lastVmFailedFromBroker);
        Vm clonedVm = entry.getKey();
        List<Cloudlet> clonedCloudlets = entry.getValue();
        clonedVm.setSubmissionDelay(recoveryTimeSecs);
        clonedVm.addOnHostAllocationListener(evt -> this.vmRecoveryTimeSecsMap.put(evt.getVm(), recoveryTimeSecs));
        broker.submitVm(clonedVm);
        broker.submitCloudletList(clonedCloudlets, recoveryTimeSecs);
    }

    private void setVmToFailed(Vm vm) {
        if (Host.NULL.equals(this.lastFailedHost)) {
            return;
        }
        vm.setFailed(true);
        DatacenterBroker broker = vm.getBroker();
        if (this.isVmClonerSet(broker) && this.isSomeVmWorking(broker)) {
            LOGGER.info("\t{} destroyed but not cloned, since there are {} VMs for the {} yet", new Object[]{vm, this.getRunningVmsNumber(broker), broker});
        }
        this.getSimulation().sendNow(broker, this.datacenter, 33, vm);
    }

    private void registerFaultOfAllVms(DatacenterBroker broker) {
        this.faultsOfAllVmsByBroker.merge(broker, 1, (old, inc) -> old + inc);
    }

    private VmCloner getVmCloner(DatacenterBroker broker) {
        return this.vmClonerMap.getOrDefault(broker, VmCloner.NULL);
    }

    private boolean isSomeVmWorking(DatacenterBroker broker) {
        return broker.getVmExecList().stream().anyMatch(Vm::isWorking);
    }

    private long getRunningVmsNumber(DatacenterBroker broker) {
        return broker.getVmExecList().stream().filter(Vm::isWorking).count();
    }

    private boolean isVmClonerSet(DatacenterBroker broker) {
        return this.vmClonerMap.getOrDefault(broker, VmCloner.NULL) != VmCloner.NULL;
    }

    public int getNumberOfHostFaults() {
        return this.numberOfHostFaults;
    }

    public double availability() {
        return this.availability(null);
    }

    public double availability(DatacenterBroker broker) {
        double mtbf = this.meanTimeBetweenVmFaultsInMinutes(broker);
        if (mtbf == 0.0) {
            return 1.0;
        }
        double mttr = this.meanTimeToRepairVmFaultsInMinutes(broker);
        return mtbf / (mtbf + mttr);
    }

    public long getNumberOfFaults() {
        return this.faultsOfAllVmsByBroker.values().size();
    }

    public long getNumberOfFaults(DatacenterBroker broker) {
        if (broker == null) {
            return this.getNumberOfFaults();
        }
        return this.faultsOfAllVmsByBroker.getOrDefault(broker, 0).intValue();
    }

    private double totalVmsRecoveryTimeInMinutes(DatacenterBroker broker) {
        Stream<Double> stream = broker == null ? this.vmRecoveryTimeSecsMap.values().stream() : this.vmRecoveryTimeSecsMap.entrySet().stream().filter(entry -> broker.equals(((Vm)entry.getKey()).getBroker())).map(Map.Entry::getValue);
        double recoverySeconds = stream.map(secs -> secs >= 0.0 ? secs : this.getSimulation().clock() - Math.abs(secs)).reduce(0.0, Double::sum);
        return (long)(recoverySeconds / 60.0);
    }

    public double meanTimeBetweenHostFaultsInMinutes() {
        double[] faultTimes = this.hostFaultsTimeSecsMap.values().stream().flatMap(Collection::stream).mapToDouble(time -> time).sorted().toArray();
        if (faultTimes.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        double previous = faultTimes[0];
        for (double time2 : faultTimes) {
            sum += time2 - previous;
            previous = time2;
        }
        double seconds = sum / (double)faultTimes.length;
        return (long)(seconds / 60.0);
    }

    public double meanTimeBetweenVmFaultsInMinutes() {
        return this.meanTimeBetweenVmFaultsInMinutes(null);
    }

    public double meanTimeBetweenVmFaultsInMinutes(DatacenterBroker broker) {
        double faultsFromBroker = this.getNumberOfFaults(broker);
        if (faultsFromBroker == 0.0) {
            return 0.0;
        }
        double totalVmsRecoveryTimeInMinutes = this.meanTimeToRepairVmFaultsInMinutes(broker);
        return this.getSimulation().clockInMinutes() - totalVmsRecoveryTimeInMinutes;
    }

    public double meanTimeToRepairVmFaultsInMinutes() {
        return this.meanTimeToRepairVmFaultsInMinutes(null);
    }

    public double meanTimeToRepairVmFaultsInMinutes(DatacenterBroker broker) {
        double faultsFromBroker = this.getNumberOfFaults(broker);
        if (faultsFromBroker == 0.0) {
            return 0.0;
        }
        return this.totalVmsRecoveryTimeInMinutes(broker) / faultsFromBroker;
    }

    private int generateHostPesFaults(long numberOfPesToFail) {
        int pesFaults = (int)this.lastFailedHost.getWorkingPeList().stream().limit(numberOfPesToFail).peek(pe -> pe.setStatus(Pe.Status.FAILED)).count();
        ((VmAllocationPolicyAbstract)this.lastFailedHost.getDatacenter().getVmAllocationPolicy()).addPesFromHost(this.lastFailedHost);
        return pesFaults;
    }

    private long getPesSumOfWorkingVms() {
        return this.lastFailedHost.getVmList().stream().filter(Vm::isWorking).mapToLong(Machine::getNumberOfPes).sum();
    }

    private int randomNumberOfFailedPes(Host host) {
        return (int)(this.random.sample() * (double)host.getWorkingPesNumber()) + 1;
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    protected final void setDatacenter(Datacenter datacenter) {
        this.datacenter = Objects.requireNonNull(datacenter);
    }

    public void addVmCloner(DatacenterBroker broker, VmCloner cloner) {
        this.vmClonerMap.put(Objects.requireNonNull(broker), Objects.requireNonNull(cloner));
    }

    public Host getLastFailedHost() {
        return this.lastFailedHost;
    }

    public double getRandomRecoveryTimeForVmInSecs() {
        return this.random.sample() * 450.0 + 1.0;
    }

    public double getMaxTimeToFailInHours() {
        return this.maxTimeToFailInHours;
    }

    private double getMaxTimeToFailInSecs() {
        return this.maxTimeToFailInHours * 3600.0;
    }

    public void setMaxTimeToFailInHours(double maxTimeToFailInHours) {
        this.maxTimeToFailInHours = maxTimeToFailInHours;
    }
}

