/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.CloudSimEvent;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelDynamic;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.traces.google.GoogleTraceReaderAbstract;
import org.cloudsimplus.traces.google.TaskUsage;
import org.cloudsimplus.traces.google.TraceField;

public final class GoogleTaskUsageTraceReader
extends GoogleTraceReaderAbstract<Cloudlet> {
    private final List<CloudSimEvent> cloudletUsageChangeEvents;
    private final List<DatacenterBroker> brokers;
    private final Simulation simulation;

    public static GoogleTaskUsageTraceReader getInstance(List<DatacenterBroker> brokers, String filePath) {
        InputStream reader = ResourceLoader.getInputStream(filePath, GoogleTaskUsageTraceReader.class);
        return new GoogleTaskUsageTraceReader(brokers, filePath, reader);
    }

    public GoogleTaskUsageTraceReader(List<DatacenterBroker> brokers, String filePath) throws IOException {
        this(brokers, filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
    }

    private GoogleTaskUsageTraceReader(List<DatacenterBroker> brokers, String filePath, InputStream reader) {
        super(filePath, reader);
        this.brokers = Objects.requireNonNull(brokers);
        if (brokers.isEmpty()) {
            throw new IllegalArgumentException("The broker list cannot be empty");
        }
        this.simulation = brokers.get(0).getSimulation();
        this.cloudletUsageChangeEvents = new ArrayList<CloudSimEvent>();
    }

    @Override
    public Set<Cloudlet> process() {
        return super.process();
    }

    @Override
    protected void preProcess() {
    }

    @Override
    protected void postProcess() {
        this.simulation.addOnSimulationStartListener(this::onSimulationStart);
    }

    private void onSimulationStart(EventInfo info) {
        this.cloudletUsageChangeEvents.forEach(evt -> evt.getSource().schedule((SimEvent)evt));
    }

    @Override
    protected boolean processParsedLineInternal() {
        TaskUsage taskUsage = this.createTaskUsageFromTraceLine();
        return this.brokers.stream().flatMap(broker -> broker.getCloudletSubmittedList().stream()).filter(cloudlet -> cloudlet.getId() == taskUsage.getUniqueTaskId()).findFirst().map(cloudlet -> this.requestCloudletUsageChange((Cloudlet)cloudlet, taskUsage)).isPresent();
    }

    private TaskUsage createTaskUsageFromTraceLine() {
        TaskUsage usage = new TaskUsage();
        usage.setStartTime((Double)FieldIndex.START_TIME.getValue(this)).setEndTime((Double)FieldIndex.END_TIME.getValue(this)).setMeanCpuUsageRate((Double)FieldIndex.MEAN_CPU_USAGE_RATE.getValue(this)).setCanonicalMemoryUsage((Double)FieldIndex.CANONICAL_MEMORY_USAGE.getValue(this)).setAssignedMemoryUsage((Double)FieldIndex.ASSIGNED_MEMORY_USAGE.getValue(this)).setMaximumMemoryUsage((Double)FieldIndex.MAXIMUM_MEMORY_USAGE.getValue(this)).setMeanDiskIoTime((Double)FieldIndex.MEAN_DISK_IO_TIME.getValue(this)).setMeanLocalDiskSpaceUsed((Double)FieldIndex.MEAN_LOCAL_DISK_SPACE_USED.getValue(this)).setMaximumCpuUsage((Double)FieldIndex.MAXIMUM_CPU_USAGE.getValue(this)).setMaximumDiskIoTime((Double)FieldIndex.MAXIMUM_DISK_IO_TIME.getValue(this)).setJobId((Long)FieldIndex.JOB_ID.getValue(this)).setTaskIndex((Long)FieldIndex.TASK_INDEX.getValue(this)).setMachineId((Long)FieldIndex.MACHINE_ID.getValue(this));
        return usage;
    }

    private boolean requestCloudletUsageChange(Cloudlet cloudlet, TaskUsage taskUsage) {
        Runnable resourceUsageUpdateRunnable = () -> {
            StringBuilder builder = new StringBuilder();
            if (cloudlet.getUtilizationOfCpu() != taskUsage.getMeanCpuUsageRate()) {
                builder.append("CPU Utilization: ").append(this.formatPercentValue(cloudlet.getUtilizationOfCpu())).append(" -> ").append(this.formatPercentValue(taskUsage.getMeanCpuUsageRate())).append('%').append(" | ");
                cloudlet.setUtilizationModelCpu(this.createUtilizationModel(cloudlet.getUtilizationModelCpu(), taskUsage.getMeanCpuUsageRate()));
            }
            if (cloudlet.getUtilizationOfRam() != taskUsage.getCanonicalMemoryUsage()) {
                builder.append("RAM Utilization: ").append(this.formatPercentValue(cloudlet.getUtilizationOfRam())).append(" -> ").append(this.formatPercentValue(taskUsage.getCanonicalMemoryUsage())).append('%').append(" | ");
                cloudlet.setUtilizationModelRam(this.createUtilizationModel(cloudlet.getUtilizationModelRam(), taskUsage.getCanonicalMemoryUsage()));
            }
            DatacenterBroker broker = cloudlet.getBroker();
            DatacenterBroker.LOGGER.trace("{}: {}: {} resource usage changed: {}", new Object[]{this.simulation.clock(), broker.getName(), cloudlet, builder});
            cloudlet.getVm().getHost().updateProcessing(this.simulation.clock());
        };
        if (this.hasCloudletResourceUsageChanged(cloudlet, taskUsage)) {
            this.addAvailableObject(cloudlet);
            CloudSimEvent evt = new CloudSimEvent(taskUsage.getStartTime(), cloudlet.getBroker(), 27, resourceUsageUpdateRunnable);
            return this.cloudletUsageChangeEvents.add(evt);
        }
        return false;
    }

    private UtilizationModel createUtilizationModel(UtilizationModel source, double initialUtilization) {
        if (source instanceof UtilizationModelDynamic) {
            return new UtilizationModelDynamic((UtilizationModelDynamic)source, initialUtilization);
        }
        return new UtilizationModelDynamic(initialUtilization);
    }

    private boolean hasCloudletResourceUsageChanged(Cloudlet cloudlet, TaskUsage taskUsage) {
        return cloudlet.getUtilizationOfCpu() != taskUsage.getMeanCpuUsageRate() || cloudlet.getUtilizationOfRam() != taskUsage.getCanonicalMemoryUsage();
    }

    public static enum FieldIndex implements TraceField<GoogleTaskUsageTraceReader>
    {
        START_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return Conversion.microToSeconds(reader.getFieldDoubleValue(this));
            }
        }
        ,
        END_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return Conversion.microToSeconds(reader.getFieldDoubleValue(this));
            }
        }
        ,
        JOB_ID{

            @Override
            public Long getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldLongValue(this);
            }
        }
        ,
        TASK_INDEX{

            @Override
            public Long getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldLongValue(this);
            }
        }
        ,
        MACHINE_ID{

            @Override
            public Long getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldLongValue(this, -1L);
            }
        }
        ,
        MEAN_CPU_USAGE_RATE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        CANONICAL_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        ASSIGNED_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        UNMAPPED_PAGE_CACHE_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        TOTAL_PAGE_CACHE_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        MAXIMUM_MEMORY_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, -1.0);
            }
        }
        ,
        MEAN_DISK_IO_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        MEAN_LOCAL_DISK_SPACE_USED{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        MAXIMUM_CPU_USAGE{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, -1.0);
            }
        }
        ,
        MAXIMUM_DISK_IO_TIME{

            @Override
            public Double getValue(GoogleTaskUsageTraceReader reader) {
                return reader.getFieldDoubleValue(this, -1.0);
            }
        };

    }
}

