/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.migration;

import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigration;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.util.MathUtil;

public class VmAllocationPolicyMigrationInterQuartileRange
extends VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit {
    private static final int MIN_HISTORY_ENTRIES_FOR_IRQ = 12;

    public VmAllocationPolicyMigrationInterQuartileRange(VmSelectionPolicy vmSelectionPolicy) {
        super(vmSelectionPolicy);
    }

    public VmAllocationPolicyMigrationInterQuartileRange(VmSelectionPolicy vmSelectionPolicy, double safetyParameter, VmAllocationPolicyMigration fallbackPolicy) {
        super(vmSelectionPolicy, safetyParameter, fallbackPolicy);
    }

    @Override
    public double computeHostUtilizationMeasure(Host host) throws IllegalStateException {
        double[] cpuUsageArray = this.getHostCpuUsageArray(host);
        if (MathUtil.countNonZeroBeginning(cpuUsageArray) >= 12) {
            return MathUtil.iqr(cpuUsageArray);
        }
        throw new IllegalStateException("There is not enough Host history to compute Host utilization IRQ");
    }
}

