/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cloudbus.cloudsim.cloudlets.CloudletSimple;
import org.cloudbus.cloudsim.cloudlets.network.CloudletExecutionTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletTask;

public class NetworkCloudlet
extends CloudletSimple {
    private int currentTaskNum = -1;
    private final List<CloudletTask> tasks = new ArrayList<CloudletTask>();
    private long memory = 0L;

    public NetworkCloudlet(long length, int pesNumber) {
        this(-1, length, pesNumber);
    }

    public NetworkCloudlet(int id, long length, int pesNumber) {
        super((long)id, length, pesNumber);
    }

    public double getNumberOfTasks() {
        return this.tasks.size();
    }

    public List<CloudletTask> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public long getMemory() {
        return this.memory;
    }

    public NetworkCloudlet setMemory(long memory) {
        this.memory = memory;
        return this;
    }

    public boolean isTasksStarted() {
        return this.currentTaskNum > -1;
    }

    public boolean startNextTaskIfCurrentIsFinished(double nextTaskStartTime) {
        Optional<CloudletTask> optional = this.getNextTaskIfCurrentIfFinished();
        optional.ifPresent(task -> task.setStartTime(nextTaskStartTime));
        return optional.isPresent();
    }

    public Optional<CloudletTask> getCurrentTask() {
        if (this.currentTaskNum < 0 || this.currentTaskNum >= this.tasks.size()) {
            return Optional.empty();
        }
        return Optional.of(this.tasks.get(this.currentTaskNum));
    }

    private Optional<CloudletTask> getNextTaskIfCurrentIfFinished() {
        if (this.getCurrentTask().filter(CloudletTask::isActive).isPresent()) {
            return Optional.empty();
        }
        if (this.currentTaskNum <= this.tasks.size() - 1) {
            ++this.currentTaskNum;
        }
        return this.getCurrentTask();
    }

    @Override
    public boolean isFinished() {
        boolean allTasksFinished = this.tasks.stream().allMatch(CloudletTask::isFinished);
        return super.isFinished() && allTasksFinished;
    }

    @Override
    public long getLength() {
        return this.getTasks().stream().filter(CloudletTask::isExecutionTask).map(task -> (CloudletExecutionTask)task).mapToLong(CloudletExecutionTask::getLength).sum();
    }

    public NetworkCloudlet addTask(CloudletTask task) {
        task.setCloudlet(this);
        this.tasks.add(task);
        return this;
    }
}

