/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.CloudSimEvent;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudSimEntity
implements SimEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudSimEntity.class.getSimpleName());
    private boolean started;
    private Simulation simulation;
    private String name;
    private long id;
    private SimEvent buffer;
    private SimEntity.State state;

    public CloudSimEntity(Simulation simulation) {
        this.setSimulation(simulation);
        this.setId(-1);
        this.state = SimEntity.State.RUNNABLE;
        this.simulation.addEntity(this);
        this.started = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void start() {
        this.startEntity();
        this.setStarted(true);
    }

    @Override
    public void shutdownEntity() {
        this.setState(SimEntity.State.FINISHED);
    }

    protected abstract void startEntity();

    @Override
    public boolean schedule(SimEntity dest, double delay, int tag, Object data) {
        return this.schedule(new CloudSimEvent(delay, this, dest, tag, data));
    }

    @Override
    public boolean schedule(double delay, int tag, Object data) {
        return this.schedule(this, delay, tag, data);
    }

    @Override
    public boolean schedule(SimEntity dest, double delay, int tag) {
        return this.schedule(dest, delay, tag, null);
    }

    @Override
    public boolean schedule(int tag, Object data) {
        return this.schedule(this, 0.0, tag, data);
    }

    @Override
    public boolean schedule(SimEvent evt) {
        if (!this.canSendEvent(evt)) {
            return false;
        }
        this.simulation.send(evt);
        return true;
    }

    private boolean canSendEvent(SimEvent evt) {
        if (!this.simulation.isRunning() && evt.getTag() != -1) {
            LOGGER.warn("{}: Cannot send events before simulation start. Trying to send message {} to {}", new Object[]{this, evt.getTag(), evt.getDestination()});
            return false;
        }
        return true;
    }

    public void scheduleNow(SimEntity dest, int tag, Object data) {
        this.schedule(dest, 0.0, tag, data);
    }

    public void scheduleNow(SimEntity dest, int tag) {
        this.schedule(dest, 0.0, tag, null);
    }

    public void scheduleFirstNow(SimEntity dest, int tag, Object data) {
        this.scheduleFirst(dest, 0.0, tag, data);
    }

    public void scheduleFirstNow(SimEntity dest, int tag) {
        this.scheduleFirst(dest, 0.0, tag, null);
    }

    public void scheduleFirst(SimEntity dest, double delay, int tag) {
        this.scheduleFirst(dest, delay, tag, null);
    }

    public void scheduleFirst(SimEntity dest, double delay, int tag, Object data) {
        CloudSimEvent evt = new CloudSimEvent(delay, this, dest, tag, data);
        if (!this.canSendEvent(evt)) {
            return;
        }
        this.simulation.sendFirst(evt);
    }

    public void pause(double delay) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Negative delay supplied.");
        }
        if (!this.simulation.isRunning()) {
            return;
        }
        this.simulation.pauseEntity(this, delay);
    }

    public SimEvent selectEvent(Predicate<SimEvent> predicate) {
        if (!this.simulation.isRunning()) {
            return SimEvent.NULL;
        }
        return this.simulation.select(this, predicate);
    }

    public SimEvent cancelEvent(Predicate<SimEvent> predicate) {
        return this.simulation.isRunning() ? this.simulation.cancel(this, predicate) : SimEvent.NULL;
    }

    public SimEvent getNextEvent(Predicate<SimEvent> predicate) {
        if (!this.simulation.isRunning()) {
            return SimEvent.NULL;
        }
        return this.selectEvent(predicate);
    }

    public SimEvent getNextEvent() {
        return this.getNextEvent(Simulation.ANY_EVT);
    }

    public void waitForEvent(Predicate<SimEvent> predicate) {
        if (!this.simulation.isRunning()) {
            return;
        }
        this.simulation.wait(this, predicate);
        this.state = SimEntity.State.WAITING;
    }

    @Override
    public void run() {
        SimEvent evt;
        SimEvent simEvent = evt = this.buffer == null ? this.getNextEvent() : this.buffer;
        while (evt != SimEvent.NULL) {
            this.processEvent(evt);
            if (this.state != SimEntity.State.RUNNABLE) break;
            evt = this.getNextEvent();
        }
        this.buffer = null;
    }

    protected final Object clone() throws CloneNotSupportedException {
        CloudSimEntity copy = (CloudSimEntity)super.clone();
        copy.setName(this.name);
        copy.setSimulation(this.simulation);
        copy.setEventBuffer(null);
        return copy;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final SimEntity setSimulation(Simulation simulation) {
        this.simulation = Objects.requireNonNull(simulation);
        return this;
    }

    @Override
    public SimEntity setName(String name) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Entity names cannot be empty.");
        }
        if (name.contains(" ")) {
            throw new IllegalArgumentException("Entity names cannot contain spaces.");
        }
        this.name = name;
        return this;
    }

    @Override
    public SimEntity.State getState() {
        return this.state;
    }

    @Override
    public SimEntity setState(SimEntity.State state) {
        this.state = state;
        return this;
    }

    protected final void setId(int id) {
        this.id = id;
        this.setAutomaticName();
    }

    private void setAutomaticName() {
        long id = this.id >= 0L ? this.id : (long)this.simulation.getNumEntities();
        this.name = String.format("%s%d", this.getClass().getSimpleName(), id);
    }

    protected void setEventBuffer(SimEvent evt) {
        this.buffer = evt;
    }

    protected void send(SimEntity dest, double delay, int cloudSimTag, Object data) {
        Objects.requireNonNull(dest);
        if (dest.getId() < 0L) {
            LOGGER.error("{}.send(): invalid entity id {} for {}", new Object[]{this.getName(), dest.getId(), dest});
            return;
        }
        if (delay < 0.0) {
            delay = 0.0;
        }
        if (Double.isInfinite(delay)) {
            throw new IllegalArgumentException("The specified delay is infinite value");
        }
        if (dest.getId() != this.getId()) {
            delay += this.getNetworkDelay(this.getId(), dest.getId());
        }
        this.schedule(dest, delay, cloudSimTag, data);
    }

    protected void send(SimEntity dest, double delay, int cloudSimTag) {
        this.send(dest, delay, cloudSimTag, null);
    }

    protected void sendNow(SimEntity dest, int cloudSimTag, Object data) {
        this.send(dest, 0.0, cloudSimTag, data);
    }

    protected void sendNow(SimEntity dest, int cloudSimTag) {
        this.send(dest, 0.0, cloudSimTag, null);
    }

    private double getNetworkDelay(long src, long dst) {
        return this.getSimulation().getNetworkTopology().getDelay(src, dst);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isAlive() {
        return this.state != SimEntity.State.FINISHED;
    }

    @Override
    public boolean isFinished() {
        return this.state == SimEntity.State.FINISHED;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public int compareTo(SimEntity entity) {
        return Long.compare(this.getId(), entity.getId());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CloudSimEntity that = (CloudSimEntity)object;
        if (this.id != that.id) {
            return false;
        }
        return this.simulation.equals(that.simulation);
    }

    public int hashCode() {
        int result = this.simulation.hashCode();
        result = 31 * result + Long.hashCode(this.id);
        return result;
    }
}

