/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.distributions;

import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.cloudbus.cloudsim.distributions.ContinuousDistributionAbstract;

public class ZipfDistr
extends ContinuousDistributionAbstract {
    private final double shape;
    private double den;

    public ZipfDistr(long seed, double shape, int population) {
        super((RealDistribution)new UniformRealDistribution(0.0, 1.0), seed);
        if (shape <= 0.0 || population < 1) {
            throw new IllegalArgumentException("Mean must be greater than 0.0 and population greater than 0");
        }
        this.shape = shape;
        this.computeDen(shape, population);
    }

    public ZipfDistr(double shape, int population) {
        this(-1L, shape, population);
    }

    @Override
    public double sample() {
        double variate = super.sample();
        double num = 1.0;
        double nextNum = 1.0 + 1.0 / Math.pow(2.0, this.shape);
        double j = 3.0;
        while (variate > nextNum / this.den) {
            num = nextNum;
            nextNum += 1.0 / Math.pow(j, this.shape);
            j += 1.0;
        }
        return num / this.den;
    }

    private void computeDen(double shape, int population) {
        this.den = 0.0;
        for (int j = 1; j <= population; ++j) {
            this.den += 1.0 / Math.pow(j, shape);
        }
    }
}

