/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.AbstractSwitch;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.network.switches.RootSwitch;
import org.cloudbus.cloudsim.network.switches.Switch;

public class AggregateSwitch
extends AbstractSwitch {
    public static final int LEVEL = 1;
    public static final double SWITCHING_DELAY = 0.00245;
    public static final long DOWNLINK_BW = 0x32000000L;
    public static final int PORTS = 1;

    public AggregateSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setUplinkBandwidth(RootSwitch.DOWNLINK_BW);
        this.setDownlinkBandwidth(8.388608E8);
        this.setSwitchingDelay(0.00245);
        this.setPorts(1);
    }

    @Override
    protected void processPacketDown(SimEvent evt) {
        super.processPacketDown(evt);
        HostPacket netPkt = (HostPacket)evt.getData();
        EdgeSwitch downlinkSw = this.getVmEdgeSwitch(netPkt);
        this.addPacketToSendToDownlinkSwitch(downlinkSw, netPkt);
    }

    @Override
    protected void processPacketUp(SimEvent evt) {
        super.processPacketUp(evt);
        HostPacket netPkt = (HostPacket)evt.getData();
        EdgeSwitch downlinkSw = this.getVmEdgeSwitch(netPkt);
        if (this.findConnectedEdgeSwitch(downlinkSw)) {
            this.addPacketToSendToDownlinkSwitch(downlinkSw, netPkt);
        } else {
            this.addPacketToBeSentToFirstUplinkSwitch(netPkt);
        }
    }

    private boolean findConnectedEdgeSwitch(Switch edgeSwitch) {
        return this.getDownlinkSwitches().stream().anyMatch(edgeSwitch::equals);
    }

    @Override
    public int getLevel() {
        return 1;
    }
}

