/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.network.NetworkHost;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.AbstractSwitch;
import org.cloudbus.cloudsim.vms.Vm;

public class EdgeSwitch
extends AbstractSwitch {
    private static final long DEF_DOWNLINK_BW = 800L;
    private static final double DEF_SWITCHING_DELAY = 0.00157;
    public static final int LEVEL = 2;
    public static final int PORTS = 4;
    private final List<NetworkHost> hostList = new ArrayList<NetworkHost>();

    public EdgeSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setUplinkBandwidth(8.388608E8);
        this.setDownlinkBandwidth(800.0);
        this.setSwitchingDelay(0.00157);
        this.setPorts(4);
    }

    @Override
    protected void processPacketDown(SimEvent evt) {
        super.processPacketDown(evt);
        HostPacket pkt = this.extractReceivedHostPacket(evt);
        this.addPacketToSendToHost(pkt.getDestination(), pkt);
    }

    private HostPacket extractReceivedHostPacket(SimEvent evt) {
        HostPacket pkt = (HostPacket)evt.getData();
        Vm receiverVm = pkt.getVmPacket().getDestination();
        NetworkHost host = this.getVmHost(receiverVm);
        pkt.setDestination(host);
        return pkt;
    }

    @Override
    protected void processPacketUp(SimEvent evt) {
        super.processPacketUp(evt);
        HostPacket pkt = this.extractReceivedHostPacket(evt);
        if (pkt.getDestination() != null && pkt.getDestination() != Host.NULL) {
            this.addPacketToSendToHost(pkt.getDestination(), pkt);
            return;
        }
        this.addPacketToBeSentToFirstUplinkSwitch(pkt);
    }

    @Override
    public int getLevel() {
        return 2;
    }

    public List<NetworkHost> getHostList() {
        return Collections.unmodifiableList(this.hostList);
    }

    public void connectHost(NetworkHost host) {
        this.hostList.add(Objects.requireNonNull(host));
        host.setEdgeSwitch(this);
    }

    public boolean disconnectHost(NetworkHost host) {
        if (this.hostList.remove(host)) {
            host.setEdgeSwitch(null);
            return true;
        }
        return false;
    }
}

