/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.topologies;

import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.cloudbus.cloudsim.network.DelayMatrix;
import org.cloudbus.cloudsim.network.topologies.NetworkTopology;
import org.cloudbus.cloudsim.network.topologies.TopologicalGraph;
import org.cloudbus.cloudsim.network.topologies.TopologicalLink;
import org.cloudbus.cloudsim.network.topologies.TopologicalNode;
import org.cloudbus.cloudsim.network.topologies.readers.TopologyReaderBrite;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BriteNetworkTopology
implements NetworkTopology {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BriteNetworkTopology.class.getSimpleName());
    private int nextIdx;
    private boolean networkEnabled;
    private DelayMatrix delayMatrix;
    private double[][] bwMatrix;
    private TopologicalGraph graph;
    private Map<Long, Integer> entitiesMap = new HashMap<Long, Integer>();

    public static BriteNetworkTopology getInstance(String fileName) {
        InputStreamReader reader = new InputStreamReader(ResourceLoader.getInputStream(fileName, BriteNetworkTopology.class));
        return new BriteNetworkTopology(reader);
    }

    public BriteNetworkTopology() {
        this.bwMatrix = new double[0][0];
        this.graph = new TopologicalGraph();
        this.delayMatrix = new DelayMatrix();
    }

    public BriteNetworkTopology(String filePath) {
        this(ResourceLoader.getFileReader(filePath));
        LOGGER.info("Topology file: {}", (Object)filePath);
    }

    private BriteNetworkTopology(InputStreamReader streamReader) {
        this();
        TopologyReaderBrite reader = new TopologyReaderBrite();
        this.graph = reader.readGraphFile(streamReader);
        this.generateMatrices();
    }

    private void generateMatrices() {
        this.delayMatrix = new DelayMatrix(this.getTopologycalGraph(), false);
        this.bwMatrix = this.createBwMatrix(this.getTopologycalGraph(), false);
        this.networkEnabled = true;
    }

    private double[][] createBwMatrix(TopologicalGraph graph, boolean directed) {
        int nodes = graph.getNumberOfNodes();
        double[][] mtx = new double[nodes][nodes];
        for (int i = 0; i < nodes; ++i) {
            for (int j = 0; j < nodes; ++j) {
                mtx[i][j] = 0.0;
            }
        }
        for (TopologicalLink edge : graph.getLinksList()) {
            mtx[edge.getSrcNodeID()][edge.getDestNodeID()] = edge.getLinkBw();
            if (directed) continue;
            mtx[edge.getDestNodeID()][edge.getSrcNodeID()] = edge.getLinkBw();
        }
        return mtx;
    }

    @Override
    public void addLink(long srcId, long destId, double bandwidth, double latency) {
        if (this.getTopologycalGraph() == null) {
            this.graph = new TopologicalGraph();
        }
        if (this.entitiesMap == null) {
            this.entitiesMap = new HashMap<Long, Integer>();
        }
        this.addNodeMapping(srcId);
        this.addNodeMapping(destId);
        this.getTopologycalGraph().addLink(new TopologicalLink(this.entitiesMap.get(srcId), this.entitiesMap.get(destId), (float)latency, (float)bandwidth));
        this.generateMatrices();
    }

    private void addNodeMapping(long cloudSimEntityId) {
        if (this.entitiesMap.putIfAbsent(cloudSimEntityId, this.nextIdx) == null) {
            this.getTopologycalGraph().addNode(new TopologicalNode(this.nextIdx));
            ++this.nextIdx;
        }
    }

    @Override
    public void mapNode(long cloudSimEntityID, int briteID) {
        if (!this.networkEnabled) {
            return;
        }
        if (this.entitiesMap.containsKey(cloudSimEntityID)) {
            LOGGER.warn("Network mapping: CloudSim entity {} already mapped.", (Object)cloudSimEntityID);
            return;
        }
        if (this.entitiesMap.containsValue(briteID)) {
            LOGGER.warn("BRITE node {} already in use.", (Object)briteID);
            return;
        }
        this.entitiesMap.put(cloudSimEntityID, briteID);
    }

    @Override
    public void unmapNode(long cloudSimEntityID) {
        if (!this.networkEnabled) {
            return;
        }
        this.entitiesMap.remove(cloudSimEntityID);
    }

    @Override
    public double getDelay(long srcID, long destID) {
        if (!this.networkEnabled) {
            return 0.0;
        }
        try {
            return this.delayMatrix.getDelay(this.entitiesMap.getOrDefault(srcID, -1), this.entitiesMap.getOrDefault(destID, -1));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0.0;
        }
    }

    @Override
    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    @Override
    public TopologicalGraph getTopologycalGraph() {
        return this.graph;
    }

    public double[][] getBwMatrix() {
        return (double[][])Arrays.copyOf(this.bwMatrix, this.bwMatrix.length);
    }
}

