/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import org.cloudbus.cloudsim.resources.File;
import org.cloudbus.cloudsim.resources.HarddriveStorage;

public class SanStorage
extends HarddriveStorage {
    private double bandwidth;
    private double networkLatency;

    public SanStorage(long capacity, double bandwidth, double networkLatency) throws IllegalArgumentException {
        super(capacity);
        this.setBandwidth(bandwidth);
        this.setNetworkLatency(networkLatency);
    }

    public SanStorage(String name, long capacity, double bandwidth, double networkLatency) {
        super(name, capacity);
        this.bandwidth = bandwidth;
        this.networkLatency = networkLatency;
    }

    @Override
    public double addReservedFile(File file) {
        double time = super.addReservedFile(file);
        return time + this.getTransferTime(file);
    }

    @Override
    public double addFile(File file) {
        double time = super.addFile(file);
        if (time > 0.0) {
            return time + this.getTransferTime(file);
        }
        return time;
    }

    @Override
    public double getTransferTime(int fileSize) {
        double storageDeviceReadTime = super.getTransferTime(fileSize);
        double networkTransferTime = this.getTransferTime(fileSize, this.bandwidth);
        return storageDeviceReadTime + networkTransferTime + this.getNetworkLatency();
    }

    @Override
    public double deleteFile(File file) {
        double time = super.deleteFile(file);
        return time + this.getTransferTime(file);
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public final void setBandwidth(double bandwidth) {
        if (bandwidth <= 0.0) {
            throw new IllegalArgumentException("Bandwidth must be higher than zero");
        }
        this.bandwidth = bandwidth;
    }

    public double getNetworkLatency() {
        return this.networkLatency;
    }

    public final void setNetworkLatency(double networkLatency) {
        if (networkLatency <= 0.0) {
            throw new IllegalArgumentException("Latency must be higher than zero");
        }
        this.networkLatency = networkLatency;
    }

    public String toString() {
        return this.getName();
    }
}

