/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.cloudlet.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.network.CloudletExecutionTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletReceiveTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletSendTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletTask;
import org.cloudbus.cloudsim.cloudlets.network.NetworkCloudlet;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.network.VmPacket;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.CloudletTaskScheduler;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudletTaskSchedulerSimple
implements CloudletTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudletTaskSchedulerSimple.class.getSimpleName());
    private Vm vm;
    private final List<VmPacket> vmPacketsToSend = new ArrayList<VmPacket>();
    private final Map<Vm, List<VmPacket>> vmPacketsReceivedMap = new HashMap<Vm, List<VmPacket>>();

    @Override
    public void processCloudletTasks(Cloudlet cloudlet, long partialFinishedMI) {
        if (cloudlet.isFinished() || this.isNotNetworkCloudlet(cloudlet)) {
            return;
        }
        NetworkCloudlet netcl = (NetworkCloudlet)cloudlet;
        if (!netcl.isTasksStarted()) {
            this.scheduleNextTaskIfCurrentIsFinished(netcl);
            return;
        }
        if (this.isTimeToUpdateCloudletProcessing(netcl)) {
            this.updateExecutionTask(netcl, partialFinishedMI);
        } else {
            this.updateNetworkTasks(netcl);
        }
    }

    private void updateExecutionTask(NetworkCloudlet cloudlet, long partialFinishedMI) {
        Optional<CloudletExecutionTask> optional = this.getCloudletCurrentTask(cloudlet);
        optional.ifPresent(task -> {
            task.process(partialFinishedMI);
            this.scheduleNextTaskIfCurrentIsFinished(cloudlet);
        });
    }

    private void updateNetworkTasks(NetworkCloudlet netcl) {
        netcl.getCurrentTask().ifPresent(task -> {
            if (task.isSendTask()) {
                this.addPacketsToBeSentFromVm(netcl);
            } else if (task.isReceiveTask()) {
                this.receivePackets(netcl);
            }
        });
    }

    @Override
    public boolean isTimeToUpdateCloudletProcessing(Cloudlet cloudlet) {
        Objects.requireNonNull(cloudlet);
        if (cloudlet.isFinished()) {
            return false;
        }
        if (this.isNotNetworkCloudlet(cloudlet)) {
            return true;
        }
        return ((NetworkCloudlet)cloudlet).getCurrentTask().filter(CloudletTask::isExecutionTask).isPresent();
    }

    private boolean isNotNetworkCloudlet(Cloudlet cloudlet) {
        return !(cloudlet instanceof NetworkCloudlet);
    }

    private void addPacketsToBeSentFromVm(NetworkCloudlet sourceCloudlet) {
        Optional<CloudletSendTask> optional = this.getCloudletCurrentTask(sourceCloudlet);
        optional.ifPresent(task -> {
            LOGGER.trace("{}: {}: {} pkts added to be sent from {} in {}", new Object[]{sourceCloudlet.getSimulation().clock(), this.getClass().getSimpleName(), task.getPacketsToSend().size(), sourceCloudlet, sourceCloudlet.getVm()});
            this.vmPacketsToSend.addAll(task.getPacketsToSend(sourceCloudlet.getSimulation().clock()));
            this.scheduleNextTaskIfCurrentIsFinished(sourceCloudlet);
        });
    }

    private void receivePackets(NetworkCloudlet candidateDestinationCloudlet) {
        Optional<CloudletReceiveTask> optional = this.getCloudletCurrentTask(candidateDestinationCloudlet);
        optional.ifPresent(task -> {
            List<VmPacket> receivedPkts = this.getPacketsSentToCloudlet((CloudletReceiveTask)task);
            receivedPkts.forEach(task::receivePacket);
            receivedPkts.forEach(pkt -> LOGGER.trace("{}: {}: {} in {} received pkt with {} bytes from {} in {}", new Object[]{candidateDestinationCloudlet.getSimulation().clock(), this.getClass().getSimpleName(), pkt.getReceiverCloudlet(), pkt.getDestination(), pkt.getSize(), pkt.getSenderCloudlet(), pkt.getSource()}));
            this.getListOfPacketsSentFromVm(task.getSourceVm()).removeAll(receivedPkts);
            this.scheduleNextTaskIfCurrentIsFinished(candidateDestinationCloudlet);
        });
    }

    private <T extends CloudletTask> Optional<T> getCloudletCurrentTask(NetworkCloudlet cloudlet) {
        return cloudlet.getCurrentTask().map(task -> task);
    }

    private List<VmPacket> getPacketsSentToCloudlet(CloudletReceiveTask receiveTask) {
        List<VmPacket> pktsFromExpectedSenderVm = this.getListOfPacketsSentFromVm(receiveTask.getSourceVm());
        return pktsFromExpectedSenderVm.stream().filter(pkt -> pkt.getDestination().equals(receiveTask.getCloudlet().getVm())).filter(pkt -> pkt.getReceiverCloudlet().equals(receiveTask.getCloudlet())).collect(Collectors.toList());
    }

    private void scheduleNextTaskIfCurrentIsFinished(NetworkCloudlet cloudlet) {
        if (!cloudlet.startNextTaskIfCurrentIsFinished(cloudlet.getSimulation().clock())) {
            return;
        }
        Datacenter dc = this.getVm().getHost().getDatacenter();
        dc.schedule(dc, dc.getSimulation().getMinTimeBetweenEvents(), 41);
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public void setVm(Vm vm) {
        this.vm = Objects.requireNonNull(vm);
    }

    @Override
    public void clearVmPacketsToSend() {
        this.vmPacketsToSend.clear();
    }

    @Override
    public List<VmPacket> getVmPacketsToSend() {
        return Collections.unmodifiableList(this.vmPacketsToSend);
    }

    private List<VmPacket> getListOfPacketsSentFromVm(Vm sourceVm) {
        this.vmPacketsReceivedMap.putIfAbsent(sourceVm, new ArrayList());
        return this.vmPacketsReceivedMap.get(sourceVm);
    }

    @Override
    public boolean addPacketToListOfPacketsSentFromVm(VmPacket pkt) {
        return this.getListOfPacketsSentFromVm(pkt.getSource()).add(pkt);
    }
}

