/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerSpaceShared;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VmSchedulerAbstract
implements VmScheduler {
    public static final double DEFAULT_VM_MIGRATION_CPU_OVERHEAD = 0.1;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VmSchedulerSpaceShared.class.getSimpleName());
    private final Map<Vm, List<Double>> requestedMipsMap;
    private Host host;
    private Map<Vm, List<Double>> allocatedMipsMap;
    private final double vmMigrationCpuOverhead;

    public VmSchedulerAbstract(double vmMigrationCpuOverhead) {
        if (vmMigrationCpuOverhead < 0.0 || vmMigrationCpuOverhead >= 1.0) {
            throw new IllegalArgumentException("vmMigrationCpuOverhead must be a percentage value between [0 and 1[");
        }
        this.setHost(Host.NULL);
        this.vmMigrationCpuOverhead = vmMigrationCpuOverhead;
        this.requestedMipsMap = new HashMap<Vm, List<Double>>();
    }

    @Override
    public final boolean isSuitableForVm(Vm vm) {
        return this.isSuitableForVm(vm, vm.getCurrentRequestedMips());
    }

    @Override
    public boolean isSuitableForVm(Vm vm, List<Double> requestedMips) {
        if (requestedMips.isEmpty()) {
            LOGGER.warn("{}: {}: It was requested an empty list of PEs for {} in {}", new Object[]{this.getHost().getSimulation().clock(), this.getClass().getSimpleName(), vm, this.host});
            return false;
        }
        return this.isSuitableForVmInternal(vm, requestedMips);
    }

    protected abstract boolean isSuitableForVmInternal(Vm var1, List<Double> var2);

    @Override
    public final boolean allocatePesForVm(Vm vm) {
        List<Double> mipsShareRequested = LongStream.range(0L, vm.getNumberOfPes()).mapToObj(idx -> vm.getMips()).collect(Collectors.toList());
        return this.allocatePesForVm(vm, mipsShareRequested);
    }

    @Override
    public final boolean allocatePesForVm(Vm vm, List<Double> requestedMips) {
        if (!vm.isInMigration() && this.host.getVmsMigratingOut().contains(vm)) {
            this.host.removeVmMigratingOut(vm);
        }
        this.requestedMipsMap.put(vm, requestedMips);
        if (this.allocatePesForVmInternal(vm, requestedMips)) {
            this.updateStatusOfHostPesUsedByVm(vm, this.getHost().getFreePeList(), Pe.Status.BUSY);
            return true;
        }
        return false;
    }

    private void updateStatusOfHostPesUsedByVm(Vm vm, List<Pe> peList, Pe.Status newStatus) {
        this.updateStatusOfHostPesUsedByVm(peList, newStatus, vm.getNumberOfPes());
    }

    private void updateStatusOfHostPesUsedByVm(List<Pe> peList, Pe.Status newStatus, long vPesNumber) {
        if (vPesNumber <= 0L) {
            return;
        }
        List<Pe> selectedPes = peList.stream().limit(vPesNumber).collect(Collectors.toList());
        ((HostSimple)this.host).setPeStatus(selectedPes, newStatus);
    }

    protected abstract boolean allocatePesForVmInternal(Vm var1, List<Double> var2);

    @Override
    public void deallocatePesFromVm(Vm vm) {
        this.deallocatePesFromVm(vm, (int)vm.getNumberOfPes());
    }

    @Override
    public void deallocatePesFromVm(Vm vm, int pesToRemove) {
        if (pesToRemove <= 0 || vm.getNumberOfPes() == 0L) {
            return;
        }
        this.deallocatePesFromVmInternal(vm, pesToRemove);
        this.updateHostUsedPesToFree();
    }

    private void updateHostUsedPesToFree() {
        long totalVirtualPes = this.getAllocatedMipsMap().values().stream().mapToLong(Collection::size).sum();
        List<Pe> busyPeList = this.host.getBusyPeList();
        long virtualPesToFree = Math.max((long)busyPeList.size() - totalVirtualPes, 0L);
        this.updateStatusOfHostPesUsedByVm(busyPeList, Pe.Status.FREE, virtualPesToFree);
    }

    protected <T> int removePesFromMap(Vm vm, Map<Vm, List<T>> map, int pesToRemove) {
        List values = map.getOrDefault(vm, new ArrayList());
        if (values.isEmpty()) {
            return 0;
        }
        pesToRemove = Math.min((int)vm.getNumberOfPes(), pesToRemove);
        pesToRemove = Math.min(pesToRemove, values.size());
        IntStream.range(0, pesToRemove).forEach(idx -> values.remove(0));
        if (values.isEmpty()) {
            map.remove(vm);
        }
        return pesToRemove;
    }

    protected abstract void deallocatePesFromVmInternal(Vm var1, int var2);

    @Override
    public void deallocatePesForAllVms() {
        this.allocatedMipsMap.clear();
        this.getWorkingPeList().forEach(pe -> pe.getPeProvisioner().deallocateResourceForAllVms());
    }

    @Override
    public List<Double> getAllocatedMips(Vm vm) {
        List<Double> list = this.allocatedMipsMap.getOrDefault(vm, new ArrayList());
        return this.host.getVmsMigratingOut().contains(vm) ? this.getMipsShareRequestedReduced(vm, list) : list;
    }

    protected List<Double> getMipsShareRequestedReduced(Vm vm, List<Double> mipsShareRequested) {
        double peMips = this.getPeCapacity();
        return mipsShareRequested.stream().map(mips -> Math.min(mips, peMips) * this.percentOfMipsToRequest(vm)).collect(Collectors.toList());
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.getAllocatedMips(vm).stream().mapToDouble(v -> v).sum();
    }

    @Override
    public double getMaxAvailableMips() {
        return this.getWorkingPeList().stream().map(Pe::getPeProvisioner).mapToDouble(ResourceProvisioner::getAvailableResource).max().orElse(0.0);
    }

    public long getPeCapacity() {
        return this.getWorkingPeList().stream().map(Pe::getCapacity).findFirst().orElse(0L);
    }

    public final List<Pe> getWorkingPeList() {
        return this.host.getWorkingPeList();
    }

    protected Map<Vm, List<Double>> getRequestedMipsMap() {
        return this.requestedMipsMap;
    }

    @Override
    public List<Double> getRequestedMips(Vm vm) {
        return new ArrayList<Double>(this.requestedMipsMap.getOrDefault(vm, Collections.emptyList()));
    }

    protected Map<Vm, List<Double>> getAllocatedMipsMap() {
        return this.allocatedMipsMap;
    }

    @Override
    public double getAvailableMips() {
        double allocatedMips = this.allocatedMipsMap.entrySet().stream().mapToDouble(this::actualVmTotalRequestedMips).sum();
        return this.host.getTotalMipsCapacity() - allocatedMips;
    }

    private double actualVmTotalRequestedMips(Map.Entry<Vm, List<Double>> entry) {
        List<Object> vmMipsList = entry.getValue() == null ? new ArrayList() : entry.getValue();
        double totalVmRequestedMips = vmMipsList.stream().reduce(0.0, Double::sum);
        return totalVmRequestedMips / this.percentOfMipsToRequest(entry.getKey());
    }

    protected double percentOfMipsToRequest(Vm vm) {
        if (this.host.getVmsMigratingIn().contains(vm)) {
            return this.vmMigrationCpuOverhead;
        }
        if (this.host.getVmsMigratingOut().contains(vm)) {
            return this.getMaxCpuUsagePercentDuringOutMigration();
        }
        return 1.0;
    }

    @Override
    public double getMaxCpuUsagePercentDuringOutMigration() {
        return 1.0 - this.vmMigrationCpuOverhead;
    }

    @Override
    public double getVmMigrationCpuOverhead() {
        return this.vmMigrationCpuOverhead;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public final VmScheduler setHost(Host host) {
        if (this.isOtherHostAssigned(Objects.requireNonNull(host))) {
            throw new IllegalStateException("VmScheduler already has a Host assigned to it. Each Host must have its own VmScheduler instance.");
        }
        this.host = host;
        this.allocatedMipsMap = new HashMap<Vm, List<Double>>();
        return this;
    }

    private boolean isOtherHostAssigned(Host host) {
        return this.host != null && this.host != Host.NULL && !host.equals(this.host);
    }
}

