/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerAbstract;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmSchedulerTimeShared
extends VmSchedulerAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VmSchedulerTimeShared.class.getSimpleName());

    public VmSchedulerTimeShared() {
        this(0.1);
    }

    public VmSchedulerTimeShared(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    public boolean allocatePesForVmInternal(Vm vm, List<Double> requestedMips) {
        if (!this.allocateMipsShareForVmInternal(vm, requestedMips)) {
            return false;
        }
        this.updatePesAllocationForAllVms();
        return true;
    }

    private boolean allocateMipsShareForVmInternal(Vm vm, List<Double> requestedMips) {
        if (!this.isSuitableForVm(vm, requestedMips)) {
            return false;
        }
        this.allocateMipsShareForVm(vm, requestedMips);
        return true;
    }

    protected void allocateMipsShareForVm(Vm vm, List<Double> requestedMipsReduced) {
        List<Double> mipsShare = this.getMipsShareToAllocate(vm, requestedMipsReduced);
        this.getAllocatedMipsMap().put(vm, mipsShare);
    }

    private void updatePesAllocationForAllVms() {
        this.clearAllocationOfPesForAllVms();
        this.getAllocatedMipsMap().entrySet().forEach(this::allocatePesListForVm);
    }

    private void clearAllocationOfPesForAllVms() {
        this.getHost().getPeList().forEach(pe -> pe.getPeProvisioner().deallocateResourceForAllVms());
    }

    private void allocatePesListForVm(Map.Entry<Vm, List<Double>> entry) {
        Vm vm = entry.getKey();
        Iterator<Pe> hostPesIterator = this.getWorkingPeList().iterator();
        for (double requestedMipsForVmPe : entry.getValue()) {
            double allocatedMipsForVmPe = this.allocateMipsFromHostPesToGivenVirtualPe(vm, requestedMipsForVmPe, hostPesIterator);
            if (!(requestedMipsForVmPe > 0.1) || !(allocatedMipsForVmPe <= 0.1)) continue;
            this.logMipsUnavailable(vm, requestedMipsForVmPe, allocatedMipsForVmPe);
        }
    }

    private void logMipsUnavailable(Vm vm, double requestedMipsForVmPe, double allocatedMipsForVmPe) {
        String msg = allocatedMipsForVmPe > 0.0 ? String.format("Only %.0f MIPS were allocated.", allocatedMipsForVmPe) : "No MIPS were allocated.";
        LOGGER.warn("{}: {}: {} is requiring a total of {} MIPS but the PEs of {} currently don't have such an available MIPS amount. {}", new Object[]{this.getHost().getSimulation().clock(), this.getClass().getSimpleName(), vm, (long)requestedMipsForVmPe, this.getHost(), msg});
    }

    private double allocateMipsFromHostPesToGivenVirtualPe(Vm vm, double requestedMipsForVmPe, Iterator<Pe> hostPesIterator) {
        if (requestedMipsForVmPe <= 0.0) {
            return 0.0;
        }
        double allocatedMipsForVmPe = 0.0;
        while (allocatedMipsForVmPe <= 0.0 && hostPesIterator.hasNext()) {
            Pe selectedHostPe = hostPesIterator.next();
            if (this.allocateAllVmPeRequestedMipsFromHostPe(vm, selectedHostPe, requestedMipsForVmPe)) {
                allocatedMipsForVmPe = requestedMipsForVmPe;
                continue;
            }
            allocatedMipsForVmPe += this.allocatedAvailableMipsFromHostPeToVirtualPe(vm, selectedHostPe);
        }
        return allocatedMipsForVmPe;
    }

    private double allocatedAvailableMipsFromHostPeToVirtualPe(Vm vm, Pe hostPe) {
        double availableMips = this.getAvailableMipsFromHostPe(hostPe);
        if (availableMips <= 0.0) {
            return 0.0;
        }
        this.allocateMipsFromHostPeForVm(vm, hostPe, availableMips);
        return availableMips;
    }

    private boolean allocateAllVmPeRequestedMipsFromHostPe(Vm vm, Pe hostPe, double requestedMipsForVmPe) {
        if ((double)this.getAvailableMipsFromHostPe(hostPe) >= requestedMipsForVmPe) {
            this.allocateMipsFromHostPeForVm(vm, hostPe, requestedMipsForVmPe);
            return true;
        }
        return false;
    }

    private long getAvailableMipsFromHostPe(Pe hostPe) {
        return hostPe.getPeProvisioner().getAvailableResource();
    }

    @Override
    protected boolean isSuitableForVmInternal(Vm vm, List<Double> requestedMips) {
        double pmMips = this.getPeCapacity();
        double totalRequestedMips = 0.0;
        for (double vmMips : requestedMips) {
            if (vmMips > pmMips) {
                return false;
            }
            totalRequestedMips += vmMips;
        }
        int workingPes = this.getWorkingPeList().size();
        return this.getAvailableMips() >= totalRequestedMips && workingPes >= requestedMips.size();
    }

    private void allocateMipsFromHostPeForVm(Vm vm, Pe pe, double mipsToAllocate) {
        pe.getPeProvisioner().allocateResourceForVm(vm, (long)mipsToAllocate);
    }

    protected List<Double> getMipsShareToAllocate(Vm vm, List<Double> requestedMips) {
        return this.getMipsShareToAllocate(requestedMips, this.percentOfMipsToRequest(vm));
    }

    protected List<Double> getMipsShareToAllocate(List<Double> requestedMips, double scalingFactor) {
        return requestedMips.stream().map(mips -> mips * scalingFactor).collect(Collectors.toList());
    }

    @Override
    protected void deallocatePesFromVmInternal(Vm vm, int pesToRemove) {
        this.removePesFromMap(vm, this.getRequestedMipsMap(), pesToRemove);
        this.removePesFromMap(vm, this.getAllocatedMipsMap(), pesToRemove);
        for (Map.Entry<Vm, List<Double>> entry : this.getRequestedMipsMap().entrySet()) {
            this.allocateMipsShareForVmInternal(entry.getKey(), entry.getValue());
        }
        this.updatePesAllocationForAllVms();
    }

    @Override
    public void deallocatePesForAllVms() {
        super.deallocatePesForAllVms();
        this.getRequestedMipsMap().clear();
    }
}

