/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

public final class Conversion {
    public static final double HUNDRED_PERCENT = 1.0;
    public static final int MILLION = 1000000;
    public static final double KILO = 1024.0;
    public static final double MEGA = 1048576.0;
    public static final double GIGA = 1.073741824E9;
    public static final double TERA = 1.099511627776E12;

    private Conversion() {
    }

    public static double bytesToMegaBytes(double bytes) {
        return bytes / 1048576.0;
    }

    public static double bytesToGigaBytes(double bytes) {
        return bytes / 1.073741824E9;
    }

    public static double bytesToKiloBytes(double bytes) {
        return bytes / 1024.0;
    }

    public static String bytesToSuitableUnit(double bytes) {
        if (bytes < 1024.0) {
            return String.format("%.0f bytes", bytes);
        }
        if (bytes < 1048576.0) {
            return String.format("%.1f KB", Conversion.bytesToKiloBytes(bytes));
        }
        if (bytes < 1.073741824E9) {
            return String.format("%.1f MB", Conversion.bytesToMegaBytes(bytes));
        }
        return String.format("%.1f GB", Conversion.bytesToGigaBytes(bytes));
    }

    public static double bytesToMegaBits(double bytes) {
        return Conversion.bytesToBits(Conversion.bytesToMegaBytes(bytes));
    }

    public static double bytesToBits(double bytes) {
        return bytes * 8.0;
    }

    public static double bitesToBytes(double bits) {
        return bits / 8.0;
    }

    public static double megaBytesToBytes(double megaBytes) {
        return megaBytes * 1048576.0;
    }

    public static double gigaToMega(double giga) {
        return giga * 1024.0;
    }

    public static double teraToGiga(double tera) {
        return tera * 1024.0;
    }

    public static double teraToMega(double tera) {
        return Conversion.teraToGiga(tera) * 1024.0;
    }

    public static double microToMilli(double micro) {
        return micro / 1000.0;
    }

    public static double microToSeconds(double micro) {
        return Conversion.microToMilli(micro) / 1000.0;
    }

    public static double minutesToSeconds(double minutes) {
        return minutes * 60.0;
    }

    public static double millisecsToMinutes(long milli) {
        return (double)milli / 60000.0;
    }

    public static double secondsToMinutes(double seconds) {
        return seconds / 60.0;
    }

    public static double secondsToHours(double seconds) {
        return Conversion.secondsToMinutes(seconds) / 60.0;
    }

    public static double secondsToDays(double seconds) {
        return Conversion.hoursToDays(Conversion.secondsToHours(seconds));
    }

    public static double hoursToDays(double hours) {
        return hours / 24.0;
    }

    public static double hoursToSeconds(double hours) {
        return Conversion.minutesToSeconds(hours * 60.0);
    }

    public static double daysToSeconds(double days) {
        return Conversion.hoursToSeconds(days * 24.0);
    }

    public static double monthsToSeconds(double months) {
        return Conversion.daysToSeconds(months * 30.0);
    }

    public static int boolToInt(boolean bool) {
        return bool ? 1 : 0;
    }
}

