/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ResourceLoader {
    private ResourceLoader() {
    }

    public static FileReader getFileReader(String filePath) {
        try {
            return new FileReader(filePath);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getResourcePath(Class klass, String name) {
        URL resource = ResourceLoader.getResourceUrl(klass, name);
        return resource == null || resource.getPath() == null ? "" : resource.getFile();
    }

    public static URL getResourceUrl(Class klass, String name) {
        return klass.getClassLoader().getResource(name);
    }

    public static List<String> getResourceList(Class klass, String resourceDir) {
        URI uri;
        try {
            uri = ResourceLoader.getResourceUrl(klass, resourceDir).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            Path fullPath = ResourceLoader.uriToPath(resourceDir, uri);
            List<String> list = Files.walk(fullPath, 1, new FileVisitOption[0]).map(path -> resourceDir + "/" + path.getFileName().toString()).collect(Collectors.toList());
            if (!list.isEmpty()) {
                list.remove(0);
            }
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Path uriToPath(String resourceDir, URI uri) throws IOException {
        if (uri.getScheme().equals("jar")) {
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            return fileSystem.getPath(resourceDir, new String[0]);
        }
        return Paths.get(uri);
    }

    public static BufferedReader getBufferedReader(Class klass, String resourceName) {
        return new BufferedReader(new InputStreamReader(ResourceLoader.getInputStream(resourceName, klass)));
    }

    public static InputStream getInputStream(String resourceName, Class klass) {
        InputStream input = klass.getClassLoader().getResourceAsStream("/" + resourceName);
        if (input != null) {
            return input;
        }
        input = klass.getResourceAsStream("/" + resourceName);
        if (input != null) {
            return input;
        }
        try {
            return new FileInputStream(resourceName);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }
}

