/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.utilizationmodels;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelPlanetLab
extends UtilizationModelAbstract {
    private static final int DATA_SAMPLES = 288;
    private double schedulingInterval;
    private final double[] utilization;

    public static UtilizationModelPlanetLab getInstance(String traceFilePath, double schedulingInterval) {
        InputStreamReader reader = new InputStreamReader(ResourceLoader.getInputStream(traceFilePath, UtilizationModelPlanetLab.class));
        return new UtilizationModelPlanetLab(reader, schedulingInterval, 288);
    }

    public UtilizationModelPlanetLab(String workloadFilePath, double schedulingInterval) throws NumberFormatException {
        this(workloadFilePath, schedulingInterval, 288);
    }

    public UtilizationModelPlanetLab(String workloadFilePath, double schedulingInterval, int dataSamples) throws NumberFormatException {
        this(ResourceLoader.getFileReader(workloadFilePath), schedulingInterval, dataSamples);
    }

    private UtilizationModelPlanetLab(InputStreamReader reader, double schedulingInterval, int dataSamples) throws NumberFormatException {
        this.setSchedulingInterval(schedulingInterval);
        try {
            this.utilization = this.readWorkloadFile(reader, dataSamples);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private double[] readWorkloadFile(InputStreamReader reader, int dataSamples) throws IOException {
        Objects.requireNonNull(reader);
        double[] utilization = this.createEmptyArray(Math.max(2, dataSamples));
        try (BufferedReader input = new BufferedReader(reader);){
            String line;
            int lineNum = 0;
            while ((line = input.readLine()) != null && !line.startsWith("#") && lineNum < utilization.length) {
                utilization[lineNum++] = Double.parseDouble(line) / 100.0;
            }
        }
        return utilization;
    }

    private double[] createEmptyArray(int size) {
        double[] data = new double[size];
        for (int i = 0; i < size; ++i) {
            data[i] = 0.0;
        }
        return data;
    }

    @Override
    public double getUtilization(double time) {
        if (time % this.getSchedulingInterval() == 0.0) {
            return this.utilization[(int)this.getUtilizationIndex(time)];
        }
        int prevIndex = this.getPrevUtilizationIndex(time);
        double elapsedTimeSincePrevUsage = (double)prevIndex * this.getSchedulingInterval();
        double totalElapsedTime = time - elapsedTimeSincePrevUsage;
        return this.utilization[prevIndex] + this.getUtilizationPerSec(time) * totalElapsedTime;
    }

    private double getUtilizationPerSec(double time) {
        int prevIndex = this.getPrevUtilizationIndex(time);
        int nextIndex = this.getNextUtilizationIndex(time);
        return (this.utilization[nextIndex] - this.utilization[prevIndex]) / this.getSecondsInsideInterval(prevIndex, nextIndex);
    }

    protected final double getSecondsInsideInterval(int prevIndex, int nextIndex) {
        return (double)this.getIntervalSize(prevIndex, nextIndex) * this.schedulingInterval;
    }

    private double getUtilizationIndex(double time) {
        return time / this.schedulingInterval % (double)this.utilization.length;
    }

    private int getPrevUtilizationIndex(double time) {
        return (int)Math.floor(this.getUtilizationIndex(time));
    }

    private int getNextUtilizationIndex(double time) {
        return (int)Math.ceil(this.getUtilizationIndex(time)) % this.utilization.length;
    }

    protected final int getIntervalSize(int startIndex, int endIndex) {
        int index = endIndex - startIndex;
        return index >= 0 ? index : this.utilization.length - startIndex + endIndex;
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    public final void setSchedulingInterval(double schedulingInterval) {
        if (schedulingInterval <= 0.0) {
            throw new IllegalArgumentException("Scheduling interval must greater than 0. The given value is " + schedulingInterval);
        }
        this.schedulingInterval = schedulingInterval;
    }
}

