/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.vms;

import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.vms.UtilizationHistory;
import org.cloudbus.cloudsim.vms.Vm;

public class VmUtilizationHistory
implements UtilizationHistory {
    private boolean enabled;
    private int maxHistoryEntries;
    private final SortedMap<Double, Double> history = new TreeMap<Double, Double>();
    private final Vm vm;
    private double previousTime;

    public VmUtilizationHistory(Vm vm, boolean enabled) {
        this.vm = vm;
        this.enabled = enabled;
        this.setMaxHistoryEntries(Integer.MAX_VALUE);
    }

    public VmUtilizationHistory(Vm vm) {
        this(vm, true);
    }

    @Override
    public double getUtilizationMad() {
        if (this.history.isEmpty()) {
            return 0.0;
        }
        int maxEntries = this.getNumEntriesToComputeStats();
        double median = MathUtil.median(this.getHistory().values());
        double[] deviationSum = new double[maxEntries];
        for (int i = 0; i < maxEntries; ++i) {
            deviationSum[i] = Math.abs(median - (Double)this.getHistory().get(i));
        }
        return MathUtil.median(deviationSum);
    }

    private int getNumEntriesToComputeStats() {
        return Math.min(this.getMaxHistoryEntries(), this.getHistory().size());
    }

    @Override
    public double getUtilizationMean() {
        int maxEntries = this.getNumEntriesToComputeStats();
        double usagePercentMean = this.getHistoryLimitedStream(maxEntries).mapToDouble(usagePercent -> usagePercent).average().orElse(0.0);
        return usagePercentMean * this.vm.getMips();
    }

    private Stream<Double> getHistoryLimitedStream(int maxEntries) {
        return this.getHistory().values().stream().limit(maxEntries);
    }

    @Override
    public double getUtilizationVariance() {
        if (this.history.isEmpty()) {
            return 0.0;
        }
        double mean = this.getUtilizationMean();
        int maxEntries = this.getNumEntriesToComputeStats();
        return this.getHistoryLimitedStream(maxEntries).mapToDouble(usagePercent -> usagePercent * this.vm.getMips()).map(usageValue -> usageValue - mean).map(usageValue -> usageValue * usageValue).average().orElse(0.0);
    }

    @Override
    public void addUtilizationHistory(double time) {
        if (!this.enabled || this.isNotTimeToAddHistory(time)) {
            return;
        }
        double utilization = this.vm.getCpuPercentUsage(this.vm.getCloudletScheduler().getPreviousTime());
        time = this.vm.isIdle() ? time : (double)((int)time);
        this.addUtilizationHistoryValue(time, utilization);
        this.previousTime = time;
    }

    private boolean isNotTimeToAddHistory(double time) {
        return time <= 0.0 || this.isElapsedTimeSmall(time) || this.isNotEntireSecondElapsed(time);
    }

    private boolean isElapsedTimeSmall(double time) {
        return time - this.previousTime < 1.0 && !this.vm.isIdle();
    }

    private boolean isNotEntireSecondElapsed(double time) {
        return Math.floor(time) == this.previousTime && !this.vm.isIdle();
    }

    private void addUtilizationHistoryValue(double time, double utilizationPercent) {
        this.history.put(time, utilizationPercent);
        if (this.getHistory().size() > this.maxHistoryEntries) {
            this.history.remove(this.maxHistoryEntries);
        }
    }

    @Override
    public SortedMap<Double, Double> getHistory() {
        return Collections.unmodifiableSortedMap(this.history);
    }

    @Override
    public double powerConsumption(double time) {
        double hostTotalCpuUsage = ((DoubleSummaryStatistics)this.vm.getHost().getUtilizationHistory().get(time)).getSum();
        double vmCpuUsageFromHostUsage = hostTotalCpuUsage == 0.0 ? 0.0 : this.cpuUsageFromHostCapacity(time) / hostTotalCpuUsage;
        double hostTotalPower = this.vm.getHost().getPowerModel().getPower(hostTotalCpuUsage);
        return vmCpuUsageFromHostUsage * hostTotalPower;
    }

    @Override
    public double cpuUsageFromHostCapacity(double time) {
        double vmUsagePercent = (Double)this.history.get(time);
        return vmUsagePercent * this.vm.getRelativeMipsCapacityPercent();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public int getMaxHistoryEntries() {
        return this.maxHistoryEntries;
    }

    @Override
    public void setMaxHistoryEntries(int maxHistoryEntries) {
        this.maxHistoryEntries = maxHistoryEntries;
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }
}

