/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.builders.BrokerBuilder;
import org.cloudsimplus.builders.DatacenterBuilder;

public class SimulationScenarioBuilder {
    private final DatacenterBuilder datacenterBuilder;
    private final BrokerBuilder brokerBuilder;
    private final CloudSim simulation;

    public SimulationScenarioBuilder(CloudSim simulation) {
        this.simulation = simulation;
        this.datacenterBuilder = new DatacenterBuilder(this);
        this.brokerBuilder = new BrokerBuilder(this);
    }

    public DatacenterBuilder getDatacenterBuilder() {
        return this.datacenterBuilder;
    }

    public BrokerBuilder getBrokerBuilder() {
        return this.brokerBuilder;
    }

    public Host getHostOfDatacenter(int hostIndex, int datacenterIndex) {
        return this.datacenterBuilder.getHostOfDatacenter(hostIndex, datacenterIndex);
    }

    public Host getFirstHostFromFirstDatacenter() {
        return this.datacenterBuilder.getHostOfDatacenter(0, 0);
    }

    public Vm getFirstVmFromFirstBroker() {
        return this.getVmFromBroker(0, 0);
    }

    public Vm getVmFromBroker(int vmIndex, int brokerIndex) {
        return this.brokerBuilder.get(brokerIndex).getWaitingVm(vmIndex);
    }

    public CloudSim getSimulation() {
        return this.simulation;
    }
}

