/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableColumn;

public abstract class AbstractTable
implements Table {
    private PrintStream printStream = System.out;
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    private String title;
    private final List<List<Object>> rows = new ArrayList<List<Object>>();
    private String columnSeparator;

    public AbstractTable() {
        this("");
    }

    public AbstractTable(String title) {
        this.setTitle(title);
    }

    @Override
    public List<TableColumn> getColumns() {
        return this.columns;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public final Table setTitle(String title) {
        this.title = Objects.requireNonNull(title);
        return this;
    }

    @Override
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    @Override
    public final Table setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
        return this;
    }

    protected List<List<Object>> getRows() {
        return this.rows;
    }

    @Override
    public List<Object> newRow() {
        ArrayList<Object> row = new ArrayList<Object>();
        this.rows.add(row);
        return row;
    }

    private boolean isThereAnySubtitledColumn() {
        return this.columns.stream().anyMatch(col -> StringUtils.isNotBlank((CharSequence)col.getSubTitle()));
    }

    private void printRow(List<Object> row) {
        this.printRowOpening();
        List cols = this.columns.stream().limit(Math.min(this.columns.size(), row.size())).collect(Collectors.toList());
        int idxCol = 0;
        for (TableColumn col : cols) {
            this.getPrintStream().print(col.generateData(row.get(idxCol++)));
        }
        this.printRowClosing();
    }

    @Override
    public void print() {
        this.printTableOpening();
        this.printTitle();
        this.printColumnHeaders();
        this.rows.forEach(this::printRow);
        this.printTableClosing();
    }

    protected void printColumnHeaders() {
        this.printRowOpening();
        this.columns.forEach(col -> this.getPrintStream().print(col.generateTitleHeader()));
        this.printRowClosing();
        if (this.isThereAnySubtitledColumn()) {
            this.printRowOpening();
            this.columns.forEach(col -> System.out.print(col.generateSubtitleHeader()));
            this.printRowClosing();
        }
    }

    protected abstract void printTableOpening();

    protected abstract void printTitle();

    protected abstract void printRowOpening();

    protected abstract void printRowClosing();

    protected abstract void printTableClosing();

    @Override
    public final Table addColumnList(String ... columnTitles) {
        for (String column : columnTitles) {
            this.addColumn(column);
        }
        return this;
    }

    @Override
    public final TableColumn addColumn(String columnTitle) {
        return this.addColumn(this.getColumns().size(), columnTitle);
    }

    @Override
    public final TableColumn addColumn(String columnTitle, String columnSubTitle) {
        return this.addColumn(columnTitle).setSubTitle(columnSubTitle);
    }

    @Override
    public final TableColumn addColumn(int index, TableColumn column) {
        this.columns.add(index, column);
        return column;
    }

    @Override
    public final TableColumn addColumn(TableColumn column) {
        return this.addColumn(this.columns.size(), column);
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    protected PrintStream getPrintStream() {
        return this.printStream;
    }
}

