/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudbus.cloudsim.hosts.Host;
import org.cloudsimplus.traces.google.GoogleMachineEventsTraceReader;

public enum MachineEventType {
    ADD{

        @Override
        protected boolean process(GoogleMachineEventsTraceReader reader) {
            Host host = reader.createHostFromTraceLine();
            host.setStartTime((Double)GoogleMachineEventsTraceReader.FieldIndex.TIMESTAMP.getValue(reader));
            return host.getStartTime() == 0.0 ? reader.addAvailableObject(host) : reader.addLaterAvailableHost(host);
        }
    }
    ,
    REMOVE{

        @Override
        protected boolean process(GoogleMachineEventsTraceReader reader) {
            Host host = reader.createHostFromTraceLine();
            host.setShutdownTime((Double)GoogleMachineEventsTraceReader.FieldIndex.TIMESTAMP.getValue(reader));
            return reader.addHostToRemovalList(host);
        }
    }
    ,
    UPDATE{

        @Override
        protected boolean process(GoogleMachineEventsTraceReader reader) {
            return false;
        }
    };


    public static MachineEventType getValue(int ordinal) {
        return MachineEventType.values()[ordinal];
    }

    protected abstract boolean process(GoogleMachineEventsTraceReader var1);
}

