/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.util.Optional;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.TaskEvent;

public enum TaskEventType {
    SUBMIT{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            TaskEvent event = reader.createTaskEventFromTraceLine();
            Cloudlet cloudlet = reader.createCloudlet(event);
            cloudlet.setId(event.getUniqueTaskId());
            cloudlet.setJobId(event.getJobId());
            double delay = (Double)GoogleTaskEventsTraceReader.FieldIndex.TIMESTAMP.getValue(reader);
            cloudlet.setSubmissionDelay(delay);
            cloudlet.setId(event.getUniqueTaskId());
            cloudlet.setStatus(Cloudlet.Status.FROZEN);
            DatacenterBroker broker = reader.createBrokerIfAbsent(event.getUserName());
            broker.submitCloudlet(cloudlet);
            return reader.addAvailableObject(cloudlet);
        }
    }
    ,
    SCHEDULE{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(this::cloudletLookup, 23);
        }
    }
    ,
    EVICT{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(this::cloudletLookup, 19);
        }
    }
    ,
    FAIL{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(this::cloudletLookup, 24);
        }
    }
    ,
    FINISH{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(this::cloudletLookup, -25);
        }
    }
    ,
    KILL{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(this::cloudletLookup, 18);
        }
    }
    ,
    LOST{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    }
    ,
    UPDATE_PENDING{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    }
    ,
    UPDATE_RUNNING{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    };


    protected Optional<Cloudlet> cloudletLookup(DatacenterBroker broker, long uniqueId) {
        return broker.getCloudletSubmittedList().stream().filter(cloudlet -> cloudlet.getId() == uniqueId).findFirst();
    }

    public static TaskEventType getValue(int ordinal) {
        return TaskEventType.values()[ordinal];
    }

    protected abstract boolean process(GoogleTaskEventsTraceReader var1);
}

