/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import java.util.Comparator;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.vms.Vm;

public class DatacenterBrokerBestFit
extends DatacenterBrokerSimple {
    public DatacenterBrokerBestFit(CloudSim simulation) {
        super(simulation);
    }

    @Override
    public Vm defaultVmMapper(Cloudlet cloudlet) {
        if (cloudlet.isBoundToCreatedVm()) {
            return cloudlet.getVm();
        }
        Vm mappedVm = this.getVmCreatedList().stream().filter(vm -> vm.getExpectedFreePesNumber() >= cloudlet.getNumberOfPes()).min(Comparator.comparingLong(vm -> vm.getExpectedFreePesNumber())).orElse(Vm.NULL);
        if (mappedVm != Vm.NULL) {
            LOGGER.debug("{}: {}: {} (PEs: {}) mapped to {} (available PEs: {}, tot PEs: {})", new Object[]{this.getSimulation().clock(), this.getName(), cloudlet, cloudlet.getNumberOfPes(), mappedVm, mappedVm.getExpectedFreePesNumber(), mappedVm.getFreePesNumber()});
        } else {
            LOGGER.warn(": {}: {}: {} (PEs: {}) couldn't be mapped to any VM", new Object[]{this.getSimulation().clock(), this.getName(), cloudlet, cloudlet.getNumberOfPes()});
        }
        return mappedVm;
    }
}

