/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.vms.UtilizationHistory;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSelectionPolicyMaximumCorrelation
implements VmSelectionPolicy {
    private VmSelectionPolicy fallbackPolicy;

    public VmSelectionPolicyMaximumCorrelation(VmSelectionPolicy fallbackPolicy) {
        this.setFallbackPolicy(fallbackPolicy);
    }

    @Override
    public Vm getVmToMigrate(Host host) {
        List<Vm> migratableVms = host.getMigratableVms();
        if (migratableVms.isEmpty()) {
            return Vm.NULL;
        }
        try {
            List<Double> metrics = MathUtil.correlationCoefficients(this.getUtilizationMatrix(migratableVms));
            double maxMetric = Double.MIN_VALUE;
            int maxIndex = 0;
            for (int i = 0; i < metrics.size(); ++i) {
                double metric = metrics.get(i);
                if (!(metric > maxMetric)) continue;
                maxMetric = metric;
                maxIndex = i;
            }
            return migratableVms.get(maxIndex);
        }
        catch (IllegalArgumentException e) {
            return this.getFallbackPolicy().getVmToMigrate(host);
        }
    }

    private double[][] getUtilizationMatrix(List<Vm> vmList) {
        int numberVms = vmList.size();
        int minHistorySize = this.getMinUtilizationHistorySize(vmList);
        double[][] utilization = new double[numberVms][minHistorySize];
        for (int i = 0; i < numberVms; ++i) {
            double[] vmUtilization = vmList.get(i).getUtilizationHistory().getHistory().values().stream().mapToDouble(v -> v).toArray();
            if (minHistorySize < 0) continue;
            System.arraycopy(vmUtilization, 0, utilization[i], 0, minHistorySize);
        }
        return utilization;
    }

    private int getMinUtilizationHistorySize(List<Vm> vmList) {
        return vmList.stream().map(Vm::getUtilizationHistory).map(UtilizationHistory::getHistory).mapToInt(Map::size).min().orElse(0);
    }

    public VmSelectionPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public final void setFallbackPolicy(VmSelectionPolicy fallbackPolicy) {
        this.fallbackPolicy = Objects.requireNonNull(fallbackPolicy);
    }
}

