/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.utilizationmodels;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelStochastic
extends UtilizationModelAbstract {
    private ContinuousDistribution randomGenerator;
    private Map<Double, Double> historyMap = new HashMap<Double, Double>();
    private double previousTime = -1.0;
    private double maxPreviousTime = -1.0;
    private double previousUtilization = -1.0;
    private boolean historyEnabled;
    private boolean alwaysGenerateNewRandomUtilization;

    public UtilizationModelStochastic() {
        this(UtilizationModel.Unit.PERCENTAGE);
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit) {
        this(unit, -1L);
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit, long seed) {
        this(unit, new UniformDistr(seed));
    }

    public UtilizationModelStochastic(ContinuousDistribution prng) {
        this(UtilizationModel.Unit.PERCENTAGE, prng);
    }

    public UtilizationModelStochastic(UtilizationModel.Unit unit, ContinuousDistribution prng) {
        super(unit);
        this.setRandomGenerator(prng);
    }

    @Override
    public double getUtilization(double time) {
        if (time < 0.0) {
            throw new IllegalArgumentException("Time cannot be negative.");
        }
        if (time == this.previousTime && !this.alwaysGenerateNewRandomUtilization) {
            return this.previousUtilization;
        }
        double utilization = this.getOrGenerateUtilization(time);
        this.maxPreviousTime = Math.max(this.maxPreviousTime, time);
        this.previousTime = time;
        this.previousUtilization = utilization;
        return utilization;
    }

    private Double getOrGenerateUtilization(double time) {
        Double utilization;
        if (time > this.maxPreviousTime || this.alwaysGenerateNewRandomUtilization) {
            return this.generateUtilization(time);
        }
        Double d = utilization = this.historyEnabled ? this.historyMap.get(time) : null;
        if (utilization == null) {
            return this.generateUtilization(time);
        }
        return utilization;
    }

    private double generateUtilization(double time) {
        double utilization = Math.abs(this.randomGenerator.sample());
        if (this.historyEnabled) {
            this.historyMap.put(time, utilization);
        }
        return utilization;
    }

    protected Double getUtilizationHistory(double time) {
        return this.historyMap.get(time);
    }

    public void saveHistory(String filename) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));){
            oos.writeObject(this.historyMap);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void loadHistory(String filename) {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));){
            this.historyMap = (Map)ois.readObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ContinuousDistribution getRandomGenerator() {
        return this.randomGenerator;
    }

    public final void setRandomGenerator(ContinuousDistribution randomGenerator) {
        this.randomGenerator = Objects.requireNonNull(randomGenerator);
    }

    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    public UtilizationModelStochastic setHistoryEnabled(boolean enableHistory) {
        this.historyEnabled = enableHistory;
        return this;
    }

    public UtilizationModelStochastic enableHistory() {
        this.historyEnabled = true;
        return this;
    }

    public UtilizationModelStochastic disableHistory() {
        this.historyEnabled = false;
        return this;
    }

    public boolean isAlwaysGenerateNewRandomUtilization() {
        return this.alwaysGenerateNewRandomUtilization;
    }

    public UtilizationModelStochastic setAlwaysGenerateNewRandomUtilization(boolean alwaysGenerateNewRandomUtilization) {
        this.alwaysGenerateNewRandomUtilization = alwaysGenerateNewRandomUtilization;
        return this;
    }
}

