/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.HorizontalVmScaling;
import org.cloudsimplus.autoscaling.VmScaling;
import org.cloudsimplus.autoscaling.VmScalingAbstract;
import org.cloudsimplus.listeners.VmHostEventInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalVmScalingSimple
extends VmScalingAbstract
implements HorizontalVmScaling {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HorizontalVmScalingSimple.class.getSimpleName());
    private Supplier<Vm> vmSupplier;
    private long cloudletCreationRequests;
    private Predicate<Vm> overloadPredicate = FALSE_PREDICATE;

    public HorizontalVmScalingSimple() {
        this.vmSupplier = () -> Vm.NULL;
    }

    @Override
    public Supplier<Vm> getVmSupplier() {
        return this.vmSupplier;
    }

    @Override
    public final HorizontalVmScaling setVmSupplier(Supplier<Vm> supplier) {
        this.vmSupplier = Objects.requireNonNull(supplier);
        return this;
    }

    @Override
    public Predicate<Vm> getOverloadPredicate() {
        return this.overloadPredicate;
    }

    @Override
    public VmScaling setOverloadPredicate(Predicate<Vm> predicate) {
        this.overloadPredicate = Objects.requireNonNull(predicate);
        return this;
    }

    @Override
    protected boolean requestUpScaling(double time) {
        if (!this.haveNewCloudletsArrived()) {
            return false;
        }
        double vmCpuUsagePercent = this.getVm().getCpuPercentUsage() * 100.0;
        Vm newVm = this.getVmSupplier().get();
        LOGGER.info("{}: {}{}: Requesting creation of {} to receive new Cloudlets in order to balance load of {}. {} CPU usage is {}%", new Object[]{time, this.getClass().getSimpleName(), this.getVm(), newVm, this.getVm(), this.getVm().getId(), vmCpuUsagePercent});
        this.getVm().getBroker().submitVm(newVm);
        this.cloudletCreationRequests = this.getVm().getBroker().getCloudletCreatedList().size();
        return true;
    }

    private boolean haveNewCloudletsArrived() {
        return (long)this.getVm().getBroker().getCloudletCreatedList().size() > this.cloudletCreationRequests;
    }

    @Override
    public final boolean requestUpScalingIfPredicateMatches(VmHostEventInfo evt) {
        if (!this.isTimeToCheckPredicate(evt.getTime())) {
            return false;
        }
        this.setLastProcessingTime(evt.getTime());
        return this.overloadPredicate.test(this.getVm()) && this.requestUpScaling(evt.getTime());
    }
}

