/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmSimple;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;
import org.cloudsimplus.listeners.VmHostEventInfo;

public class VmBuilder
implements Builder {
    private BiFunction<Double, Long, Vm> vmCreationFunction;
    private double mips = 1000.0;
    private long pes = 1L;
    private int numberOfCreatedVms;
    private final DatacenterBrokerSimple broker;
    private Supplier<CloudletScheduler> cloudletSchedulerSupplier;
    private EventListener<VmHostEventInfo> onHostAllocationListener = EventListener.NULL;
    private EventListener<VmHostEventInfo> onHostDeallocationListener = EventListener.NULL;
    private EventListener<VmDatacenterEventInfo> onVmCreationFailureListener = EventListener.NULL;
    private EventListener<VmHostEventInfo> onUpdateVmProcessingListener = EventListener.NULL;

    public VmBuilder(DatacenterBrokerSimple broker) {
        this.broker = Objects.requireNonNull(broker);
        this.numberOfCreatedVms = 0;
        this.vmCreationFunction = this::defaultVmCreationFunction;
    }

    public VmBuilder createAndSubmit() {
        return this.createAndSubmit(1);
    }

    public VmBuilder createAndSubmit(int amount) {
        ArrayList<Vm> vms = new ArrayList<Vm>(amount);
        for (int i = 0; i < amount; ++i) {
            Vm vm = this.vmCreationFunction.apply(this.mips, this.pes);
            if (this.cloudletSchedulerSupplier != null) {
                vm.setCloudletScheduler(this.cloudletSchedulerSupplier.get());
            }
            vm.addOnHostAllocationListener(this.onHostAllocationListener).addOnHostDeallocationListener(this.onHostDeallocationListener).addOnCreationFailureListener(this.onVmCreationFailureListener).addOnUpdateProcessingListener(this.onUpdateVmProcessingListener).setBroker(this.broker);
            vms.add(vm);
        }
        this.broker.submitVmList(vms);
        return this;
    }

    public List<Vm> getVms() {
        return this.broker.getVmWaitingList();
    }

    private Vm defaultVmCreationFunction(double mips, long pes) {
        VmSimple vm = new VmSimple((long)this.numberOfCreatedVms++, mips, pes);
        return vm;
    }

    public VmBuilder setMips(double defaultMIPS) {
        this.mips = defaultMIPS;
        return this;
    }

    public VmBuilder setPes(long defaultPEs) {
        this.pes = defaultPEs;
        return this;
    }

    public Vm getVmById(int id) {
        return this.broker.getVmWaitingList().stream().filter(vm -> vm.getId() == (long)id).findFirst().orElse(Vm.NULL);
    }

    public double getMips() {
        return this.mips;
    }

    public long getPes() {
        return this.pes;
    }

    public VmBuilder setVmCreationFunction(BiFunction<Double, Long, Vm> vmCreationFunction) {
        this.vmCreationFunction = Objects.requireNonNull(vmCreationFunction);
        return this;
    }

    public VmBuilder setCloudletSchedulerSupplier(Supplier<CloudletScheduler> cloudletSchedulerSupplier) {
        this.cloudletSchedulerSupplier = Objects.requireNonNull(cloudletSchedulerSupplier);
        return this;
    }

    public VmBuilder setOnHostAllocationListener(EventListener<VmHostEventInfo> listener) {
        this.onHostAllocationListener = Objects.requireNonNull(listener);
        return this;
    }

    public VmBuilder setOnHostDeallocationListener(EventListener<VmHostEventInfo> listener) {
        this.onHostDeallocationListener = Objects.requireNonNull(listener);
        return this;
    }

    public VmBuilder setOnVmCreationFailureListener(EventListener<VmDatacenterEventInfo> listener) {
        this.onVmCreationFailureListener = Objects.requireNonNull(listener);
        return this;
    }

    public VmBuilder setOnUpdateVmProcessingListener(EventListener<VmHostEventInfo> listener) {
        this.onUpdateVmProcessingListener = Objects.requireNonNull(listener);
        return this;
    }
}

