/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.vms.Vm;

public class VmAllocationPolicyRandom
extends VmAllocationPolicyAbstract
implements VmAllocationPolicy {
    private final ContinuousDistribution random;

    public VmAllocationPolicyRandom(ContinuousDistribution random) {
        this.random = Objects.requireNonNull(random);
    }

    @Override
    protected Optional<Host> defaultFindHostForVm(Vm vm) {
        List hostList = this.getHostList();
        int maxTries = hostList.size();
        for (int i = 0; i < maxTries; ++i) {
            int hostIndex = (int)(this.random.sample() * (double)hostList.size());
            Host host = (Host)hostList.get(hostIndex);
            if (!host.isSuitableForVm(vm)) continue;
            return Optional.of(host);
        }
        return Optional.empty();
    }
}

