/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletDatacenterExecution;
import org.cloudbus.cloudsim.core.CustomerEntityAbstract;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.resources.Bandwidth;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelFull;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmGroup;
import org.cloudsimplus.listeners.CloudletVmEventInfo;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public abstract class CloudletAbstract
extends CustomerEntityAbstract
implements Cloudlet {
    private long jobId;
    private final List<CloudletDatacenterExecution> datacenterExecutionList = new ArrayList<CloudletDatacenterExecution>(2);
    private long length;
    private long numberOfPes;
    private Cloudlet.Status status;
    private boolean returnedToBroker;
    private double execStartTime;
    private int priority;
    private int netServiceLevel;
    private Vm vm;
    private List<String> requiredFiles = new LinkedList<String>();
    private int lastExecutedDatacenterIdx;
    private long fileSize;
    private long outputSize;
    private double finishTime;
    private double costPerBw;
    private double accumulatedBwCost;
    private UtilizationModel utilizationModelCpu;
    private UtilizationModel utilizationModelRam;
    private UtilizationModel utilizationModelBw;
    private final Set<EventListener<CloudletVmEventInfo>> onStartListeners;
    private final Set<EventListener<CloudletVmEventInfo>> onFinishListeners;
    private final Set<EventListener<CloudletVmEventInfo>> onUpdateProcessingListeners;
    private double submissionDelay;

    public CloudletAbstract(long length, int pesNumber, UtilizationModel utilizationModel) {
        this(-1L, length, pesNumber);
        this.setUtilizationModel(utilizationModel);
    }

    public CloudletAbstract(long length, int pesNumber) {
        this(-1L, length, pesNumber);
    }

    public CloudletAbstract(long length, long pesNumber) {
        this(-1L, length, pesNumber);
    }

    public CloudletAbstract(long id, long length, long pesNumber) {
        this.setId(id);
        this.setJobId(-1L);
        this.setNumberOfPes(pesNumber);
        this.setLength(length);
        this.setFileSize(1L);
        this.setOutputSize(1L);
        this.setSubmissionDelay(0.0);
        this.setAccumulatedBwCost(0.0);
        this.setCostPerBw(0.0);
        this.reset();
        this.setUtilizationModelCpu(new UtilizationModelFull());
        this.setUtilizationModelRam(UtilizationModel.NULL);
        this.setUtilizationModelBw(UtilizationModel.NULL);
        this.onStartListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
        this.onFinishListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
        this.onUpdateProcessingListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
    }

    @Override
    public final Cloudlet reset() {
        this.netServiceLevel = 0;
        this.execStartTime = 0.0;
        this.status = Cloudlet.Status.INSTANTIATED;
        this.priority = 0;
        this.lastExecutedDatacenterIdx = -1;
        this.setBroker(DatacenterBroker.NULL);
        this.setFinishTime(-1.0);
        this.setVm(Vm.NULL);
        this.setExecStartTime(0.0);
        this.datacenterExecutionList.clear();
        this.setLastTriedDatacenter(Datacenter.NULL);
        return this;
    }

    protected int getLastExecutedDatacenterIdx() {
        return this.lastExecutedDatacenterIdx;
    }

    protected void setLastExecutedDatacenterIdx(int lastExecutedDatacenterIdx) {
        this.lastExecutedDatacenterIdx = lastExecutedDatacenterIdx;
    }

    @Override
    public Cloudlet setUtilizationModel(UtilizationModel utilizationModel) {
        this.setUtilizationModelBw(utilizationModel);
        this.setUtilizationModelRam(utilizationModel);
        this.setUtilizationModelCpu(utilizationModel);
        return this;
    }

    @Override
    public Cloudlet addOnUpdateProcessingListener(EventListener<CloudletVmEventInfo> listener) {
        this.onUpdateProcessingListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnUpdateProcessingListener(EventListener<CloudletVmEventInfo> listener) {
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public Cloudlet addOnStartListener(EventListener<CloudletVmEventInfo> listener) {
        this.onStartListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnStartListener(EventListener<CloudletVmEventInfo> listener) {
        return this.onStartListeners.remove(listener);
    }

    @Override
    public Cloudlet addOnFinishListener(EventListener<CloudletVmEventInfo> listener) {
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onFinishListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnFinishListener(EventListener<CloudletVmEventInfo> listener) {
        return this.onFinishListeners.remove(listener);
    }

    @Override
    public void notifyOnUpdateProcessingListeners(double time) {
        this.onUpdateProcessingListeners.forEach(listener -> listener.update(CloudletVmEventInfo.of((EventListener<? extends EventInfo>)listener, time, this)));
    }

    @Override
    public final Cloudlet setLength(long length) {
        if (length == 0L) {
            throw new IllegalArgumentException("Cloudlet length cannot be zero.");
        }
        this.length = length;
        return this;
    }

    @Override
    public boolean setNetServiceLevel(int netServiceLevel) {
        if (netServiceLevel > 0) {
            this.netServiceLevel = netServiceLevel;
            return true;
        }
        return false;
    }

    @Override
    public int getNetServiceLevel() {
        return this.netServiceLevel;
    }

    @Override
    public double getWaitingTime() {
        if (this.datacenterExecutionList.isEmpty()) {
            return 0.0;
        }
        double subTime = this.getLastExecutionInDatacenterInfo().getArrivalTime();
        return this.execStartTime - subTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Cloudlet setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public final Cloudlet setNumberOfPes(long numberOfPes) {
        if (numberOfPes <= 0L) {
            throw new IllegalArgumentException("Cloudlet number of PEs has to be greater than zero.");
        }
        this.numberOfPes = numberOfPes;
        return this;
    }

    @Override
    public long getNumberOfPes() {
        return this.numberOfPes;
    }

    @Override
    public long getFinishedLengthSoFar(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getFinishedSoFar();
    }

    @Override
    public long getFinishedLengthSoFar() {
        if (this.datacenterExecutionList.isEmpty()) {
            return 0L;
        }
        if (this.getLength() > 0L) {
            return Math.min(this.getLastExecutionInDatacenterInfo().getFinishedSoFar(), this.absLength());
        }
        return this.getLastExecutionInDatacenterInfo().getFinishedSoFar();
    }

    @Override
    public boolean isFinished() {
        if (this.datacenterExecutionList.isEmpty()) {
            return false;
        }
        return this.getLength() > 0L && this.getLastExecutionInDatacenterInfo().getFinishedSoFar() >= this.getLength();
    }

    @Override
    public boolean addFinishedLengthSoFar(long partialFinishedMI) {
        if ((double)partialFinishedMI < 0.0 || this.datacenterExecutionList.isEmpty()) {
            return false;
        }
        long maxLengthToAdd = this.getLength() < 0L ? partialFinishedMI : Math.min(partialFinishedMI, this.absLength() - this.getFinishedLengthSoFar());
        this.getLastExecutionInDatacenterInfo().addFinishedSoFar(maxLengthToAdd);
        this.returnToBrokerIfFinished();
        this.notifyListenersIfCloudletIsFinished();
        return true;
    }

    private void returnToBrokerIfFinished() {
        if (this.isFinished() && !this.isReturnedToBroker()) {
            this.returnedToBroker = true;
            this.getSimulation().sendNow(this.getSimulation().getCloudInfoService(), this.getBroker(), 15, this);
            this.vm.getCloudletScheduler().addCloudletToReturnedList(this);
        }
    }

    private void notifyListenersIfCloudletIsFinished() {
        if (this.isFinished()) {
            this.onFinishListeners.forEach(listener -> listener.update(CloudletVmEventInfo.of((EventListener<? extends EventInfo>)listener, this)));
            this.onFinishListeners.clear();
        }
    }

    private CloudletDatacenterExecution getLastExecutionInDatacenterInfo() {
        if (this.datacenterExecutionList.isEmpty()) {
            return CloudletDatacenterExecution.NULL;
        }
        return this.datacenterExecutionList.get(this.datacenterExecutionList.size() - 1);
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public long getOutputSize() {
        return this.outputSize;
    }

    @Override
    public double getExecStartTime() {
        return this.execStartTime;
    }

    @Override
    public void setExecStartTime(double clockTime) {
        boolean isStartingInSomeVm = this.execStartTime <= 0.0 && clockTime > 0.0 && this.vm != Vm.NULL && this.vm != null;
        this.execStartTime = clockTime;
        if (isStartingInSomeVm) {
            this.onStartListeners.forEach(listener -> listener.update(CloudletVmEventInfo.of((EventListener<? extends EventInfo>)listener, clockTime, this)));
        }
    }

    @Override
    public boolean setWallClockTime(double wallTime, double actualCpuTime) {
        if (wallTime < 0.0 || actualCpuTime < 0.0 || this.datacenterExecutionList.isEmpty()) {
            return false;
        }
        CloudletDatacenterExecution datacenter = this.getLastExecutionInDatacenterInfo();
        datacenter.setWallClockTime(wallTime);
        datacenter.setActualCpuTime(actualCpuTime);
        return true;
    }

    @Override
    public boolean setStatus(Cloudlet.Status newStatus) {
        if (this.status == newStatus) {
            return false;
        }
        if (newStatus == Cloudlet.Status.SUCCESS) {
            this.setFinishTime(this.getSimulation().clock());
        }
        this.status = newStatus;
        return true;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    protected long absLength() {
        return Math.abs(this.getLength());
    }

    @Override
    public long getTotalLength() {
        return this.length * this.numberOfPes;
    }

    @Override
    public double getCostPerSec() {
        return this.getLastExecutionInDatacenterInfo().getCostPerSec();
    }

    @Override
    public double getCostPerSec(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getCostPerSec();
    }

    protected double getActualCpuTime(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getActualCpuTime();
    }

    @Override
    public double getActualCpuTime() {
        if (this.getFinishTime() == -1.0) {
            return -1.0;
        }
        return this.finishTime - this.execStartTime;
    }

    @Override
    public double getArrivalTime(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getArrivalTime();
    }

    protected double getWallClockTime(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getWallClockTime();
    }

    private CloudletDatacenterExecution getDatacenterInfo(long datacenterId) {
        return this.datacenterExecutionList.stream().filter(info -> info.getDatacenter().getId() == datacenterId).findFirst().orElse(CloudletDatacenterExecution.NULL);
    }

    private CloudletDatacenterExecution getDatacenterInfo(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter.getId());
    }

    @Override
    public double getFinishTime() {
        return this.finishTime;
    }

    protected final void setFinishTime(double finishTime) {
        this.finishTime = finishTime;
    }

    @Override
    public Cloudlet.Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isReturnedToBroker() {
        return this.returnedToBroker;
    }

    @Override
    public long getJobId() {
        return this.jobId;
    }

    @Override
    public final void setJobId(long jobId) {
        this.jobId = jobId;
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public final Cloudlet setVm(Vm vm) {
        this.vm = vm;
        return this;
    }

    @Override
    public double getTotalCost() {
        double totalCost = this.getTotalCpuCostForAllDatacenters();
        totalCost += this.accumulatedBwCost;
        return totalCost += this.costPerBw * (double)this.outputSize;
    }

    private double getTotalCpuCostForAllDatacenters() {
        return this.datacenterExecutionList.stream().mapToDouble(dcInfo -> dcInfo.getActualCpuTime() * dcInfo.getCostPerSec()).sum();
    }

    @Override
    public List<String> getRequiredFiles() {
        return this.requiredFiles;
    }

    public final void setRequiredFiles(List<String> requiredFiles) {
        this.requiredFiles = Objects.requireNonNull(requiredFiles);
    }

    @Override
    public boolean addRequiredFile(String fileName) {
        if (this.getRequiredFiles().stream().anyMatch(reqFile -> reqFile.equals(fileName))) {
            return false;
        }
        this.requiredFiles.add(fileName);
        return true;
    }

    @Override
    public boolean addRequiredFiles(List<String> fileNames) {
        boolean atLeastOneFileAdded = false;
        for (String fileName : fileNames) {
            atLeastOneFileAdded |= this.addRequiredFile(fileName);
        }
        return atLeastOneFileAdded;
    }

    @Override
    public boolean deleteRequiredFile(String filename) {
        for (int i = 0; i < this.getRequiredFiles().size(); ++i) {
            String temp = this.requiredFiles.get(i);
            if (!temp.equals(filename)) continue;
            this.requiredFiles.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresFiles() {
        return !this.getRequiredFiles().isEmpty();
    }

    @Override
    public UtilizationModel getUtilizationModelCpu() {
        return this.utilizationModelCpu;
    }

    @Override
    public final Cloudlet setUtilizationModelCpu(UtilizationModel utilizationModelCpu) {
        this.utilizationModelCpu = Objects.requireNonNull(utilizationModelCpu);
        return this;
    }

    @Override
    public UtilizationModel getUtilizationModelRam() {
        return this.utilizationModelRam;
    }

    @Override
    public final Cloudlet setUtilizationModelRam(UtilizationModel utilizationModelRam) {
        this.utilizationModelRam = Objects.requireNonNull(utilizationModelRam);
        return this;
    }

    @Override
    public UtilizationModel getUtilizationModelBw() {
        return this.utilizationModelBw;
    }

    @Override
    public final Cloudlet setUtilizationModelBw(UtilizationModel utilizationModelBw) {
        this.utilizationModelBw = Objects.requireNonNull(utilizationModelBw);
        return this;
    }

    @Override
    public UtilizationModel getUtilizationModel(Class<? extends ResourceManageable> resourceClass) {
        if (resourceClass.isAssignableFrom(Ram.class)) {
            return this.utilizationModelRam;
        }
        if (resourceClass.isAssignableFrom(Bandwidth.class)) {
            return this.utilizationModelBw;
        }
        if (resourceClass.isAssignableFrom(Processor.class) || resourceClass.isAssignableFrom(Pe.class)) {
            return this.utilizationModelCpu;
        }
        throw new UnsupportedOperationException("This class doesn't support " + resourceClass.getSimpleName() + " resources");
    }

    @Override
    public double getUtilizationOfCpu() {
        return this.getUtilizationOfCpu(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfCpu(double time) {
        return this.getUtilizationModelCpu().getUtilization(time);
    }

    @Override
    public double getUtilizationOfBw() {
        return this.getUtilizationOfBw(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfBw(double time) {
        return this.getUtilizationModelBw().getUtilization(time);
    }

    @Override
    public double getUtilizationOfRam() {
        return this.getUtilizationOfRam(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfRam(double time) {
        return this.getUtilizationModelRam().getUtilization(time);
    }

    @Override
    public double getCostPerBw() {
        return this.costPerBw;
    }

    protected final void setCostPerBw(double costPerBw) {
        this.costPerBw = costPerBw;
    }

    @Override
    public double getAccumulatedBwCost() {
        return this.accumulatedBwCost;
    }

    protected final void setAccumulatedBwCost(double accumulatedBwCost) {
        this.accumulatedBwCost = accumulatedBwCost;
    }

    @Override
    public double getSubmissionDelay() {
        return this.submissionDelay;
    }

    @Override
    public final void setSubmissionDelay(double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        this.submissionDelay = submissionDelay;
    }

    @Override
    public boolean isBoundToVm() {
        return this.vm != null && this.vm != Vm.NULL && !(this.vm instanceof VmGroup) && this.getBroker().equals(this.getVm().getBroker());
    }

    @Override
    public final Cloudlet setFileSize(long fileSize) {
        if (fileSize <= 0L) {
            throw new IllegalArgumentException("Cloudlet file size has to be greater than zero.");
        }
        this.fileSize = fileSize;
        return this;
    }

    @Override
    public final Cloudlet setOutputSize(long outputSize) {
        if (outputSize <= 0L) {
            throw new IllegalArgumentException("Cloudlet output size has to be greater than zero.");
        }
        this.outputSize = outputSize;
        return this;
    }

    @Override
    public Cloudlet setSizes(long size) {
        this.setFileSize(size);
        this.setOutputSize(size);
        return this;
    }

    @Override
    public void assignToDatacenter(Datacenter datacenter) {
        CloudletDatacenterExecution dcInfo = new CloudletDatacenterExecution();
        dcInfo.setDatacenter(datacenter);
        dcInfo.setCostPerSec(datacenter.getCharacteristics().getCostPerSecond());
        this.datacenterExecutionList.add(dcInfo);
        this.setLastExecutedDatacenterIdx(this.getLastExecutedDatacenterIdx() + 1);
        this.setCostPerBw(datacenter.getCharacteristics().getCostPerBw());
        this.setAccumulatedBwCost(this.costPerBw * (double)this.fileSize);
    }

    @Override
    public double registerArrivalInDatacenter() {
        if (!this.isAssignedToDatacenter()) {
            return -1.0;
        }
        CloudletDatacenterExecution dcInfo = this.datacenterExecutionList.get(this.lastExecutedDatacenterIdx);
        dcInfo.setArrivalTime(this.getSimulation().clock());
        return dcInfo.getArrivalTime();
    }

    private boolean isAssignedToDatacenter() {
        return !this.datacenterExecutionList.isEmpty();
    }

    @Override
    public double getLastDatacenterArrivalTime() {
        return this.getLastExecutionInDatacenterInfo().getArrivalTime();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CloudletAbstract)) {
            return false;
        }
        CloudletAbstract that = (CloudletAbstract)other;
        if (this.getId() != that.getId()) {
            return false;
        }
        return this.getBroker().equals(that.getBroker());
    }
}

