/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.core.CloudInformationService;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.CloudSimEvent;
import org.cloudbus.cloudsim.core.events.DeferredQueue;
import org.cloudbus.cloudsim.core.events.EventQueue;
import org.cloudbus.cloudsim.core.events.FutureQueue;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.network.topologies.NetworkTopology;
import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudSim
implements Simulation {
    public static final String VERSION = "CloudSim Plus 5.1.3";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)CloudSim.class.getSimpleName());
    private final double[] circularClockTimeQueue;
    private double lastClockTickListenersUpdate;
    private NetworkTopology networkTopology;
    private final CloudInformationService cis;
    private final Calendar calendar;
    private double terminationTime = -1.0;
    private double lastCloudletProcessingUpdate;
    private double newTerminationTime = -1.0;
    private final double minTimeBetweenEvents;
    private final List<CloudSimEntity> entities = new ArrayList<CloudSimEntity>();
    private final FutureQueue future = new FutureQueue();
    private final DeferredQueue deferred = new DeferredQueue();
    private double clock = 0.0;
    private boolean running = false;
    private final Map<SimEntity, Predicate<SimEvent>> waitPredicates = new HashMap<SimEntity, Predicate<SimEvent>>();
    private boolean paused;
    private double pauseAt = -1.0;
    private boolean abortRequested;
    private boolean alreadyRunOnce = false;
    private final Set<EventListener<SimEvent>> onEventProcessingListeners;
    private final Set<EventListener<EventInfo>> onSimulationPauseListeners;
    private final Set<EventListener<EventInfo>> onClockTickListeners;
    private final Set<EventListener<EventInfo>> onSimulationStartListeners;
    private boolean processEventsInParallel;

    public CloudSim() {
        this(0.1);
    }

    public CloudSim(double minTimeBetweenEvents) {
        this.networkTopology = NetworkTopology.NULL;
        this.onEventProcessingListeners = new HashSet<EventListener<SimEvent>>();
        this.onSimulationPauseListeners = new HashSet<EventListener<EventInfo>>();
        this.onClockTickListeners = new HashSet<EventListener<EventInfo>>();
        this.onSimulationStartListeners = new HashSet<EventListener<EventInfo>>();
        this.calendar = Calendar.getInstance();
        this.cis = new CloudInformationService(this);
        if (minTimeBetweenEvents <= 0.0) {
            throw new IllegalArgumentException("The minimal time between events should be positive, but is: " + minTimeBetweenEvents);
        }
        this.minTimeBetweenEvents = minTimeBetweenEvents;
        this.lastClockTickListenersUpdate = minTimeBetweenEvents;
        this.circularClockTimeQueue = new double[]{minTimeBetweenEvents, minTimeBetweenEvents};
    }

    private void finish() {
        if (this.abortRequested) {
            return;
        }
        this.notifyEndOfSimulationToEntities();
        LOGGER.info("Simulation: No more future events{}", (Object)System.lineSeparator());
        List<SimEntity> entitiesAlive = this.entities.stream().filter(CloudSimEntity::isAlive).collect(Collectors.toList());
        if (!this.abortRequested) {
            entitiesAlive.forEach(SimEntity::run);
        }
        entitiesAlive.forEach(SimEntity::shutdownEntity);
        this.running = false;
        this.printSimulationFinished();
        LOGGER.debug("DeferredQueue >> max size: {} added to middle: {} added to tail: {}", new Object[]{this.deferred.getMaxSize(), this.deferred.getAddedToMiddle(), this.deferred.getAddedToTail()});
    }

    @Override
    public double runFor(double interval) {
        double until;
        double d = until = interval == Double.MAX_VALUE ? interval : this.clock + interval;
        if (!this.processEvents(until)) {
            this.setClock(until);
            if (this.future.isEmpty()) {
                this.finish();
            }
        }
        return this.clock;
    }

    @Override
    public double start() {
        this.startSync();
        while (this.processEvents(Double.MAX_VALUE)) {
        }
        this.finish();
        return this.clock;
    }

    @Override
    public void startSync() {
        if (this.alreadyRunOnce) {
            throw new UnsupportedOperationException("You can't run a simulation that has already run previously. If you've paused the simulation and want to resume it, call the resume() method.");
        }
        LOGGER.info("{}================== Starting {} =================={}", new Object[]{System.lineSeparator(), VERSION, System.lineSeparator()});
        this.startEntitiesIfNotRunning();
        this.alreadyRunOnce = true;
    }

    private void notifyOnSimulationStartListeners() {
        if (!this.onSimulationStartListeners.isEmpty() && this.clock > 0.0) {
            this.notifyEventListeners(this.onSimulationStartListeners, this.clock);
            this.onSimulationStartListeners.clear();
        }
    }

    private void notifyEventListeners(Set<EventListener<EventInfo>> onSimulationStartListeners, double clock) {
        onSimulationStartListeners.forEach(listener -> listener.update(EventInfo.of(listener, clock)));
    }

    private boolean processEvents(double until) {
        if (this.runClockTickAndProcessFutureEvents(until) || this.isToWaitClockToReachTerminationTime()) {
            this.notifyOnSimulationStartListeners();
            if (this.logSimulationAborted()) {
                return false;
            }
            if (this.isTimeToTerminateSimulationUnderRequest()) {
                if (this.newTerminationTime != -1.0 && this.clock >= this.newTerminationTime) {
                    return false;
                }
                if (this.newTerminationTime == -1.0) {
                    this.newTerminationTime = Math.max(this.terminationTime, this.clock) + this.minTimeBetweenEvents * 2.0;
                }
            }
            this.checkIfSimulationPauseRequested();
            return true;
        }
        return false;
    }

    private boolean logSimulationAborted() {
        if (this.abortRequested) {
            LOGGER.info("{}================================================== Simulation aborted under request at time {} ==================================================", (Object)System.lineSeparator(), (Object)this.clock);
            return true;
        }
        return false;
    }

    private void notifyEndOfSimulationToEntities() {
        this.entities.stream().filter(CloudSimEntity::isAlive).forEach(e -> this.sendNow((SimEntity)e, -1));
        LOGGER.info("{}: Processing last events before simulation shutdown.", (Object)this.clockStr());
        while (this.runClockTickAndProcessFutureEvents(Double.MAX_VALUE)) {
        }
    }

    private void printSimulationFinished() {
        String msg2;
        String msg1 = String.format("Simulation finished at time %.2f", this.clock);
        String extra = this.future.isEmpty() ? "" : ", before completing,";
        String string = msg2 = this.isTimeToTerminateSimulationUnderRequest() ? extra + " in reason of an explicit request to terminate() or terminateAt()" : "";
        if (this.terminationTime > 0.0 && this.clock > this.lastCloudletProcessingUpdate + TimeUtil.minutesToSeconds(60.0)) {
            LOGGER.warn("Your simulation termination time was set to {} but the last time a Cloudlet has processed was {}. If you think your simulation is taking to long to finish, maybe it's because you set a too long termination time and new events aren't arriving so far.", (Object)this.terminationTime, (Object)this.lastCloudletProcessingUpdate);
        }
        LOGGER.info("{}================== {}{} =================={}", new Object[]{System.lineSeparator(), msg1, msg2, System.lineSeparator()});
    }

    @Override
    public boolean isTimeToTerminateSimulationUnderRequest() {
        return this.isTerminationTimeSet() && this.clock >= this.terminationTime;
    }

    @Override
    public boolean terminate() {
        if (this.running) {
            this.running = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean terminateAt(double time) {
        if (time <= this.clock) {
            return false;
        }
        this.terminationTime = time;
        return true;
    }

    public double getTerminationTime() {
        return this.terminationTime;
    }

    @Override
    public double getMinTimeBetweenEvents() {
        return this.minTimeBetweenEvents;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public CloudInformationService getCloudInfoService() {
        return this.cis;
    }

    @Override
    public double clock() {
        return this.clock;
    }

    @Override
    public String clockStr() {
        return String.format("%.2f", this.clock);
    }

    @Override
    public double clockInMinutes() {
        return this.clock() / 60.0;
    }

    @Override
    public double clockInHours() {
        return this.clock() / 3600.0;
    }

    private double setClock(double newTime) {
        double oldTime = this.clock;
        this.clock = newTime;
        this.notifyOnClockTickListenersIfClockChanged();
        return oldTime;
    }

    @Override
    public int getNumEntities() {
        return this.entities.size();
    }

    @Override
    public List<SimEntity> getEntityList() {
        return Collections.unmodifiableList(this.entities);
    }

    @Override
    public void addEntity(CloudSimEntity entity) {
        Objects.requireNonNull(entity);
        if (this.running) {
            CloudSimEvent evt = new CloudSimEvent(SimEvent.Type.CREATE, 0.0, entity, SimEntity.NULL, -1, entity);
            this.future.addEvent(evt);
        }
        if (entity.getId() == -1L) {
            entity.setId(this.entities.size());
            this.entities.add(entity);
        }
    }

    private boolean runClockTickAndProcessFutureEvents(double until) {
        this.executeRunnableEntities(until);
        if (this.future.isEmpty()) {
            return false;
        }
        SimEvent first = this.future.first();
        if (first.getTime() <= until) {
            this.processFutureEventsHappeningAtSameTimeOfTheFirstOne(first);
            return true;
        }
        return false;
    }

    private boolean isToWaitClockToReachTerminationTime() {
        if (this.isTerminationTimeSet()) {
            double increment = this.minDatacentersSchedulingInterval();
            String info = increment == this.minTimeBetweenEvents ? "using getMinTimeBetweenEvents() since a Datacenter schedulingInterval was not set" : "Datacenter.getSchedulingInterval()";
            LOGGER.info("{}: Simulation: Waiting more events or the clock to reach {} (the termination time set). Checking new events in {} seconds ({})", new Object[]{this.clockStr(), this.terminationTime, increment, info});
            this.setClock(this.clock + increment);
            return true;
        }
        return false;
    }

    private double minDatacentersSchedulingInterval() {
        return this.cis.getDatacenterList().stream().mapToDouble(Datacenter::getSchedulingInterval).filter(interval -> interval > 0.0).min().orElse(this.minTimeBetweenEvents);
    }

    private void processFutureEventsHappeningAtSameTimeOfTheFirstOne(SimEvent firstEvent) {
        this.processEvent(firstEvent);
        this.future.remove(firstEvent);
        Iterator<SimEvent> it = this.future.iterator();
        while (it.hasNext()) {
            SimEvent evt = it.next();
            if (evt.getTime() != firstEvent.getTime()) continue;
            this.processEvent(evt);
            it.remove();
        }
    }

    private void executeRunnableEntities(double until) {
        for (int i = 0; i < this.entities.size(); ++i) {
            CloudSimEntity ent = this.entities.get(i);
            if (ent.getState() != SimEntity.State.RUNNABLE) continue;
            ent.run(until);
        }
    }

    private void executeRunnableEntities() {
        this.executeRunnableEntities(Double.MAX_VALUE);
    }

    private void sendNow(SimEntity dest, int tag) {
        this.sendNow(this.cis, dest, tag, null);
    }

    @Override
    public void sendNow(SimEntity src, SimEntity dest, int tag, Object data) {
        this.send(src, dest, 0.0, tag, data);
    }

    @Override
    public void send(SimEntity src, SimEntity dest, double delay, int tag, Object data) {
        this.send(new CloudSimEvent(SimEvent.Type.SEND, delay, src, dest, tag, data));
    }

    @Override
    public void send(SimEvent evt) {
        Objects.requireNonNull(evt);
        if (evt.getTag() < 0 && evt.getTag() != -1) {
            this.future.addEventFirst(evt);
        } else {
            this.future.addEvent(evt);
        }
    }

    @Override
    public void sendFirst(SimEntity src, SimEntity dest, double delay, int tag, Object data) {
        this.sendFirst(new CloudSimEvent(SimEvent.Type.SEND, delay, src, dest, tag, data));
    }

    @Override
    public void sendFirst(SimEvent evt) {
        this.future.addEventFirst(evt);
    }

    @Override
    public void wait(CloudSimEntity src, Predicate<SimEvent> predicate) {
        src.setState(SimEntity.State.WAITING);
        if (predicate != ANY_EVT) {
            this.waitPredicates.put(src, predicate);
        }
    }

    @Override
    public SimEvent select(SimEntity dest, Predicate<SimEvent> predicate) {
        SimEvent evt = this.findFirstDeferred(dest, predicate);
        if (evt != SimEvent.NULL) {
            this.deferred.remove(evt);
        }
        return evt;
    }

    @Override
    public SimEvent findFirstDeferred(SimEntity dest, Predicate<SimEvent> predicate) {
        return this.filterEventsToDestinationEntity(this.deferred, predicate, dest).findFirst().orElse(SimEvent.NULL);
    }

    private Stream<SimEvent> filterEventsToDestinationEntity(EventQueue queue, Predicate<SimEvent> predicate, SimEntity dest) {
        return this.filterEvents(queue, predicate.and(evt -> evt.getDestination() == dest));
    }

    @Override
    public SimEvent cancel(SimEntity src, Predicate<SimEvent> predicate) {
        SimEvent canceled = this.future.stream().filter(this.isEventSourceEqualsTo(predicate, src)).findFirst().orElse(SimEvent.NULL);
        this.future.remove(canceled);
        return canceled;
    }

    @Override
    public boolean cancelAll(SimEntity src, Predicate<SimEvent> predicate) {
        int previousSize = this.future.size();
        this.future.removeIf(this.isEventSourceEqualsTo(predicate, src));
        return previousSize < this.future.size();
    }

    private Predicate<SimEvent> isEventSourceEqualsTo(Predicate<SimEvent> predicate, SimEntity src) {
        return predicate.and(evt -> evt.getSource().equals(src));
    }

    private Stream<SimEvent> filterEvents(EventQueue queue, Predicate<SimEvent> predicate) {
        return queue.stream().filter(predicate);
    }

    private void processEvent(SimEvent evt) {
        if (evt.getTime() < this.clock) {
            throw new IllegalArgumentException("Past event detected. Event time: " + evt.getTime() + " Simulation clock: " + this.clock);
        }
        this.setClock(evt.getTime());
        this.processEventByType(evt);
        for (EventListener<SimEvent> listener : this.onEventProcessingListeners) {
            listener.update(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(Runnable runnable) {
        if (this.processEventsInParallel) {
            CloudSim cloudSim = this;
            synchronized (cloudSim) {
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    private void notifyOnClockTickListenersIfClockChanged() {
        if (this.clock > this.lastClockTickListenersUpdate) {
            this.addCurrentTimeToCircularQueue();
            if (this.circularClockTimeQueue[0] < this.circularClockTimeQueue[1]) {
                this.lastClockTickListenersUpdate = this.circularClockTimeQueue[0];
                this.notifyEventListeners(this.onClockTickListeners, this.lastClockTickListenersUpdate);
            }
        }
    }

    private void addCurrentTimeToCircularQueue() {
        this.circularClockTimeQueue[0] = this.circularClockTimeQueue[1];
        this.circularClockTimeQueue[1] = this.clock;
    }

    private void processEventByType(SimEvent evt) {
        switch (evt.getType()) {
            case NULL: {
                throw new IllegalArgumentException("Event has a null type.");
            }
            case CREATE: {
                this.processCreateEvent(evt);
                break;
            }
            case SEND: {
                this.processSendEvent(evt);
                break;
            }
            case HOLD_DONE: {
                this.processHoldEvent(evt);
            }
        }
    }

    private void processCreateEvent(SimEvent evt) {
        this.addEntityDynamically((SimEntity)evt.getData());
    }

    private void addEntityDynamically(SimEntity entity) {
        Objects.requireNonNull(entity);
        LOGGER.trace("Adding: {}", (Object)entity.getName());
        entity.start();
    }

    private void processHoldEvent(SimEvent evt) {
        if (evt.getSource() == SimEntity.NULL) {
            throw new IllegalArgumentException("Null entity holding.");
        }
        evt.getSource().setState(SimEntity.State.RUNNABLE);
    }

    private void processSendEvent(SimEvent evt) {
        if (evt.getDestination() == SimEntity.NULL) {
            throw new IllegalArgumentException("Attempt to send to a null entity detected.");
        }
        CloudSimEntity destEnt = (CloudSimEntity)evt.getDestination();
        if (destEnt.getState() == SimEntity.State.WAITING) {
            Predicate<SimEvent> p = this.waitPredicates.get(destEnt);
            if (p == null || evt.getTag() == 9999 || p.test(evt)) {
                destEnt.setEventBuffer(new CloudSimEvent(evt));
                destEnt.setState(SimEntity.State.RUNNABLE);
                this.waitPredicates.remove(destEnt);
            } else {
                this.deferred.addEvent(evt);
            }
            return;
        }
        this.deferred.addEvent(evt);
    }

    private void startEntitiesIfNotRunning() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.entities.forEach(SimEntity::start);
        LOGGER.info("Entities started.");
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean pause() {
        return this.pause(this.clock);
    }

    @Override
    public boolean pause(double time) {
        if (time < this.clock) {
            return false;
        }
        this.pauseAt = time;
        LOGGER.info("{}: Pausing simulation under request", (Object)this.clockStr());
        return true;
    }

    @Override
    public boolean resume() {
        boolean wasPaused = this.paused;
        this.paused = false;
        if (wasPaused) {
            LOGGER.info("{}: Resuming simulation under request", (Object)this.clockStr());
        }
        if (this.pauseAt <= this.clock) {
            this.pauseAt = -1.0;
        }
        return wasPaused;
    }

    @Override
    public void pauseEntity(SimEntity src, double delay) {
        CloudSimEvent evt = new CloudSimEvent(SimEvent.Type.HOLD_DONE, delay, src);
        this.addHoldingFutureEvent(src, evt);
    }

    private void addHoldingFutureEvent(SimEntity src, SimEvent evt) {
        this.future.addEvent(evt);
        src.setState(SimEntity.State.HOLDING);
    }

    protected void holdEntity(SimEntity src, long delay) {
        CloudSimEvent evt = new CloudSimEvent(SimEvent.Type.HOLD_DONE, delay, src);
        this.addHoldingFutureEvent(src, evt);
    }

    private void checkIfSimulationPauseRequested() {
        if ((this.isThereFutureEvtsAndNextOneHappensAfterTimeToPause() || this.isNotThereNextFutureEvtsAndIsTimeToPause()) && this.doPause()) {
            this.waitsForSimulationToBeResumedIfPaused();
        }
    }

    private boolean doPause() {
        if (this.running && this.isPauseRequested()) {
            this.paused = true;
            this.setClock(this.pauseAt);
            this.notifyEventListeners(this.onSimulationPauseListeners, this.clock);
            return true;
        }
        return false;
    }

    private boolean isPauseRequested() {
        return this.pauseAt > -1.0;
    }

    private void waitsForSimulationToBeResumedIfPaused() {
        while (this.paused) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pauseAt = -1.0;
    }

    @Override
    public long getNumberOfFutureEvents(Predicate<SimEvent> predicate) {
        return this.future.stream().filter(predicate).count();
    }

    private boolean isThereFutureEvtsAndNextOneHappensAfterTimeToPause() {
        return !this.future.isEmpty() && this.clock <= this.pauseAt && this.isNextFutureEventHappeningAfterTimeToPause();
    }

    private boolean isNotThereNextFutureEvtsAndIsTimeToPause() {
        return this.future.isEmpty() && this.clock >= this.pauseAt;
    }

    @Override
    public boolean isTerminationTimeSet() {
        return this.terminationTime > 0.0;
    }

    private boolean isNextFutureEventHappeningAfterTimeToPause() {
        return this.future.iterator().next().getTime() >= this.pauseAt;
    }

    @Override
    public void abort() {
        this.abortRequested = true;
        this.running = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public final Simulation addOnSimulationPauseListener(EventListener<EventInfo> listener) {
        this.onSimulationPauseListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public final Simulation addOnSimulationStartListener(EventListener<EventInfo> listener) {
        this.onSimulationStartListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnSimulationPauseListener(EventListener<EventInfo> listener) {
        return this.onSimulationPauseListeners.remove(listener);
    }

    @Override
    public final Simulation addOnEventProcessingListener(EventListener<SimEvent> listener) {
        this.onEventProcessingListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnEventProcessingListener(EventListener<SimEvent> listener) {
        return this.onEventProcessingListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public Simulation addOnClockTickListener(EventListener<EventInfo> listener) {
        this.onClockTickListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnClockTickListener(EventListener<? extends EventInfo> listener) {
        return this.onClockTickListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public NetworkTopology getNetworkTopology() {
        return this.networkTopology;
    }

    @Override
    public void setNetworkTopology(NetworkTopology networkTopology) {
        this.networkTopology = networkTopology;
    }

    @Override
    public double getLastCloudletProcessingUpdate() {
        return this.lastCloudletProcessingUpdate;
    }

    @Override
    public void setLastCloudletProcessingUpdate(double lastCloudletProcessingUpdate) {
        this.lastCloudletProcessingUpdate = lastCloudletProcessingUpdate;
    }

    public long getMaxEventsNumber() {
        return this.future.getMaxEventsNumber();
    }

    public long getGeneratedEventsNumber() {
        return this.future.getSerial();
    }
}

