/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.distributions;

import org.apache.commons.lang3.Range;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.JDKThreadLocalRandomGenerator;

public class UniformDistr
extends UniformRealDistribution
implements ContinuousDistribution {
    private boolean applyAntitheticVariates;
    private long seed;

    public UniformDistr() {
        this(0.0, 1.0);
    }

    public UniformDistr(long seed) {
        this(0.0, 1.0, seed);
    }

    public UniformDistr(long seed, RandomGenerator rng) {
        this(0.0, 1.0, seed, rng);
    }

    public UniformDistr(Range<Double> range) {
        this(range, ContinuousDistribution.defaultSeed());
    }

    public UniformDistr(Range<Double> range, long seed) {
        this((Double)range.getMinimum(), (Double)range.getMaximum() + 1.0, seed);
    }

    public UniformDistr(double minInclusive, double maxExclusive) {
        this(minInclusive, maxExclusive, ContinuousDistribution.defaultSeed());
    }

    public UniformDistr(double minInclusive, double maxExclusive, long seed) {
        this(minInclusive, maxExclusive, seed, ContinuousDistribution.newDefaultGen(seed));
    }

    public UniformDistr(double minInclusive, double maxExclusive, long seed, RandomGenerator rng) {
        super(rng, minInclusive, maxExclusive);
        if (seed < 0L) {
            throw new IllegalArgumentException("Seed cannot be negative");
        }
        this.seed = seed;
        this.applyAntitheticVariates = false;
    }

    @Override
    public double sample() {
        return this.applyAntitheticVariates ? 1.0 - super.sample() : super.sample();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    public UniformDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        if (applyAntitheticVariates && this.random instanceof JDKThreadLocalRandomGenerator) {
            throw new IllegalStateException("The Antithetic Variates Technique cannot be applied when using the " + JDKThreadLocalRandomGenerator.class.getSimpleName() + " as underlying PRNG, because it doesn't allow setting a seed explicitly.");
        }
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }
}

