/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts;

import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.cloudbus.cloudsim.core.Machine;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.HostNull;
import org.cloudbus.cloudsim.hosts.HostStateHistoryEntry;
import org.cloudbus.cloudsim.power.models.PowerModel;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;

public interface Host
extends Machine,
Comparable<Host> {
    public static final double DEF_IDLE_SHUTDOWN_DEADLINE = -1.0;
    public static final Host NULL = new HostNull();

    public Datacenter getDatacenter();

    public void setDatacenter(Datacenter var1);

    public boolean isSuitableForVm(Vm var1);

    public boolean isActive();

    public boolean hasEverStarted();

    public Host setActive(boolean var1);

    public <T extends Vm> Set<T> getVmsMigratingIn();

    public boolean addMigratingInVm(Vm var1);

    public Set<Vm> getVmsMigratingOut();

    public boolean addVmMigratingOut(Vm var1);

    public boolean removeVmMigratingOut(Vm var1);

    public void reallocateMigratingInVms();

    @Override
    public double getTotalMipsCapacity();

    public void removeMigratingInVm(Vm var1);

    public double getTotalAllocatedMipsForVm(Vm var1);

    public List<Pe> getPeList();

    public List<Pe> getWorkingPeList();

    public List<Pe> getBusyPeList();

    public List<Pe> getFreePeList();

    public int getFreePesNumber();

    public int getWorkingPesNumber();

    public int getFailedPesNumber();

    public double getTotalAvailableMips();

    public long getAvailableStorage();

    public ResourceProvisioner getBwProvisioner();

    public Host setBwProvisioner(ResourceProvisioner var1);

    public ResourceProvisioner getRamProvisioner();

    public Host setRamProvisioner(ResourceProvisioner var1);

    public <T extends Vm> List<T> getVmList();

    public <T extends Vm> List<T> getVmCreatedList();

    public VmScheduler getVmScheduler();

    public Host setVmScheduler(VmScheduler var1);

    public double getStartTime();

    public void setStartTime(double var1);

    public double getShutdownTime();

    public void setShutdownTime(double var1);

    public double getUpTime();

    public double getUpTimeHours();

    public double getTotalUpTime();

    public double getTotalUpTimeHours();

    public double getIdleShutdownDeadline();

    public Host setIdleShutdownDeadline(double var1);

    public boolean isFailed();

    public boolean setFailed(boolean var1);

    public double updateProcessing(double var1);

    public boolean createVm(Vm var1);

    public void destroyVm(Vm var1);

    public boolean createTemporaryVm(Vm var1);

    public void destroyTemporaryVm(Vm var1);

    public void destroyAllVms();

    public Host addOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> var1);

    public boolean removeOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> var1);

    public Host setSimulation(Simulation var1);

    public ResourceProvisioner getProvisioner(Class<? extends ResourceManageable> var1);

    public double getCpuPercentUtilization();

    public double getCpuMipsUtilization();

    public long getBwUtilization();

    public long getRamUtilization();

    public SortedMap<Double, DoubleSummaryStatistics> getUtilizationHistory();

    public SortedMap<Double, Double> getUtilizationHistorySum();

    public PowerModel getPowerModel();

    public Host setPowerModel(PowerModel var1);

    public double getPreviousUtilizationOfCpu();

    public void enableStateHistory();

    public void disableStateHistory();

    public boolean isStateHistoryEnabled();

    public List<HostStateHistoryEntry> getStateHistory();

    public List<Vm> getFinishedVms();

    public List<Vm> getMigratableVms();
}

