/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.cloudlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletExecution;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.resources.Bandwidth;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.CloudletTaskScheduler;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmSimple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudletSchedulerAbstract
implements CloudletScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudletSchedulerAbstract.class.getSimpleName());
    private final List<CloudletExecution> cloudletPausedList;
    private final List<CloudletExecution> cloudletFinishedList;
    private final List<CloudletExecution> cloudletFailedList;
    private CloudletTaskScheduler taskScheduler;
    private double previousTime;
    private List<Double> currentMipsShare;
    private final List<CloudletExecution> cloudletExecList;
    private final List<CloudletExecution> cloudletWaitingList;
    private Vm vm;
    private final Set<Cloudlet> cloudletReturnedList;

    protected CloudletSchedulerAbstract() {
        this.setPreviousTime(0.0);
        this.vm = Vm.NULL;
        this.cloudletExecList = new ArrayList<CloudletExecution>();
        this.cloudletPausedList = new ArrayList<CloudletExecution>();
        this.cloudletFinishedList = new ArrayList<CloudletExecution>();
        this.cloudletFailedList = new ArrayList<CloudletExecution>();
        this.cloudletWaitingList = new ArrayList<CloudletExecution>();
        this.cloudletReturnedList = new HashSet<Cloudlet>();
        this.currentMipsShare = new ArrayList<Double>();
        this.taskScheduler = CloudletTaskScheduler.NULL;
    }

    @Override
    public double getPreviousTime() {
        return this.previousTime;
    }

    protected final void setPreviousTime(double previousTime) {
        this.previousTime = previousTime;
    }

    public List<Double> getCurrentMipsShare() {
        return Collections.unmodifiableList(this.currentMipsShare);
    }

    protected void setCurrentMipsShare(List<Double> currentMipsShare) {
        if ((long)currentMipsShare.size() > this.vm.getNumberOfPes()) {
            LOGGER.warn("Requested {} PEs but {} has just {}", new Object[]{currentMipsShare.size(), this.vm, this.vm.getNumberOfPes()});
        }
        this.currentMipsShare = currentMipsShare;
    }

    public double getAvailableMipsByPe() {
        long totalPesOfAllExecCloudlets = this.totalPesOfAllExecCloudlets();
        if (totalPesOfAllExecCloudlets > (long)this.currentMipsShare.size()) {
            return this.getTotalMipsShare() / (double)totalPesOfAllExecCloudlets;
        }
        return this.getPeCapacity();
    }

    private Double getPeCapacity() {
        return this.currentMipsShare.stream().findFirst().orElse(0.0);
    }

    private long totalPesOfAllExecCloudlets() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToLong(Cloudlet::getNumberOfPes).sum();
    }

    private double getTotalMipsShare() {
        return this.currentMipsShare.stream().mapToDouble(mips -> mips).sum();
    }

    @Override
    public List<CloudletExecution> getCloudletExecList() {
        return Collections.unmodifiableList(this.cloudletExecList);
    }

    protected void addCloudletToWaitingList(CloudletExecution cle) {
        if (Objects.requireNonNull(cle) == CloudletExecution.NULL) {
            return;
        }
        if (cle.getCloudlet().getStatus() != Cloudlet.Status.FROZEN) {
            cle.setStatus(Cloudlet.Status.QUEUED);
        }
        this.cloudletWaitingList.add(cle);
    }

    protected List<CloudletExecution> getCloudletPausedList() {
        return this.cloudletPausedList;
    }

    @Override
    public List<CloudletExecution> getCloudletFinishedList() {
        return this.cloudletFinishedList;
    }

    protected List<CloudletExecution> getCloudletFailedList() {
        return this.cloudletFailedList;
    }

    @Override
    public List<CloudletExecution> getCloudletWaitingList() {
        return Collections.unmodifiableList(this.cloudletWaitingList);
    }

    protected void sortCloudletWaitingList(Comparator<CloudletExecution> comparator) {
        this.cloudletWaitingList.sort(comparator);
    }

    @Override
    public final double cloudletSubmit(Cloudlet cloudlet) {
        return this.cloudletSubmit(cloudlet, 0.0);
    }

    @Override
    public final double cloudletSubmit(Cloudlet cloudlet, double fileTransferTime) {
        return this.cloudletSubmitInternal(new CloudletExecution(cloudlet), fileTransferTime);
    }

    protected double cloudletSubmitInternal(CloudletExecution cle, double fileTransferTime) {
        if (this.canExecuteCloudlet(cle)) {
            cle.setStatus(Cloudlet.Status.INEXEC);
            cle.setFileTransferTime(fileTransferTime);
            this.addCloudletToExecList(cle);
            return fileTransferTime + Math.abs((double)cle.getCloudletLength() / this.getPeCapacity());
        }
        this.addCloudletToWaitingList(cle);
        return 0.0;
    }

    protected void addCloudletToExecList(CloudletExecution cle) {
        cle.setStatus(Cloudlet.Status.INEXEC);
        cle.setLastProcessingTime(this.getVm().getSimulation().clock());
        this.cloudletExecList.add(cle);
        this.addUsedPes(cle.getNumberOfPes());
    }

    @Override
    public boolean hasFinishedCloudlets() {
        return !this.cloudletFinishedList.isEmpty();
    }

    protected Optional<CloudletExecution> findCloudletInAllLists(double cloudletId) {
        Stream<List> streamOfAllLists = Stream.of(this.cloudletExecList, this.cloudletPausedList, this.cloudletWaitingList, this.cloudletFinishedList, this.cloudletFailedList);
        return streamOfAllLists.flatMap(Collection::stream).filter(cle -> (double)cle.getCloudletId() == cloudletId).findFirst();
    }

    protected Optional<CloudletExecution> findCloudletInList(Cloudlet cloudlet, List<CloudletExecution> list) {
        return list.stream().filter(cle -> cle.getCloudletId() == cloudlet.getId()).findFirst();
    }

    protected void cloudletFinish(CloudletExecution cle) {
        cle.setStatus(Cloudlet.Status.SUCCESS);
        cle.finalizeCloudlet();
        this.cloudletFinishedList.add(cle);
    }

    @Override
    public boolean cloudletReady(Cloudlet cloudlet) {
        if (this.changeStatusOfCloudletIntoList(this.cloudletPausedList, cloudlet, this::changeToReady)) {
            return true;
        }
        cloudlet.setStatus(Cloudlet.Status.READY);
        Datacenter dc = this.vm.getHost().getDatacenter();
        dc.schedule(41);
        return true;
    }

    private void changeToReady(CloudletExecution cle) {
        this.changeStatusOfCloudlet(cle, cle.getCloudlet().getStatus(), Cloudlet.Status.READY);
    }

    @Override
    public boolean cloudletPause(Cloudlet cloudlet) {
        if (this.changeStatusOfCloudletIntoList(this.cloudletExecList, cloudlet, this::changeInExecToPaused)) {
            return true;
        }
        return this.changeStatusOfCloudletIntoList(this.cloudletWaitingList, cloudlet, this::changeReadyToPaused);
    }

    private void changeInExecToPaused(CloudletExecution cle) {
        this.changeStatusOfCloudlet(cle, Cloudlet.Status.INEXEC, Cloudlet.Status.PAUSED);
        this.removeUsedPes(cle.getNumberOfPes());
    }

    private void changeReadyToPaused(CloudletExecution cle) {
        this.changeStatusOfCloudlet(cle, Cloudlet.Status.READY, Cloudlet.Status.PAUSED);
    }

    @Override
    public Cloudlet cloudletFail(Cloudlet cloudlet) {
        return this.stopCloudlet(cloudlet, Cloudlet.Status.FAILED);
    }

    @Override
    public Cloudlet cloudletCancel(Cloudlet cloudlet) {
        return this.stopCloudlet(cloudlet, Cloudlet.Status.CANCELED);
    }

    private Cloudlet stopCloudlet(Cloudlet cloudlet, Cloudlet.Status stopStatus) {
        boolean found = this.changeStatusOfCloudletIntoList(this.cloudletFinishedList, cloudlet, cle -> {});
        if (found) {
            return cloudlet;
        }
        found = this.changeStatusOfCloudletIntoList(this.cloudletExecList, cloudlet, cle -> this.changeStatusOfCloudlet((CloudletExecution)cle, Cloudlet.Status.INEXEC, stopStatus));
        if (found) {
            return cloudlet;
        }
        found = this.changeStatusOfCloudletIntoList(this.cloudletPausedList, cloudlet, cle -> this.changeStatusOfCloudlet((CloudletExecution)cle, Cloudlet.Status.PAUSED, stopStatus));
        if (found) {
            return cloudlet;
        }
        this.changeStatusOfCloudletIntoList(this.cloudletWaitingList, cloudlet, cle -> this.changeStatusOfCloudlet((CloudletExecution)cle, Cloudlet.Status.READY, stopStatus));
        if (found) {
            return cloudlet;
        }
        return Cloudlet.NULL;
    }

    private void changeStatusOfCloudlet(CloudletExecution cle, Cloudlet.Status currentStatus, Cloudlet.Status newStatus) {
        if ((currentStatus == Cloudlet.Status.INEXEC || currentStatus == Cloudlet.Status.READY) && cle.getCloudlet().isFinished()) {
            this.cloudletFinish(cle);
        } else {
            cle.setStatus(newStatus);
        }
        switch (newStatus) {
            case PAUSED: {
                this.cloudletPausedList.add(cle);
                break;
            }
            case READY: {
                this.addCloudletToWaitingList(cle);
            }
        }
    }

    private boolean changeStatusOfCloudletIntoList(List<CloudletExecution> cloudletList, Cloudlet cloudlet, Consumer<CloudletExecution> cloudletStatusUpdaterConsumer) {
        Function<CloudletExecution, Cloudlet> removeCloudletAndUpdateStatus = cle -> {
            cloudletList.remove(cle);
            cloudletStatusUpdaterConsumer.accept((CloudletExecution)cle);
            return cle.getCloudlet();
        };
        return this.findCloudletInList(cloudlet, cloudletList).map(removeCloudletAndUpdateStatus).isPresent();
    }

    @Override
    public double updateProcessing(double currentTime, List<Double> mipsShare) {
        this.setCurrentMipsShare(mipsShare);
        if (this.isEmpty()) {
            this.setPreviousTime(currentTime);
            return Double.MAX_VALUE;
        }
        this.addCloudletsToFinishedList();
        double nextCloudletFinishTime = this.updateCloudletsProcessing(currentTime);
        this.updateVmResourceAbsoluteUtilization(Ram.class);
        this.updateVmResourceAbsoluteUtilization(Bandwidth.class);
        nextCloudletFinishTime = Math.min(nextCloudletFinishTime, this.moveNextCloudletsFromWaitingToExecList(currentTime));
        this.setPreviousTime(currentTime);
        this.vm.getSimulation().setLastCloudletProcessingUpdate(currentTime);
        return nextCloudletFinishTime;
    }

    private double updateCloudletsProcessing(double currentTime) {
        double nextCloudletFinishTime = Double.MAX_VALUE;
        long usedPes = 0L;
        for (int i = 0; i < this.cloudletExecList.size(); ++i) {
            CloudletExecution cle = this.cloudletExecList.get(i);
            this.updateCloudletProcessingAndPacketsDispatch(cle, currentTime);
            nextCloudletFinishTime = Math.min(nextCloudletFinishTime, this.cloudletEstimatedFinishTime(cle, currentTime));
            usedPes += cle.getCloudlet().getNumberOfPes();
        }
        ((VmSimple)this.vm).setFreePesNumber(this.vm.getNumberOfPes() - usedPes);
        return nextCloudletFinishTime;
    }

    private void updateCloudletProcessingAndPacketsDispatch(CloudletExecution cle, double currentTime) {
        long partialFinishedMI = 0L;
        if (this.taskScheduler.isTimeToUpdateCloudletProcessing(cle.getCloudlet())) {
            partialFinishedMI = this.updateCloudletProcessing(cle, currentTime);
        }
        this.taskScheduler.processCloudletTasks(cle.getCloudlet(), partialFinishedMI);
    }

    protected long updateCloudletProcessing(CloudletExecution cle, double currentTime) {
        double partialFinishedInstructions = this.cloudletExecutedInstructionsForTimeSpan(cle, currentTime);
        cle.updateProcessing(partialFinishedInstructions);
        return (long)(partialFinishedInstructions / 1000000.0);
    }

    private void updateVmResourceAbsoluteUtilization(Class<? extends ResourceManageable> resourceClass) {
        ResourceManageable resource = this.vm.getResource(resourceClass);
        resource.deallocateAllResources();
        for (CloudletExecution cle : this.cloudletExecList) {
            Cloudlet cloudlet = cle.getCloudlet();
            long requested = (long)this.getCloudletResourceAbsoluteUtilization(cloudlet, resourceClass);
            if (requested > resource.getAvailableResource()) {
                String msg = resource.getAvailableResource() > 0L ? String.format("just %d was available and allocated to it.", resource.getAvailableResource()) : "no amount is available.";
                LOGGER.warn("{}: {}: {} requested {} MB of {} but {}", new Object[]{this.vm.getSimulation().clockStr(), this.getClass().getSimpleName(), cloudlet, requested, resource.getClass().getSimpleName(), msg});
            }
            resource.allocateResource(Math.min(requested, resource.getAvailableResource()));
        }
    }

    private double getCloudletResourceAbsoluteUtilization(Cloudlet cloudlet, Class<? extends ResourceManageable> resourceClass) {
        ResourceManageable vmResource = this.vm.getResource(resourceClass);
        UtilizationModel um = cloudlet.getUtilizationModel(resourceClass);
        return um.getUnit() == UtilizationModel.Unit.ABSOLUTE ? Math.min(um.getUtilization(), (double)vmResource.getCapacity()) : um.getUtilization() * (double)vmResource.getCapacity();
    }

    private double cloudletExecutedInstructionsForTimeSpan(CloudletExecution cle, double currentTime) {
        double actualProcessingTime = this.hasCloudletFileTransferTimePassed(cle, currentTime) ? this.timeSpan(cle, currentTime) : 0.0;
        double cloudletUsedMips = this.getAllocatedMipsForCloudlet(cle, currentTime);
        return cloudletUsedMips * actualProcessingTime * 1000000.0;
    }

    private boolean hasCloudletFileTransferTimePassed(CloudletExecution cle, double currentTime) {
        return cle.getFileTransferTime() == 0.0 || currentTime - cle.getCloudletArrivalTime() > cle.getFileTransferTime() || cle.getCloudlet().getFinishedLengthSoFar() > 0L;
    }

    protected double timeSpan(CloudletExecution cle, double currentTime) {
        return currentTime - cle.getLastProcessingTime();
    }

    private int addCloudletsToFinishedList() {
        List finishedCloudlets = this.cloudletExecList.stream().filter(cle -> cle.getCloudlet().isFinished()).collect(Collectors.toList());
        for (CloudletExecution c : finishedCloudlets) {
            this.addCloudletToFinishedList(c);
        }
        return finishedCloudlets.size();
    }

    private void addCloudletToFinishedList(CloudletExecution cle) {
        this.setCloudletFinishTimeAndAddToFinishedList(cle);
        this.removeCloudletFromExecList(cle);
    }

    protected CloudletExecution removeCloudletFromExecList(CloudletExecution cle) {
        this.removeUsedPes(cle.getNumberOfPes());
        return this.cloudletExecList.remove(cle) ? cle : CloudletExecution.NULL;
    }

    private void setCloudletFinishTimeAndAddToFinishedList(CloudletExecution cle) {
        double clock = this.vm.getSimulation().clock();
        cle.setFinishTime(clock);
        this.cloudletFinish(cle);
    }

    protected double cloudletEstimatedFinishTime(CloudletExecution cle, double currentTime) {
        double cloudletAllocatedMips = this.getAllocatedMipsForCloudlet(cle, currentTime);
        cle.setLastAllocatedMips(cloudletAllocatedMips);
        double estimatedFinishTime = (double)cle.getRemainingCloudletLength() / cle.getLastAllocatedMips();
        return Math.max(estimatedFinishTime, this.vm.getSimulation().getMinTimeBetweenEvents());
    }

    protected double moveNextCloudletsFromWaitingToExecList(double currentTime) {
        Optional<CloudletExecution> optional = Optional.of(CloudletExecution.NULL);
        double nextCloudletFinishTime = Double.MAX_VALUE;
        while (!this.cloudletWaitingList.isEmpty() && optional.isPresent()) {
            optional = this.findSuitableWaitingCloudlet();
            double estimatedFinishTime = optional.map(this::addWaitingCloudletToExecList).map(cle -> this.cloudletEstimatedFinishTime((CloudletExecution)cle, currentTime)).orElse((Double)Double.MAX_VALUE);
            nextCloudletFinishTime = Math.min(nextCloudletFinishTime, estimatedFinishTime);
        }
        return nextCloudletFinishTime;
    }

    protected Optional<CloudletExecution> findSuitableWaitingCloudlet() {
        return this.cloudletWaitingList.stream().filter(cle -> cle.getCloudlet().getStatus() != Cloudlet.Status.FROZEN).filter(this::canExecuteCloudlet).findFirst();
    }

    protected boolean isThereEnoughFreePesForCloudlet(CloudletExecution cle) {
        return this.vm.getProcessor().getAvailableResource() >= cle.getNumberOfPes();
    }

    protected CloudletExecution addWaitingCloudletToExecList(CloudletExecution cle) {
        this.cloudletWaitingList.remove(cle);
        this.addCloudletToExecList(cle);
        return cle;
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public void setVm(Vm vm) {
        if (this.isOtherVmAssigned(Objects.requireNonNull(vm))) {
            throw new IllegalArgumentException("CloudletScheduler already has a Vm assigned to it. Each Vm must have its own CloudletScheduler instance.");
        }
        this.vm = vm;
    }

    private boolean isOtherVmAssigned(Vm vm) {
        return this.vm != null && this.vm != Vm.NULL && !vm.equals(this.vm);
    }

    @Override
    public long getUsedPes() {
        return this.vm.getProcessor().getAllocatedResource();
    }

    @Override
    public long getFreePes() {
        return (long)this.currentMipsShare.size() - this.getUsedPes();
    }

    private void addUsedPes(long usedPesToAdd) {
        this.vm.getProcessor().allocateResource(usedPesToAdd);
    }

    private void removeUsedPes(long usedPesToRemove) {
        this.vm.getProcessor().deallocateResource(usedPesToRemove);
    }

    @Override
    public CloudletTaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    @Override
    public void setTaskScheduler(CloudletTaskScheduler taskScheduler) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.taskScheduler.setVm(this.vm);
    }

    @Override
    public boolean isThereTaskScheduler() {
        return this.taskScheduler != null && this.taskScheduler != CloudletTaskScheduler.NULL;
    }

    @Override
    public double getRequestedCpuPercentUtilization(double time) {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToDouble(cloudlet -> this.getAbsoluteCloudletCpuUtilizationForAllPes(time, (Cloudlet)cloudlet)).sum() / this.vm.getTotalMipsCapacity();
    }

    private double getAbsoluteCloudletCpuUtilizationForAllPes(double time, Cloudlet cloudlet) {
        double cloudletCpuUsageForOnePe = this.getAbsoluteCloudletResourceUtilization(cloudlet.getUtilizationModelCpu(), time, this.getAvailableMipsByPe());
        return cloudletCpuUsageForOnePe * (double)cloudlet.getNumberOfPes();
    }

    protected double getRequestedMipsForCloudlet(CloudletExecution cle, double time) {
        return this.getAbsoluteCloudletResourceUtilization(cle.getCloudlet().getUtilizationModelCpu(), time, this.vm.getMips());
    }

    public double getAllocatedMipsForCloudlet(CloudletExecution cle, double time) {
        return this.getAbsoluteCloudletResourceUtilization(cle.getCloudlet().getUtilizationModelCpu(), time, this.getAvailableMipsByPe());
    }

    @Override
    public double getCurrentRequestedBwPercentUtilization() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).map(Cloudlet::getUtilizationModelBw).mapToDouble(um -> this.getAbsoluteCloudletResourceUtilization((UtilizationModel)um, this.vm.getBw().getCapacity())).sum() / (double)this.vm.getBw().getCapacity();
    }

    @Override
    public double getCurrentRequestedRamPercentUtilization() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).map(Cloudlet::getUtilizationModelRam).mapToDouble(um -> this.getAbsoluteCloudletResourceUtilization((UtilizationModel)um, this.vm.getRam().getCapacity())).sum() / (double)this.vm.getRam().getCapacity();
    }

    private double getAbsoluteCloudletResourceUtilization(UtilizationModel model, double maxResourceAllowedToUse) {
        return this.getAbsoluteCloudletResourceUtilization(model, this.vm.getSimulation().clock(), maxResourceAllowedToUse);
    }

    private double getAbsoluteCloudletResourceUtilization(UtilizationModel model, double time, double maxResourceAllowedToUse) {
        if (model.getUnit() == UtilizationModel.Unit.ABSOLUTE) {
            return Math.min(model.getUtilization(time), maxResourceAllowedToUse);
        }
        return model.getUtilization() * maxResourceAllowedToUse;
    }

    protected Set<Cloudlet> getCloudletReturnedList() {
        return Collections.unmodifiableSet(this.cloudletReturnedList);
    }

    @Override
    public void addCloudletToReturnedList(Cloudlet cloudlet) {
        this.cloudletReturnedList.add(cloudlet);
    }

    @Override
    public void deallocatePesFromVm(int pesToRemove) {
        pesToRemove = Math.min(pesToRemove, this.currentMipsShare.size());
        this.removeUsedPes(pesToRemove);
        IntStream.range(0, pesToRemove).forEach(idx -> this.currentMipsShare.remove(0));
    }

    @Override
    public List<Cloudlet> getCloudletList() {
        return Stream.concat(this.cloudletExecList.stream(), this.cloudletWaitingList.stream()).map(CloudletExecution::getCloudlet).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public boolean isEmpty() {
        return this.cloudletExecList.isEmpty() && this.cloudletWaitingList.isEmpty();
    }

    private boolean canExecuteCloudlet(CloudletExecution cle) {
        return cle.getCloudlet().getStatus().ordinal() < Cloudlet.Status.FROZEN.ordinal() && this.canExecuteCloudletInternal(cle);
    }

    protected abstract boolean canExecuteCloudletInternal(CloudletExecution var1);

    @Override
    public void clear() {
        this.cloudletWaitingList.clear();
        this.cloudletExecList.clear();
    }
}

