/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerAbstract;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmSchedulerSpaceShared
extends VmSchedulerAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VmSchedulerSpaceShared.class.getSimpleName());

    public VmSchedulerSpaceShared() {
        this(0.1);
    }

    public VmSchedulerSpaceShared(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    protected boolean isSuitableForVmInternal(Vm vm, List<Double> requestedMips) {
        List<Pe> selectedPes = this.getTotalCapacityToBeAllocatedToVm(requestedMips);
        return selectedPes.size() >= requestedMips.size();
    }

    private List<Pe> getTotalCapacityToBeAllocatedToVm(List<Double> requestedMips) {
        if (this.getHost().getWorkingPesNumber() < requestedMips.size()) {
            return this.getHost().getWorkingPeList();
        }
        List<Pe> freePeList = this.getHost().getFreePeList();
        ArrayList<Pe> selectedPes = new ArrayList<Pe>();
        if (freePeList.isEmpty()) {
            return selectedPes;
        }
        Iterator<Pe> peIterator = freePeList.iterator();
        Pe pe = peIterator.next();
        for (double mips : requestedMips) {
            if (!(mips <= (double)pe.getCapacity())) continue;
            selectedPes.add(pe);
            if (!peIterator.hasNext()) break;
            pe = peIterator.next();
        }
        return selectedPes;
    }

    @Override
    public boolean allocatePesForVmInternal(Vm vm, List<Double> requestedMips) {
        List<Pe> selectedPes = this.getTotalCapacityToBeAllocatedToVm(requestedMips);
        if (selectedPes.size() < requestedMips.size()) {
            return false;
        }
        this.getAllocatedMipsMap().put(vm, requestedMips);
        return true;
    }

    @Override
    protected void deallocatePesFromVmInternal(Vm vm, int pesToRemove) {
        this.removePesFromMap(vm, this.getAllocatedMipsMap(), pesToRemove);
    }
}

