/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerTimeShared;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmSchedulerTimeSharedOverSubscription
extends VmSchedulerTimeShared {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VmSchedulerTimeSharedOverSubscription.class.getSimpleName());

    public VmSchedulerTimeSharedOverSubscription() {
        this(0.1);
    }

    public VmSchedulerTimeSharedOverSubscription(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    protected boolean isSuitableForVmInternal(Vm vm, List<Double> requestedMips) {
        return this.getHost().getWorkingPesNumber() >= requestedMips.size();
    }

    @Override
    protected void allocateMipsShareForVm(Vm vm, List<Double> requestedMipsReduced) {
        if (requestedMipsReduced.isEmpty()) {
            return;
        }
        double totalRequestedMips = requestedMipsReduced.get(0) * (double)requestedMipsReduced.size();
        if (this.getTotalAvailableMips() >= totalRequestedMips) {
            super.allocateMipsShareForVm(vm, requestedMipsReduced);
            return;
        }
        this.redistributeMipsDueToOverSubscription();
    }

    private void redistributeMipsDueToOverSubscription() {
        Map<Vm, List<Double>> mipsMapRequestedReduced = this.getNewTotalRequestedMipsByAllVms();
        double scalingFactor = this.getVmsMipsScalingFactor(mipsMapRequestedReduced);
        this.getAllocatedMipsMap().clear();
        for (Map.Entry<Vm, List<Double>> entry : mipsMapRequestedReduced.entrySet()) {
            Vm vm = entry.getKey();
            List<Double> updatedMipsAllocation = this.getMipsShareToAllocate(vm, entry.getValue());
            updatedMipsAllocation = this.getMipsShareToAllocate(updatedMipsAllocation, scalingFactor);
            this.getAllocatedMipsMap().put(vm, updatedMipsAllocation);
        }
    }

    private double getVmsMipsScalingFactor(Map<Vm, List<Double>> mipsMapRequestedReduced) {
        double totalMipsCapacity = this.getHost().getTotalMipsCapacity();
        double totalMipsToAllocateForAllVms = this.getTotalMipsToAllocateForAllVms(mipsMapRequestedReduced);
        return Math.min(1.0, totalMipsCapacity / totalMipsToAllocateForAllVms);
    }

    private Map<Vm, List<Double>> getNewTotalRequestedMipsByAllVms() {
        HashMap<Vm, List<Double>> mipsMapRequestedReduced = new HashMap<Vm, List<Double>>(this.getRequestedMipsMap().entrySet().size());
        for (Map.Entry<Vm, List<Double>> entry : this.getRequestedMipsMap().entrySet()) {
            Vm vm = entry.getKey();
            List<Double> requestedMipsReduced = this.getMipsShareRequestedReduced(entry.getKey(), entry.getValue());
            mipsMapRequestedReduced.put(vm, requestedMipsReduced);
        }
        return mipsMapRequestedReduced;
    }

    private double getTotalMipsToAllocateForAllVms(Map<Vm, List<Double>> mipsMapRequestedReduced) {
        return mipsMapRequestedReduced.entrySet().stream().mapToDouble(this::getMipsToBeAllocatedForVmPes).sum();
    }

    private double getMipsToBeAllocatedForVmPes(Map.Entry<Vm, List<Double>> entry) {
        double requiredMipsByThisVm = entry.getValue().stream().reduce(0.0, Double::sum);
        if (this.getHost().getVmsMigratingIn().contains(entry.getKey())) {
            return requiredMipsByThisVm * this.getVmMigrationCpuOverhead();
        }
        return requiredMipsByThisVm;
    }
}

