/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.utilizationmodels;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelPlanetLab
extends UtilizationModelAbstract {
    private UnaryOperator<Double> mapper;
    public static final int DEF_DATA_SAMPLES = 288;
    public static final int DEF_SCHEDULING_INTERVAL = 300;
    private double schedulingInterval;
    private final double[] utilization;

    public static UtilizationModelPlanetLab getInstance(String workloadFilePath) {
        return UtilizationModelPlanetLab.getInstance(workloadFilePath, 300.0);
    }

    public static UtilizationModelPlanetLab getInstance(String workloadFilePath, double schedulingInterval) {
        return new UtilizationModelPlanetLab(UtilizationModelPlanetLab.newReader(workloadFilePath), schedulingInterval, -1);
    }

    public static UtilizationModelPlanetLab getInstance(String workloadFilePath, UnaryOperator<Double> mapper) throws NumberFormatException {
        return new UtilizationModelPlanetLab(UtilizationModelPlanetLab.newReader(workloadFilePath), 300.0, -1, mapper);
    }

    private static InputStreamReader newReader(String workloadFilePath) {
        return ResourceLoader.newInputStreamReader(workloadFilePath, UtilizationModelPlanetLab.class);
    }

    public UtilizationModelPlanetLab(String workloadFilePath, double schedulingInterval) throws NumberFormatException {
        this(workloadFilePath, schedulingInterval, -1);
    }

    public UtilizationModelPlanetLab(String workloadFilePath, UnaryOperator<Double> mapper) throws NumberFormatException {
        this(UtilizationModelPlanetLab.newReader(workloadFilePath), 300.0, -1, mapper);
    }

    public UtilizationModelPlanetLab(String workloadFilePath, double schedulingInterval, int dataSamples) throws NumberFormatException {
        this(UtilizationModelPlanetLab.newReader(workloadFilePath), schedulingInterval, dataSamples);
    }

    private UtilizationModelPlanetLab(InputStreamReader sreader, double schedulingInterval, int dataSamples) throws NumberFormatException {
        this(sreader, schedulingInterval, dataSamples, UnaryOperator.identity());
    }

    private UtilizationModelPlanetLab(InputStreamReader sreader, double schedulingInterval, int dataSamples, UnaryOperator<Double> mapper) throws NumberFormatException {
        this.setSchedulingInterval(schedulingInterval);
        this.mapper = Objects.requireNonNull(mapper);
        this.utilization = this.readWorkloadFile(sreader, dataSamples);
    }

    private double[] readWorkloadFile(InputStreamReader sreader, int dataSamples) {
        Objects.requireNonNull(sreader);
        double[] utilization = new double[]{0.0};
        try (BufferedReader reader = new BufferedReader(sreader);){
            String line;
            int lineNum = 0;
            while ((line = reader.readLine()) != null && lineNum < utilization.length) {
                if (lineNum == 0) {
                    dataSamples = this.parseDataSamples(line, dataSamples);
                    utilization = this.createEmptyArray(dataSamples);
                }
                if (this.isComment(line)) continue;
                utilization[lineNum++] = Math.min((Double)this.mapper.apply(Double.parseDouble(line) / 100.0), 1.0);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return utilization;
    }

    private int parseDataSamples(String line, int dataSamples) {
        if (dataSamples < 0) {
            dataSamples = this.isComment(line) ? MathUtil.parseInt(line.substring(1), 288) : 288;
        }
        return Math.max(2, dataSamples);
    }

    public int getDataSamples() {
        return this.utilization.length;
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }

    private double[] createEmptyArray(int size) {
        double[] data = new double[size];
        for (int i = 0; i < size; ++i) {
            data[i] = 0.0;
        }
        return data;
    }

    @Override
    public double getUtilization(double time) {
        if ((double)Math.round(time) % this.getSchedulingInterval() == 0.0) {
            return this.utilization[(int)this.getUtilizationIndex(time)];
        }
        int prevIndex = this.getPrevUtilizationIndex(time);
        int nextIndex = this.getNextUtilizationIndex(time);
        return (this.utilization[prevIndex] + this.utilization[nextIndex]) / 2.0;
    }

    private double getUtilizationIndex(double time) {
        return time / this.schedulingInterval % (double)this.utilization.length;
    }

    private int getPrevUtilizationIndex(double time) {
        return (int)Math.floor(this.getUtilizationIndex(time));
    }

    private int getNextUtilizationIndex(double time) {
        return (int)Math.ceil(this.getUtilizationIndex(time)) % this.utilization.length;
    }

    protected final int getIntervalSize(int startIndex, int endIndex) {
        int index = endIndex - startIndex;
        return index >= 0 ? index : this.utilization.length - startIndex + endIndex;
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    public final void setSchedulingInterval(double schedulingInterval) {
        if (schedulingInterval <= 0.0) {
            throw new IllegalArgumentException("Scheduling interval must greater than 0. The given value is " + schedulingInterval);
        }
        this.schedulingInterval = schedulingInterval;
    }
}

