/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudsimplus.testbeds.Experiment;
import org.cloudsimplus.util.Log;

public abstract class ExperimentRunner<T extends Experiment>
implements Runnable {
    private boolean verbose;
    private long baseSeed;
    private List<Long> seeds = new ArrayList<Long>();
    private int simulationRuns;
    private long experimentsStartTime;
    private long experimentsFinishTime;
    private boolean applyAntitheticVariatesTechnique;
    private int numberOfBatches;

    public ExperimentRunner(boolean antitheticVariatesTechnique) {
        this(antitheticVariatesTechnique, System.currentTimeMillis());
    }

    public ExperimentRunner(boolean antitheticVariatesTechnique, long baseSeed) {
        this.setBaseSeed(baseSeed);
        this.setNumberOfBatches(0);
        this.setApplyAntitheticVariatesTechnique(antitheticVariatesTechnique);
    }

    protected abstract void setup();

    private void setupInternal() {
        if (this.isApplyBatchMeansMethod() || this.isApplyAntitheticVariatesTechnique()) {
            this.setSimulationRunsAndBatchesToEvenNumber();
        }
        if (this.isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches()) {
            this.setNumberOfSimulationRunsAsMultipleOfNumberOfBatches();
        }
        this.setup();
        this.seeds = new ArrayList<Long>(this.getSimulationRuns());
    }

    private void setSimulationRunsAndBatchesToEvenNumber() {
        if (this.getSimulationRuns() % 2 != 0) {
            this.setSimulationRuns(this.getSimulationRuns() + 1);
        }
        if (this.getSimulationRuns() % this.getNumberOfBatches() != 0) {
            this.setSimulationRunsAsMultipleOfBatchNumber();
        }
    }

    private void setNumberOfSimulationRunsAsMultipleOfNumberOfBatches() {
        this.setSimulationRuns(this.batchSizeCeil() * this.getNumberOfBatches());
    }

    private boolean isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches() {
        return this.isApplyBatchMeansMethod() && this.getSimulationRuns() % this.getNumberOfBatches() != 0;
    }

    public int batchSizeCeil() {
        return (int)Math.ceil((double)this.getSimulationRuns() / (double)this.getNumberOfBatches());
    }

    public boolean simulationRunsAndNumberOfBatchesAreCompatible() {
        boolean batchesGreaterThan1 = this.getNumberOfBatches() > 1;
        boolean numSimulationRunsGraterThanBatches = this.getSimulationRuns() > this.getNumberOfBatches();
        return batchesGreaterThan1 && numSimulationRunsGraterThanBatches;
    }

    public boolean isApplyBatchMeansMethod() {
        return this.simulationRunsAndNumberOfBatchesAreCompatible();
    }

    protected List<Double> computeBatchMeans(List<Double> samples) {
        if (!this.isApplyBatchMeansMethod()) {
            return samples;
        }
        ArrayList<Double> batchMeans = new ArrayList<Double>(this.getNumberOfBatches());
        for (int i = 0; i < this.getNumberOfBatches(); ++i) {
            batchMeans.add(this.getBatchAverage(samples, i));
        }
        System.out.printf("\tBatch Means Method applied. The number of samples was reduced to %d after computing the mean for each batch.%n", this.getNumberOfBatches());
        return batchMeans;
    }

    private double getBatchAverage(List<Double> samples, int i) {
        int k = this.batchSizeCeil();
        return IntStream.range(0, k).mapToDouble(j -> (Double)samples.get(this.getBatchElementIndex(i, j))).average().orElse(0.0);
    }

    private int getBatchElementIndex(int i, int j) {
        int k = this.batchSizeCeil();
        return i * k + j;
    }

    protected double computeConfidenceErrorMargin(SummaryStatistics stats, double confidenceLevel) {
        try {
            double degreesOfFreedom = stats.getN() - 1L;
            TDistribution tDist = new TDistribution(degreesOfFreedom);
            double significance = 1.0 - confidenceLevel;
            double criticalValue = tDist.inverseCumulativeProbability(1.0 - significance / 2.0);
            System.out.printf("%n\tt-Distribution critical value for %d samples: %f%n", stats.getN(), criticalValue);
            return criticalValue * stats.getStandardDeviation() / Math.sqrt(stats.getN());
        }
        catch (MathIllegalArgumentException e) {
            return Double.NaN;
        }
    }

    public boolean isApplyAntitheticVariatesTechnique() {
        return this.applyAntitheticVariatesTechnique;
    }

    public int getSimulationRuns() {
        return this.simulationRuns;
    }

    protected ExperimentRunner setSimulationRuns(int simulationRuns) {
        this.simulationRuns = simulationRuns;
        return this;
    }

    protected ExperimentRunner setSimulationRunsAsMultipleOfBatchNumber() {
        this.setSimulationRuns(this.getNumberOfBatches() * (int)Math.ceil(this.getSimulationRuns() / this.getNumberOfBatches()));
        return this;
    }

    private ExperimentRunner setApplyAntitheticVariatesTechnique(boolean applyAntitheticVariatesTechnique) {
        this.applyAntitheticVariatesTechnique = applyAntitheticVariatesTechnique;
        return this;
    }

    public int getNumberOfBatches() {
        return this.numberOfBatches;
    }

    public final ExperimentRunner setNumberOfBatches(int numberOfBatches) {
        this.numberOfBatches = numberOfBatches;
        return this;
    }

    public long getBaseSeed() {
        return this.baseSeed;
    }

    long getSeed(int experimentIndex) {
        return this.seeds.get(experimentIndex);
    }

    public ContinuousDistribution createRandomGen(int experimentIndex) {
        return this.createRandomGen(experimentIndex, 0.0, 1.0);
    }

    public ContinuousDistribution createRandomGen(int experimentIndex, double minInclusive, double maxExclusive) {
        if (this.seeds.isEmpty()) {
            throw new IllegalStateException("You have to create at least 1 SimulationExperiment before requesting a ExperimentRunner to create a pseudo random number generator (PRNG)!");
        }
        if (this.isToReuseSeedFromFirstHalfOfExperiments(experimentIndex)) {
            int expIndexFromFirstHalf = experimentIndex - this.halfSimulationRuns();
            return new UniformDistr(minInclusive, maxExclusive, this.seeds.get(expIndexFromFirstHalf)).setApplyAntitheticVariates(true);
        }
        return new UniformDistr(minInclusive, maxExclusive, this.seeds.get(experimentIndex));
    }

    public boolean isToReuseSeedFromFirstHalfOfExperiments(int currentExperimentIndex) {
        return this.isApplyAntitheticVariatesTechnique() && this.simulationRuns > 1 && currentExperimentIndex >= this.halfSimulationRuns();
    }

    void addSeed(long seed) {
        if (!this.seeds.contains(seed)) {
            this.seeds.add(seed);
        }
    }

    public int halfSimulationRuns() {
        return this.simulationRuns / 2;
    }

    public long getExperimentsFinishTime() {
        return this.experimentsFinishTime;
    }

    public long getExperimentsStartTime() {
        return this.experimentsStartTime;
    }

    @Override
    public void run() {
        this.setupInternal();
        this.printSimulationParameters();
        Log.setLevel(Level.OFF);
        try {
            this.experimentsStartTime = System.currentTimeMillis();
            for (int i = 0; i < this.getSimulationRuns(); ++i) {
                if (this.isVerbose()) {
                    System.out.print((i + 1) % 100 == 0 ? String.format(". Run #%d%n", i + 1) : ".");
                }
                ((Experiment)this.createExperiment(i)).run();
            }
            System.out.println();
            this.experimentsFinishTime = (System.currentTimeMillis() - this.experimentsStartTime) / 1000L;
        }
        finally {
            Log.setLevel(Level.INFO);
        }
        Map<String, List<Double>> metricsMap = this.createMetricsMap();
        System.out.printf("%n------------------------------------------------------------------%n", new Object[0]);
        metricsMap.entrySet().forEach(this::computeAndPrintFinalResults);
        System.out.printf("%nExperiments finished in %d seconds!%n", this.getExperimentsFinishTime());
    }

    protected abstract Map<String, List<Double>> createMetricsMap();

    protected abstract T createExperiment(int var1);

    protected List<Double> computeAntitheticMeans(List<Double> samples) {
        if (!this.isApplyAntitheticVariatesTechnique()) {
            return samples;
        }
        int half = samples.size() / 2;
        ArrayList<Double> antitheticMeans = new ArrayList<Double>(half);
        for (int i = 0; i < half; ++i) {
            antitheticMeans.add((samples.get(i) + samples.get(half + i)) / 2.0);
        }
        System.out.printf("\tAntithetic Variates Technique applied. The number of samples was reduced to the half (%d).%n", half);
        return antitheticMeans;
    }

    protected abstract void printSimulationParameters();

    protected SummaryStatistics computeFinalStatistics(List<Double> values) {
        SummaryStatistics stats = new SummaryStatistics();
        values = this.computeBatchMeans(values);
        values = this.computeAntitheticMeans(values);
        values.forEach(arg_0 -> ((SummaryStatistics)stats).addValue(arg_0));
        return stats;
    }

    private void computeAndPrintFinalResults(Map.Entry<String, List<Double>> metricEntry) {
        this.printFinalResults(metricEntry.getKey(), this.computeFinalStatistics(metricEntry.getValue()));
    }

    protected abstract void printFinalResults(String var1, SummaryStatistics var2);

    public final ExperimentRunner setBaseSeed(long baseSeed) {
        this.baseSeed = baseSeed;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ExperimentRunner setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }
}

