/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicyNull;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VmAllocationPolicy {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)VmAllocationPolicy.class.getSimpleName());
    public static final int DEF_HOST_COUNT_FOR_PARALLEL_SEARCH = 20000;
    public static final VmAllocationPolicy NULL = new VmAllocationPolicyNull();

    public Datacenter getDatacenter();

    public void setDatacenter(Datacenter var1);

    public boolean allocateHostForVm(Vm var1);

    public boolean allocateHostForVm(Vm var1, Host var2);

    public boolean scaleVmVertically(VerticalVmScaling var1);

    public void deallocateHostForVm(Vm var1);

    public void setFindHostForVmFunction(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> var1);

    public <T extends Host> List<T> getHostList();

    public Map<Vm, Host> getOptimizedAllocationMap(List<? extends Vm> var1);

    public Optional<Host> findHostForVm(Vm var1);

    public boolean isVmMigrationSupported();

    default public boolean isParallelHostSearchEnabled() {
        return this.getHostList().size() >= this.getHostCountForParallelSearch();
    }

    public int getHostCountForParallelSearch();

    public void setHostCountForParallelSearch(int var1);
}

