/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletSimple;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.CustomerEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.CloudSimEvent;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.datacenters.TimeZoned;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmGroup;
import org.cloudbus.cloudsim.vms.VmSimple;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.listeners.DatacenterBrokerEventInfo;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public abstract class DatacenterBrokerAbstract
extends CloudSimEntity
implements DatacenterBroker {
    private boolean selectClosestDatacenter;
    private static final Function<Vm, Double> DEF_VM_DESTRUCTION_DELAY_FUNCTION = vm -> -1.0;
    private final List<EventListener<DatacenterBrokerEventInfo>> onVmsCreatedListeners;
    private Vm lastSelectedVm;
    private Datacenter lastSelectedDc;
    private boolean retryFailedVms;
    private final List<Vm> vmFailedList;
    private final List<Vm> vmWaitingList;
    private final List<Vm> vmExecList;
    private final List<Vm> vmCreatedList;
    private final List<Cloudlet> cloudletWaitingList;
    private final List<Cloudlet> cloudletSubmittedList;
    private final List<Cloudlet> cloudletsFinishedList;
    private final List<Cloudlet> cloudletsCreatedList;
    private boolean wereThereWaitingCloudlets;
    private BiFunction<Datacenter, Vm, Datacenter> datacenterMapper;
    private Function<Cloudlet, Vm> vmMapper;
    private Comparator<Vm> vmComparator;
    private Comparator<Cloudlet> cloudletComparator;
    private int vmCreationRequests;
    private int vmCreationAcks;
    private List<Datacenter> datacenterList;
    private Cloudlet lastSubmittedCloudlet;
    private Vm lastSubmittedVm;
    private Function<Vm, Double> vmDestructionDelayFunction;

    public DatacenterBrokerAbstract(CloudSim simulation, String name) {
        super(simulation);
        if (!name.isEmpty()) {
            this.setName(name);
        }
        this.onVmsCreatedListeners = new ArrayList<EventListener<DatacenterBrokerEventInfo>>();
        this.lastSubmittedCloudlet = Cloudlet.NULL;
        this.lastSubmittedVm = Vm.NULL;
        this.lastSelectedVm = Vm.NULL;
        this.lastSelectedDc = Datacenter.NULL;
        this.vmCreationRequests = 0;
        this.vmCreationAcks = 0;
        this.retryFailedVms = true;
        this.vmFailedList = new ArrayList<Vm>();
        this.vmWaitingList = new ArrayList<Vm>();
        this.vmExecList = new ArrayList<Vm>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.cloudletWaitingList = new ArrayList<Cloudlet>();
        this.cloudletsFinishedList = new ArrayList<Cloudlet>();
        this.cloudletsCreatedList = new ArrayList<Cloudlet>();
        this.cloudletSubmittedList = new ArrayList<Cloudlet>();
        this.setDatacenterList(new TreeSet<Datacenter>());
        this.setDatacenterMapper(this::defaultDatacenterMapper);
        this.setVmMapper(this::defaultVmMapper);
        this.vmDestructionDelayFunction = DEF_VM_DESTRUCTION_DELAY_FUNCTION;
    }

    @Override
    public final DatacenterBroker setSelectClosestDatacenter(boolean select) {
        this.selectClosestDatacenter = select;
        if (select) {
            this.setDatacenterMapper(this::closestDatacenterMapper);
        }
        return this;
    }

    @Override
    public boolean isSelectClosestDatacenter() {
        return this.selectClosestDatacenter;
    }

    @Override
    public DatacenterBroker submitVmList(List<? extends Vm> list, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        return this.submitVmList(list);
    }

    @Override
    public DatacenterBroker submitVmList(List<? extends Vm> list) {
        this.sortVmsIfComparatorIsSet(list);
        this.setBrokerForEntities(list);
        this.lastSubmittedVm = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedVm);
        this.vmWaitingList.addAll(list);
        if (this.isStarted() && !list.isEmpty()) {
            LOGGER.info("{}: {}: List of {} VMs submitted to the broker during simulation execution. VMs creation request sent to Datacenter.", new Object[]{this.getSimulation().clockStr(), this.getName(), list.size()});
            this.requestDatacenterToCreateWaitingVms(false);
        }
        return this;
    }

    private void setBrokerForEntities(List<? extends CustomerEntity> customerEntities) {
        for (CustomerEntity customerEntity : customerEntities) {
            customerEntity.setBroker(this);
            if (!(customerEntity instanceof VmGroup)) continue;
            this.setBrokerForEntities(((VmGroup)customerEntity).getVmList());
        }
    }

    private <T extends CustomerEntity> T setIdForEntitiesWithoutOne(List<? extends T> list, T lastSubmittedEntity) {
        return (T)((CustomerEntity)Simulation.setIdForEntitiesWithoutOne(list, lastSubmittedEntity));
    }

    private void sortVmsIfComparatorIsSet(List<? extends Vm> list) {
        if (this.vmComparator != null) {
            list.sort(this.vmComparator);
        }
    }

    @Override
    public DatacenterBroker submitVm(Vm vm) {
        Objects.requireNonNull(vm);
        if (vm == Vm.NULL) {
            return this;
        }
        ArrayList<Vm> newList = new ArrayList<Vm>(1);
        newList.add(vm);
        return this.submitVmList(newList);
    }

    @Override
    public DatacenterBroker submitCloudlet(Cloudlet cloudlet) {
        Objects.requireNonNull(cloudlet);
        if (cloudlet == Cloudlet.NULL) {
            return this;
        }
        ArrayList<Cloudlet> newList = new ArrayList<Cloudlet>(1);
        newList.add(cloudlet);
        return this.submitCloudletList(newList);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list, double submissionDelay) {
        return this.submitCloudletList(list, Vm.NULL, submissionDelay);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list, Vm vm) {
        return this.submitCloudletList(list, vm, -1.0);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list, Vm vm, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        this.bindCloudletsToVm(list, vm);
        return this.submitCloudletList(list);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list) {
        if (list.isEmpty()) {
            return this;
        }
        this.sortCloudletsIfComparatorIsSet(list);
        this.setBrokerForEntities(list);
        this.lastSubmittedCloudlet = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedCloudlet);
        this.cloudletSubmittedList.addAll(list);
        this.setSimulationForCloudletUtilizationModels(list);
        this.cloudletWaitingList.addAll(list);
        this.wereThereWaitingCloudlets = true;
        if (!this.isStarted()) {
            return this;
        }
        LOGGER.info("{}: {}: List of {} Cloudlets submitted to the broker during simulation execution.", new Object[]{this.getSimulation().clockStr(), this.getName(), list.size()});
        if (this.allNonDelayedVmsCreated()) {
            LOGGER.info("Cloudlets creation request sent to Datacenter.");
            this.requestDatacentersToCreateWaitingCloudlets();
            this.notifyOnVmsCreatedListeners();
        } else {
            LOGGER.info("Waiting creation of {} VMs to send Cloudlets creation request to Datacenter.", (Object)this.vmWaitingList.size());
        }
        return this;
    }

    private boolean allNonDelayedVmsCreated() {
        return this.vmWaitingList.stream().noneMatch(vm -> vm.getSubmissionDelay() == 0.0);
    }

    private void bindCloudletsToVm(List<? extends Cloudlet> cloudlets, Vm vm) {
        if (Vm.NULL.equals(vm)) {
            return;
        }
        cloudlets.forEach(c -> c.setVm(vm));
    }

    private void sortCloudletsIfComparatorIsSet(List<? extends Cloudlet> cloudlets) {
        if (this.cloudletComparator != null) {
            cloudlets.sort(this.cloudletComparator);
        }
    }

    private void setSimulationForCloudletUtilizationModels(List<? extends Cloudlet> cloudlets) {
        for (Cloudlet cloudlet : cloudlets) {
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelCpu());
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelBw());
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelRam());
        }
    }

    private void setSimulationForUtilizationModel(UtilizationModel cloudletUtilizationModel) {
        if (cloudletUtilizationModel.getSimulation() == null || cloudletUtilizationModel.getSimulation() == Simulation.NULL) {
            cloudletUtilizationModel.setSimulation(this.getSimulation());
        }
    }

    private void setDelayForEntitiesWithNoDelay(List<? extends CustomerEntity> entities, double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        entities.stream().filter(entity -> entity.getSubmissionDelay() <= 0.0).forEach(entity -> entity.setSubmissionDelay(submissionDelay));
    }

    @Override
    public boolean bindCloudletToVm(Cloudlet cloudlet, Vm vm) {
        if (!this.equals(cloudlet.getBroker())) {
            return false;
        }
        cloudlet.setVm(vm);
        return true;
    }

    @Override
    public void processEvent(SimEvent evt) {
        if (this.processCloudletEvents(evt) || this.processVmEvents(evt) || this.processGeneralEvents(evt)) {
            return;
        }
        LOGGER.trace("{}: {}: Unknown event {} received.", new Object[]{this.getSimulation().clockStr(), this, evt.getTag()});
    }

    private boolean processCloudletEvents(SimEvent evt) {
        switch (evt.getTag()) {
            case 15: {
                this.processCloudletReturn(evt);
                return true;
            }
            case 23: {
                this.processCloudletReady(evt);
                return true;
            }
            case 27: {
                ((Runnable)evt.getData()).run();
                return true;
            }
            case 19: {
                this.processCloudletPause(evt);
                return true;
            }
            case 18: {
                this.processCloudletCancel(evt);
                return true;
            }
            case -25: {
                this.processCloudletFinish(evt);
                return true;
            }
            case 24: {
                this.processCloudletFail(evt);
                return true;
            }
        }
        return false;
    }

    private boolean processVmEvents(SimEvent evt) {
        switch (evt.getTag()) {
            case 32: {
                this.processVmCreateResponseFromDatacenter(evt);
                return true;
            }
            case 42: {
                this.requestVmVerticalScaling(evt);
                return true;
            }
        }
        return false;
    }

    private boolean processGeneralEvents(SimEvent evt) {
        if (evt.getTag() == 4) {
            this.processDatacenterListRequest(evt);
            return true;
        }
        if (evt.getTag() == -1) {
            this.shutdownEntity();
            return true;
        }
        return false;
    }

    private void processCloudletReady(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        if (cloudlet.getStatus() == Cloudlet.Status.PAUSED) {
            this.logCloudletStatusChange(cloudlet, "resume execution of");
        } else {
            this.logCloudletStatusChange(cloudlet, "start executing");
        }
        cloudlet.getVm().getCloudletScheduler().cloudletReady(cloudlet);
    }

    private void processCloudletPause(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "de-schedule (pause)");
        cloudlet.getVm().getCloudletScheduler().cloudletPause(cloudlet);
    }

    private void processCloudletCancel(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "cancel execution of");
        cloudlet.getVm().getCloudletScheduler().cloudletCancel(cloudlet);
    }

    private void processCloudletFinish(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "finish running");
        if (cloudlet.getFinishedLengthSoFar() == 0L) {
            this.updateHostProcessing(cloudlet);
        }
        if (cloudlet.getFinishedLengthSoFar() == 0L) {
            cloudlet.getVm().getCloudletScheduler().cloudletFail(cloudlet);
            return;
        }
        long prevLength = cloudlet.getLength();
        cloudlet.setLength(cloudlet.getFinishedLengthSoFar());
        this.updateHostProcessing(cloudlet);
        if (prevLength < 0L) {
            double delay = cloudlet.getSimulation().getMinTimeBetweenEvents();
            Datacenter dc = cloudlet.getVm().getHost().getDatacenter();
            dc.schedule(delay, 41);
        }
    }

    private void updateHostProcessing(Cloudlet cloudlet) {
        cloudlet.getVm().getHost().updateProcessing(this.getSimulation().clock());
    }

    private void logCloudletStatusChange(Cloudlet cloudlet, String status) {
        String msg = cloudlet.getJobId() > 0L ? String.format("(job %d) ", cloudlet.getJobId()) : "";
        LOGGER.info("{}: {}: Request to {} {} {}received.", new Object[]{this.getSimulation().clockStr(), this, status, cloudlet, msg});
    }

    private void processCloudletFail(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        cloudlet.getVm().getCloudletScheduler().cloudletFail(cloudlet);
    }

    private void requestVmVerticalScaling(SimEvent evt) {
        if (!(evt.getData() instanceof VerticalVmScaling)) {
            return;
        }
        VerticalVmScaling scaling = (VerticalVmScaling)evt.getData();
        this.getSimulation().sendNow(evt.getSource(), scaling.getVm().getHost().getDatacenter(), 42, scaling);
    }

    private void processDatacenterListRequest(SimEvent evt) {
        this.setDatacenterList((Set)evt.getData());
        LOGGER.info("{}: {}: List of {} datacenters(s) received.", new Object[]{this.getSimulation().clockStr(), this.getName(), this.datacenterList.size()});
        this.requestDatacenterToCreateWaitingVms(false);
    }

    private boolean processVmCreateResponseFromDatacenter(SimEvent evt) {
        Vm vm = (Vm)evt.getData();
        ++this.vmCreationAcks;
        if (vm.isCreated()) {
            this.processSuccessVmCreationInDatacenter(vm);
        } else {
            vm.setFailed(true);
            if (!this.retryFailedVms) {
                this.vmWaitingList.remove(vm);
                this.vmFailedList.add(vm);
                LOGGER.warn("{}: {}: {} has been moved to the failed list because creation retry is not enabled.", new Object[]{this.getSimulation().clockStr(), this.getName(), vm});
            }
            vm.notifyOnCreationFailureListeners(this.lastSelectedDc);
        }
        if (this.allNonDelayedVmsCreated()) {
            this.requestDatacentersToCreateWaitingCloudlets();
            this.notifyOnVmsCreatedListeners();
        } else if (this.vmCreationRequests == this.vmCreationAcks) {
            this.requestCreationOfWaitingVmsToFallbackDatacenter();
        }
        return vm.isCreated();
    }

    private void notifyOnVmsCreatedListeners() {
        for (int i = 0; i < this.onVmsCreatedListeners.size(); ++i) {
            EventListener<DatacenterBrokerEventInfo> listener = this.onVmsCreatedListeners.get(i);
            listener.update(DatacenterBrokerEventInfo.of(listener, this));
        }
    }

    private void requestCreationOfWaitingVmsToFallbackDatacenter() {
        this.lastSelectedDc = Datacenter.NULL;
        if (this.requestDatacenterToCreateWaitingVms(true)) {
            return;
        }
        if (this.vmExecList.isEmpty()) {
            LOGGER.error("{}: {}: None of the requested {} VMs could be created because suitable Hosts weren't found in any available Datacenter. Shutting broker down...", new Object[]{this.getSimulation().clockStr(), this.getName(), this.vmWaitingList.size()});
            this.shutdownEntity();
            return;
        }
        LOGGER.error("{}: {}: {} of the requested {} VMs couldn't be created because suitable Hosts weren't found in any available Datacenter.", new Object[]{this.getSimulation().clockStr(), this.getName(), this.vmWaitingList.size(), this.getVmsNumber()});
        this.requestDatacentersToCreateWaitingCloudlets();
    }

    private boolean requestDatacenterToCreateWaitingVms(boolean isFallbackDatacenter) {
        for (Vm vm : this.vmWaitingList) {
            this.lastSelectedDc = isFallbackDatacenter && this.selectClosestDatacenter ? this.defaultDatacenterMapper(this.lastSelectedDc, vm) : this.datacenterMapper.apply(this.lastSelectedDc, vm);
            this.vmCreationRequests += this.requestVmCreation(this.lastSelectedDc, isFallbackDatacenter, vm);
        }
        return this.lastSelectedDc != Datacenter.NULL;
    }

    private int getVmsNumber() {
        return this.vmCreatedList.size() + this.vmWaitingList.size();
    }

    private void processSuccessVmCreationInDatacenter(Vm vm) {
        if (vm instanceof VmGroup) {
            int createdVms = 0;
            VmGroup vmGroup = (VmGroup)vm;
            for (Vm nextVm : vmGroup.getVmList()) {
                if (!nextVm.isCreated()) continue;
                this.processSuccessVmCreationInDatacenter(nextVm);
                ++createdVms;
            }
            if (createdVms == vmGroup.size()) {
                this.vmWaitingList.remove(vmGroup);
            }
            return;
        }
        this.vmWaitingList.remove(vm);
        this.vmExecList.add(vm);
        this.vmCreatedList.add(vm);
    }

    private void processCloudletReturn(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.cloudletsFinishedList.add(cloudlet);
        ((VmSimple)cloudlet.getVm()).addExpectedFreePesNumber(cloudlet.getNumberOfPes());
        LOGGER.info("{}: {}: {} finished in {} and returned to broker.", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, cloudlet.getVm()});
        if (cloudlet.getVm().getCloudletScheduler().isEmpty()) {
            this.requestIdleVmDestruction(cloudlet.getVm());
            return;
        }
        this.requestVmDestructionAfterAllCloudletsFinished();
    }

    private void requestVmDestructionAfterAllCloudletsFinished() {
        for (int i = this.vmExecList.size() - 1; i >= 0; --i) {
            this.requestIdleVmDestruction(this.vmExecList.get(i));
        }
        if (this.cloudletWaitingList.isEmpty()) {
            return;
        }
        this.requestDatacenterToCreateWaitingVms(false);
    }

    @Override
    public DatacenterBroker requestIdleVmDestruction(Vm vm) {
        double delay = this.vmDestructionDelayFunction.apply(vm);
        if (vm.isCreated()) {
            if (delay > -1.0 && vm.isIdleEnough(delay) || this.isFinished()) {
                LOGGER.info("{}: {}: Requesting {} destruction.", new Object[]{this.getSimulation().clockStr(), this.getName(), vm});
                this.sendNow(this.getDatacenter(vm), 33, vm);
            }
            if (this.isVmIdlenessVerificationRequired((VmSimple)vm)) {
                this.getSimulation().send(new CloudSimEvent(this.vmDestructionDelayFunction.apply(vm), vm.getHost().getDatacenter(), 41));
                return this;
            }
        }
        if (this.isTimeToShutdownBroker() && this.isBrokerIdle()) {
            this.shutdownEntity();
        }
        return this;
    }

    @Override
    public List<Cloudlet> destroyVm(Vm vm) {
        if (vm.isCreated()) {
            ArrayList<Cloudlet> cloudletsAffected = new ArrayList<Cloudlet>();
            Iterator<Cloudlet> it = this.cloudletSubmittedList.iterator();
            while (it.hasNext()) {
                Cloudlet cloudlet = it.next();
                if (!cloudlet.getVm().equals(vm) || cloudlet.isFinished()) continue;
                cloudlet.setVm(Vm.NULL);
                cloudletsAffected.add(cloudlet.reset());
                it.remove();
            }
            vm.getHost().destroyVm(vm);
            vm.getCloudletScheduler().clear();
            return cloudletsAffected;
        }
        LOGGER.warn("Vm: " + vm.getId() + " does not belong to this broker! Broker: " + this.toString());
        return new ArrayList<Cloudlet>();
    }

    private boolean isVmIdlenessVerificationRequired(VmSimple vm) {
        if (vm.hasStartedSomeCloudlet() && vm.getCloudletScheduler().isEmpty()) {
            int schedulingInterval = (int)vm.getHost().getDatacenter().getSchedulingInterval();
            int delay = this.vmDestructionDelayFunction.apply(vm).intValue();
            return (double)delay > -1.0 && (schedulingInterval <= 0 || delay % schedulingInterval != 0);
        }
        return false;
    }

    private boolean isTimeToShutdownBroker() {
        return this.isAlive() && (!this.getSimulation().isTerminationTimeSet() || this.getSimulation().isTimeToTerminateSimulationUnderRequest());
    }

    private boolean isBrokerIdle() {
        return this.cloudletWaitingList.isEmpty() && this.vmWaitingList.isEmpty() && this.vmExecList.isEmpty();
    }

    private int requestVmCreation(Datacenter datacenter, boolean isFallbackDatacenter, Vm vm) {
        if (datacenter == Datacenter.NULL || datacenter.equals(vm.getLastTriedDatacenter())) {
            return 0;
        }
        this.logVmCreationRequest(datacenter, isFallbackDatacenter, vm);
        this.send(datacenter, vm.getSubmissionDelay(), 32, vm);
        vm.setLastTriedDatacenter(datacenter);
        return 1;
    }

    private void logVmCreationRequest(Datacenter datacenter, boolean isFallbackDatacenter, Vm vm) {
        String fallbackMsg;
        String string = fallbackMsg = isFallbackDatacenter ? " (due to lack of a suitable Host in previous one)" : "";
        if (vm.getSubmissionDelay() == 0.0) {
            LOGGER.info("{}: {}: Trying to create {} in {}{}", new Object[]{this.getSimulation().clockStr(), this.getName(), vm, datacenter.getName(), fallbackMsg});
        } else {
            LOGGER.info("{}: {}: Creation of {} in {}{} will be requested in {} seconds", new Object[]{this.getSimulation().clockStr(), this.getName(), vm, datacenter.getName(), fallbackMsg, vm.getSubmissionDelay()});
        }
    }

    protected void requestDatacentersToCreateWaitingCloudlets() {
        Iterator<Cloudlet> it = this.cloudletWaitingList.iterator();
        while (it.hasNext()) {
            CloudletSimple cloudlet = (CloudletSimple)it.next();
            if (!cloudlet.getLastTriedDatacenter().equals(Datacenter.NULL)) continue;
            this.lastSelectedVm = this.vmMapper.apply(cloudlet);
            if (!this.lastSelectedVm.isCreated()) {
                this.logPostponingCloudletExecution(cloudlet);
                continue;
            }
            ((VmSimple)this.lastSelectedVm).removeExpectedFreePesNumber(cloudlet.getNumberOfPes());
            this.logCloudletCreationRequest(cloudlet);
            cloudlet.setVm(this.lastSelectedVm);
            this.send(this.getDatacenter(this.lastSelectedVm), cloudlet.getSubmissionDelay(), 16, cloudlet);
            cloudlet.setLastTriedDatacenter(this.getDatacenter(this.lastSelectedVm));
            this.cloudletsCreatedList.add(cloudlet);
            it.remove();
        }
        this.allWaitingCloudletsSubmittedToVm();
    }

    private void logPostponingCloudletExecution(Cloudlet cloudlet) {
        String vmMsg = cloudlet.getVm() == Vm.NULL ? "it couldn't be mapped to any VM" : String.format("bind Vm %d is not available", cloudlet.getVm().getId());
        String msg = String.format("%s: %s: Postponing execution of Cloudlet %d because {}.", this.getSimulation().clockStr(), this.getName(), cloudlet.getId());
        if (cloudlet.getVm().getSubmissionDelay() > 0.0) {
            LOGGER.info(msg, (Object)String.format("bind Vm %d was requested to be created with some delay", cloudlet.getVm().getId()));
        } else {
            LOGGER.warn(msg, (Object)vmMsg);
        }
    }

    private void logCloudletCreationRequest(Cloudlet cloudlet) {
        String delayMsg = cloudlet.getSubmissionDelay() > 0.0 ? String.format(" with a requested delay of %.0f seconds", cloudlet.getSubmissionDelay()) : "";
        LOGGER.info("{}: {}: Sending Cloudlet {} to {} in {}{}.", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet.getId(), this.lastSelectedVm, this.lastSelectedVm.getHost(), delayMsg});
    }

    private boolean allWaitingCloudletsSubmittedToVm() {
        if (!this.cloudletWaitingList.isEmpty()) {
            return false;
        }
        if (this.wereThereWaitingCloudlets) {
            LOGGER.info("{}: {}: All waiting Cloudlets submitted to some VM.", (Object)this.getSimulation().clockStr(), (Object)this.getName());
            this.wereThereWaitingCloudlets = false;
        }
        return true;
    }

    @Override
    public void shutdownEntity() {
        super.shutdownEntity();
        LOGGER.info("{}: {} is shutting down...", (Object)this.getSimulation().clockStr(), (Object)this.getName());
        this.requestVmDestructionAfterAllCloudletsFinished();
    }

    @Override
    public void startEntity() {
        LOGGER.info("{} is starting...", (Object)this.getName());
        this.schedule(this.getSimulation().getCloudInfoService(), 0.0, 4);
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return this.vmCreatedList;
    }

    @Override
    public <T extends Vm> List<T> getVmExecList() {
        return this.vmExecList;
    }

    @Override
    public <T extends Vm> List<T> getVmWaitingList() {
        return this.vmWaitingList;
    }

    @Override
    public Vm getWaitingVm(int index) {
        if (index >= 0 && index < this.vmWaitingList.size()) {
            return this.vmWaitingList.get(index);
        }
        return Vm.NULL;
    }

    @Override
    public List<Cloudlet> getCloudletCreatedList() {
        return this.cloudletsCreatedList;
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletWaitingList() {
        return this.cloudletWaitingList;
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletFinishedList() {
        return new ArrayList<Cloudlet>(this.cloudletsFinishedList);
    }

    protected Vm getVmFromCreatedList(int vmIndex) {
        return vmIndex >= 0 && vmIndex < this.vmExecList.size() ? this.vmExecList.get(vmIndex) : Vm.NULL;
    }

    protected int getVmCreationRequests() {
        return this.vmCreationRequests;
    }

    protected int getVmCreationAcks() {
        return this.vmCreationAcks;
    }

    protected List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    private void setDatacenterList(Set<Datacenter> datacenterList) {
        this.datacenterList = new ArrayList<Datacenter>(datacenterList);
        if (this.selectClosestDatacenter) {
            this.datacenterList.sort(Comparator.comparingDouble(TimeZoned::getTimeZone));
        }
    }

    protected Datacenter getDatacenter(Vm vm) {
        return vm.getHost().getDatacenter();
    }

    @Override
    public final DatacenterBroker setDatacenterMapper(BiFunction<Datacenter, Vm, Datacenter> datacenterMapper) {
        this.datacenterMapper = Objects.requireNonNull(datacenterMapper);
        return this;
    }

    @Override
    public final DatacenterBroker setVmMapper(Function<Cloudlet, Vm> vmMapper) {
        this.vmMapper = Objects.requireNonNull(vmMapper);
        return this;
    }

    @Override
    public DatacenterBroker setVmComparator(Comparator<Vm> comparator) {
        this.vmComparator = comparator;
        return this;
    }

    @Override
    public void setCloudletComparator(Comparator<Cloudlet> comparator) {
        this.cloudletComparator = comparator;
    }

    @Override
    public DatacenterBroker addOnVmsCreatedListener(EventListener<DatacenterBrokerEventInfo> listener) {
        this.onVmsCreatedListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public DatacenterBroker removeOnVmsCreatedListener(EventListener<? extends EventInfo> listener) {
        this.onVmsCreatedListeners.remove(Objects.requireNonNull(listener));
        return this;
    }

    public String toString() {
        return "Broker " + this.getId();
    }

    @Override
    public Function<Vm, Double> getVmDestructionDelayFunction() {
        return this.vmDestructionDelayFunction;
    }

    @Override
    public DatacenterBroker setVmDestructionDelay(double delay) {
        this.setVmDestructionDelayFunction(vm -> delay);
        return this;
    }

    @Override
    public DatacenterBroker setVmDestructionDelayFunction(Function<Vm, Double> function) {
        this.vmDestructionDelayFunction = function == null ? DEF_VM_DESTRUCTION_DELAY_FUNCTION : function;
        return this;
    }

    @Override
    public List<Cloudlet> getCloudletSubmittedList() {
        return this.cloudletSubmittedList;
    }

    protected Datacenter closestDatacenterMapper(Datacenter lastDatacenter, Vm vm) {
        return TimeZoned.closestDatacenter(vm, this.getDatacenterList());
    }

    protected abstract Datacenter defaultDatacenterMapper(Datacenter var1, Vm var2);

    protected abstract Vm defaultVmMapper(Cloudlet var1);

    @Override
    public <T extends Vm> List<T> getVmFailedList() {
        return this.vmFailedList;
    }

    @Override
    public boolean isRetryFailedVms() {
        return this.retryFailedVms;
    }

    @Override
    public void setRetryFailedVms(boolean retryFailedVms) {
        this.retryFailedVms = retryFailedVms;
    }
}

