/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudbus.cloudsim.cloudlets.network.CloudletTask;
import org.cloudbus.cloudsim.network.VmPacket;
import org.cloudbus.cloudsim.vms.Vm;

public class CloudletReceiveTask
extends CloudletTask {
    private final List<VmPacket> packetsReceived = new ArrayList<VmPacket>();
    private long expectedPacketsToReceive;
    private final Vm sourceVm;

    public CloudletReceiveTask(int id, Vm sourceVm) {
        super(id);
        this.sourceVm = sourceVm;
    }

    public void receivePacket(VmPacket packet) {
        packet.setReceiveTime(this.getCloudlet().getSimulation().clock());
        this.packetsReceived.add(packet);
        boolean finished = (long)this.packetsReceived.size() >= this.expectedPacketsToReceive;
        this.setFinished(finished);
    }

    public List<VmPacket> getPacketsReceived() {
        return Collections.unmodifiableList(this.packetsReceived);
    }

    public Vm getSourceVm() {
        return this.sourceVm;
    }

    public long getExpectedPacketsToReceive() {
        return this.expectedPacketsToReceive;
    }

    public void setExpectedPacketsToReceive(long expectedPacketsToReceive) {
        this.expectedPacketsToReceive = expectedPacketsToReceive;
    }
}

